<?php
session_start();
require_once("classconexion.php");
include_once('funciones_basicas.php');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

/* Clase principal de PHPMailer */
require("PHPMailer/PHPMailer.php");

/* Clase SMTP, necesaria si quieres usar SMTP */
require("PHPMailer/SMTP.php");

/* Clase Exception */
require("PHPMailer/Exception.php");

// Motrar todos los errores de PHP
error_reporting(E_ALL);//muestro errores
//error_reporting(0);//desactivo errores
ini_set('display_errors', '1');

//evita el error Fatal error: Allowed memory size of X bytes exhausted (tried to allocate Y bytes)...
ini_set('memory_limit', '-1'); 
// es lo mismo que set_time_limit(300) ;
ini_set('max_execution_time', 3800); 

############################################ CLASE LOGIN #############################################
class Login extends Db
{
public function __construct()
{
	parent::__construct();
} 	

########################### FIN DE CLASE LOGUEO ###############################

##########################  FUNCION PARA EXPIRAR SESSION POR INACTIVIDAD #######################
public function ExpiraSession()
{
   if(!isset($_SESSION['usuario'])){// Esta logeado?.
		header("Location: logout.php"); 
	}
	//Verifico el tiempo si esta seteado, caso contrario lo seteo.
	if(isset($_SESSION['time'])){
		$tiempo = limpiar($_SESSION['time']);
	} else {
		$tiempo = strtotime(date("Y-m-d H:i:s"));
	}

   //Verifico el tiempo si esta seteado, caso contrario lo seteo.
   $inactividad = 7200; //(1 hora de cierre sesion )600 equivale a 10 minutos
   $actual      = time();
   $tiempo = (isset($_SESSION['time']) ? $_SESSION['time'] : strtotime(date("Y-m-d H:i:s")));

   if ($actual-$tiempo >= $inactividad) { ?>
      <script type='text/javascript'>
         alert("SU SESSION A EXPIRADO \nPOR FAVOR LOGUEESE DE NUEVO PARA ACCEDER AL SISTEMA");
         document.location.href = "logout";
      </script>
<?php 
   } else {
      $_SESSION['time'] = $actual;
   }
}
########################## FUNCION PARA EXPIRAR SESSION POR INACTIVIDAD #######################

###################### FUNCION PARA ACCEDER AL SISTEMA DE GESTIÓN ACADÉMICA #######################
public function Logueo()
{
	self::SetNames();
	if(empty($_POST["usuario"]) or empty($_POST["password"]) or empty($_POST["tipo_acceso"]))
	{
	   echo "1";
	   exit;
	}

	if (decrypt($_POST['tipo_acceso']) == 1) {

	$sql = "SELECT * FROM usuarios WHERE usuario = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST["usuario"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	   echo "2";
	   exit;

	} else {
			
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[]=$row;
		}

		if (limpiar($row['status']) != 'ACTIVO')
		{  
			echo "3";
			exit;
		} 
		elseif (password_verify($_POST["password"], $row['password'])) {

		######### DATOS DEL USUARIO ###########
		$_SESSION["codigo"] = $p[0]["codigo"];
		$_SESSION["cedula"] = $p[0]["cedula"];
		$_SESSION["nombres"] = $p[0]["nombres"];
		$_SESSION["sexo"] = $p[0]["sexo"];
		$_SESSION["cargo"] = $p[0]["cargo"];
		$_SESSION["email"] = $p[0]["email"];
		$_SESSION["usuario"] = $p[0]["usuario"];
		$_SESSION["password"] = $p[0]["password"];
		$_SESSION["nivel"] = $p[0]["nivel"];
		$_SESSION["status"] = $p[0]["status"];
	   $_SESSION["tipo_acceso"] = $_POST['tipo_acceso'];
	   ######### DATOS DEL USUARIO ###########
		
		############### REGISTRO LOGS DE ACCESO ###############
		$query = "INSERT INTO log values (null, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1,$a);
		$stmt->bindParam(2,$b);
		$stmt->bindParam(3,$c);
		$stmt->bindParam(4,$d);
		$stmt->bindParam(5,$e);
		
		$a = limpiar($_SERVER['REMOTE_ADDR']);
		$b = limpiar(date("Y-m-d h:i:s"));
		$c = limpiar($_SERVER['HTTP_USER_AGENT']);
		$d = limpiar($_SERVER['PHP_SELF']);
		$e = limpiar($_POST["usuario"]);
		$stmt->execute();
		############### REGISTRO LOGS DE ACCESO ###############

		switch($_SESSION["nivel"])
		{
		   case 'ADMINISTRADOR(A)':
	      $_SESSION["acceso"]="administrador";
		   ?>
			<script type="text/javascript">
	      window.location="panel";
	      </script>
		   <?php
		   break;
		   case 'SECRETARIA':
		   $_SESSION["acceso"]="secretaria";
			?>
			<script type="text/javascript">
	      window.location="panel";
	      </script>
			<?php
			break;
		}//end switch	

	} else {

  	   echo "4";
  	   exit;
    }
    
    } //USUARIO   

    } else if (decrypt($_POST['tipo_acceso']) == 2) {

	$sql = "SELECT * FROM docentes WHERE ceddoc = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST["usuario"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		echo "2";
		exit;

	} else {
			
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[]=$row;
		}
		if (password_verify($_POST["password"], $row['clavedoc'])) {
	
		################## DATOS DE ACCESO ##################
		$_SESSION["coddoc"] = $p[0]["coddoc"];
		$_SESSION["ceddoc"] = $p[0]["ceddoc"];
		$_SESSION["nomdoc"] = $p[0]["nomdoc"];
		$_SESSION["nombres"] = $p[0]["nomdoc"];
		$_SESSION["tlfdoc"] = $p[0]["tlfdoc"];
		$_SESSION["direcdoc"] = $p[0]["direcdoc"];
		$_SESSION["especdoc"] = $p[0]["especdoc"];
		$_SESSION["fecnacdoc"] = $p[0]["fecnacdoc"];
		$_SESSION["edocivildoc"] = $p[0]["edocivildoc"];
		$_SESSION["lugarnacdoc"] = $p[0]["lugarnacdoc"];
		$_SESSION["correodoc"] = $p[0]["correodoc"];
		$_SESSION["expedido"] = $p[0]["expedido"];
		$_SESSION["horasdoc"] = $p[0]["horasdoc"];
		$_SESSION["codcargodoc"] = $p[0]["codcargodoc"];
		$_SESSION["usuario"] = $p[0]["ceddoc"];
		$_SESSION["password"] = $p[0]["clavedoc"];
		$_SESSION["nivel"] = "DOCENTE";
		$_SESSION["tipo_acceso"] = $_POST['tipo_acceso'];
		$_SESSION["ingreso"] = limpiar(date("d-m-Y h:i:s A"));
		################## DATOS DE ACCESO ##################

		############### REGISTRO LOGS DE ACCESO ###############
		$query = "INSERT INTO log values (null, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1,$a);
		$stmt->bindParam(2,$b);
		$stmt->bindParam(3,$c);
		$stmt->bindParam(4,$d);
		$stmt->bindParam(5,$e);

		$a = limpiar($_SERVER['REMOTE_ADDR']);
		$b = limpiar(date("Y-m-d h:i:s"));
		$c = limpiar($_SERVER['HTTP_USER_AGENT']);
		$d = limpiar($_SERVER['PHP_SELF']);
		$e = limpiar($_POST["usuario"]);
		$stmt->execute();
		############### REGISTRO LOGS DE ACCESO ###############

		switch($_SESSION["nivel"])
		{
			case 'DOCENTE':
			$_SESSION["acceso"]="docente";
			?>
			<script type="text/javascript">
			window.location="panel";
			</script>
			<?php
			break;
		}//end switch

	   } else {

  	      echo "4";
  	      exit;
	   }

   } //CERRAR DOCENTE 

   } else if (decrypt($_POST['tipo_acceso']) == 3) {// SI TIPO INGRESO ES ESTUDIANTE

   $sql = "SELECT
   estudiantes.*,
   turnos.turno,
   niveles.nivel,
   grados.grado,
   secciones.seccion,
   periodoescolar.periodo
   FROM estudiantes 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
	WHERE estudiantes.cedest = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST["usuario"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		echo "2";
		exit;

	} else {
			
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[]=$row;
		}
		if (password_verify($_POST["password"], $row['claveest'])) {
	
		################## DATOS DE ACCESO ##################
		$_SESSION["codpadre"] = $p[0]["codpadre"];
		$_SESSION["codest"] = $p[0]["codest"];
		$_SESSION["cedest"] = $p[0]["cedest"];
		$_SESSION["pnomest"] = $p[0]["pnomest"];
		$_SESSION["snomest"] = $p[0]["snomest"];
		$_SESSION["papeest"] = $p[0]["papeest"];
		$_SESSION["sapeest"] = $p[0]["sapeest"];
		$_SESSION["nombres"] = $p[0]["pnomest"]." ".$p[0]["snomest"]." ".$p[0]["papeest"]." ".$p[0]["sapeest"];
		$_SESSION["sexoest"] = $p[0]["sexoest"];
		$_SESSION["direcest"] = $p[0]["direcest"];
		$_SESSION["fnacest"] = $p[0]["fnacest"];
		$_SESSION["codturno"] = $p[0]["codturno"];
		$_SESSION["codnivel"] = $p[0]["codnivel"];
		$_SESSION["codgrado"] = $p[0]["codgrado"];
		$_SESSION["codseccion"] = $p[0]["codseccion"];
		$_SESSION["codperiodo"] = $p[0]["codperiodo"];
		$_SESSION["becado"] = $p[0]["becado"];
		$_SESSION["usuario"] = $p[0]["cedest"];
		$_SESSION["password"] = $p[0]["claveest"];
		$_SESSION["nivel"] = "ESTUDIANTE";
		$_SESSION["tipo_acceso"] = $_POST['tipo_acceso'];
		$_SESSION["ingreso"] = limpiar(date("d-m-Y h:i:s A"));
		################## DATOS DE ACCESO ##################

		############### REGISTRO LOGS DE ACCESO ###############
		$query = "INSERT INTO log values (null, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1,$a);
		$stmt->bindParam(2,$b);
		$stmt->bindParam(3,$c);
		$stmt->bindParam(4,$d);
		$stmt->bindParam(5,$e);

		$a = limpiar($_SERVER['REMOTE_ADDR']);
		$b = limpiar(date("Y-m-d h:i:s"));
		$c = limpiar($_SERVER['HTTP_USER_AGENT']);
		$d = limpiar($_SERVER['PHP_SELF']);
		$e = limpiar($_POST["usuario"]);
		$stmt->execute();
		############### REGISTRO LOGS DE ACCESO ###############

		switch($_SESSION["nivel"])
		{
			case 'ESTUDIANTE':
			$_SESSION["acceso"]="estudiante";
			?>
			<script type="text/javascript">
			window.location="panel";
			</script>
			<?php
			break;
		}//end switch

	   } else {

  	      echo "4";
  	      exit;
	   }

   } //CERRAR ESTUDIANTE 

   } else {

    	echo "5";
    	exit;
   }
}
###################### FUNCION PARA ACCEDER AL SISTEMA DE GESTIÓN ACADÉMICA #######################

############################ FUNCION DATOS SESSION ID #################################
public function SessionPorId()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administrador" || $_SESSION['acceso'] == "secretaria" || $_SESSION['acceso'] == "asesor") {

		$sql = "SELECT * FROM usuarios
		WHERE codigo = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($_SESSION["codigo"])));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "";
		}
		else
		{
			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[] = $row;
			}
			return $this->p;
			$this->dbh=null;
		}

	} elseif ($_SESSION['acceso'] == "docente") {

		$sql = "SELECT * FROM docentes
		WHERE coddoc = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($_SESSION["coddoc"])));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "";
		}
		else
		{
			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[] = $row;
			}
			return $this->p;
			$this->dbh=null;
		}

	} elseif ($_SESSION['acceso'] == "estudiante") {

		$sql = "SELECT 
		estudiantes.*,
		padres.cedpadre,
		padres.nompadre,
		padres.nompadre,
		padres.apepadre,
		padres.tlfpadre,
		turnos.turno,
		niveles.nivel,
		grados.grado,
		secciones.seccion,
		periodoescolar.periodo
		FROM estudiantes 
	   LEFT JOIN padres ON estudiantes.codpadre = padres.codpadre 
	   LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	   LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	   LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	   LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	   LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
		WHERE estudiantes.codest = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($_SESSION["codest"])));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "";
		}
		else
		{
			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[] = $row;
			}
			return $this->p;
			$this->dbh=null;
		}
   }
}
############################ FUNCION DATOS SESSION ID #################################

########################### FIN DE CLASE LOGUEO ###############################












################################ FUNCION RECUPERAR Y ACTUALIZAR PASSWORD ###############################

################################## FUNCION PARA RECUPERAR CLAVE ###################################
public function RecuperarPassword()
	{
	self::SetNames();
	if(empty($_POST["email"]))
	{
		echo "1";
		exit;
	}
	################## DATOS DE CONFIGURACION #####################
	$sql = "SELECT * FROM configuracion";
	foreach ($this->dbh->query($sql) as $row)
	{
	   $this->p[] = $row;
	}
   $cuitsucursal = $row['codinstituto'];
   $nomsucursal = $row['nominstituto'];
   $correosucursal = $row['correoinstituto'];
   ################## DATOS DE CONFIGURACION #####################
   
	if (decrypt($_POST['tipo_usuario']) == 1) {
	
		################# OBTENGO DATOS DE USUARIO #################
		$sql = "SELECT 
		codigo, 
		nombres, 
		email 
		FROM usuarios WHERE email = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["email"]));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "2";
		   exit;
		}
		else
		{
			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$pa[] = $row;
			}
			$id = $pa[0]["codigo"];
			$nombres = $pa[0]["nombres"];
		   $email = $pa[0]["email"];
		   $pass = strtoupper(generar_clave(10));
		}
		################# OBTENGO DATOS DE USUARIO #################

	} else if (decrypt($_POST['tipo_usuario']) == 2) {

		################# OBTENGO DATOS DE DOCENTE #################
		$sql = "SELECT 
		coddoc, 
		nomdoc, 
		correodoc 
		FROM docentes WHERE correodoc = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["email"]));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "2";
			exit;
		}
		else
		{
			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$pa[] = $row;
			}
			$id = $pa[0]["coddoc"];
			$nombres = $pa[0]["nomdoc"];
			$email = $pa[0]["correodoc"];
			$pass = strtoupper(generar_clave(10));
		}
		################# OBTENGO DATOS DE DOCENTE #################

	} else if (decrypt($_POST['tipo_usuario']) == 3) {

		################# OBTENGO DATOS DE DOCENTE #################
		$sql = "SELECT 
		codest,
		CONCAT(pnomest, ' ',snomest, ' ',papeest, ' ',sapeest) AS nombres,
		correoest 
		FROM estudiantes WHERE correoest = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_POST["email"]));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "2";
			exit;
		}
		else
		{
			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$pa[] = $row;
			}
			$id = $pa[0]["codest"];
			$nombres = $pa[0]["nombres"];
			$email = $pa[0]["correoest"];
			$pass = strtoupper(generar_clave(10));
		}
		################# OBTENGO DATOS DE DOCENTE #################
	}
	#################### VALIDACION DE ENVIO DE CORREO CON PHPMAILER ####################
   //Create a new PHPMailer instance
   $mail = new PHPMailer(TRUE);

   $mail->isSMTP();// Set mailer to use SMTP
	$mail->CharSet = 'UTF-8';
	$mail->SMTPAuth = true;// Enable SMTP authentication
	$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;// Enable TLS encryption, `ssl` also accepted

	$mail->Host = 'smtp.gmail.com';// Specify main and backup SMTP servers
	$mail->Port = 587;// TCP port to connect to
	$mail->SMTPDebug = 0;
	$mail->SMTPOptions = array(
	    'ssl' => array(
	        'verify_peer' => false,
	        'verify_peer_name' => false,
	        'allow_self_signed' => true
	    )
	);
	$mail->isHTML(true);// Set email format to HTML

	$mail->Username = 'estuardo@netronica.com.gt';// SMTP username
	$mail->Password = 'Riah$2024';// SMTP password

	$mail->setFrom($correosucursal, $nomsucursal);//Your application NAME and EMAIL
	$mail->AddReplyTo('no-reply@netronica.com.gt','no-reply');
	$mail->Subject = 'Nueva Clave de Acceso';//Message subject

	# establecemos un limite de caracteres de anchura
	$mail->WordWrap   = 50; // set word wrap

	# NOTA: Los correos es conveniente enviarlos en formato HTML y Texto para que
	# cualquier programa de correo pueda leerlo.

	# Definimos el contenido HTML del correo
	$contenidoHTML="<head>";
	$contenidoHTML.="<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
	$contenidoHTML.="</head><body>";
	$contenidoHTML.="<b>Recuperación de Contraseña</b>";
	$contenidoHTML.="<p>$nombres</p>";
	$contenidoHTML.="<p>Su Nueva Contraseña de Acceso es: <b>$pass</b></p>";
	$contenidoHTML.="</body>\n";

	# Definimos el contenido en formato Texto del correo
	$contenidoTexto= " Recuperación de Contraseña";
	$contenidoTexto.="\n\n";
	
	# Indicamos el contenido
	$mail->AltBody=$contenidoTexto; //Text Body
	$mail->MsgHTML($contenidoHTML); //Text body HTML

	$mail->addAddress($email,str_replace(" ", "_",$nombres));// Target email
   $mail->AddAttachment("fotos/logo_principal.png", "img.png");
	#################### VALIDACION DE ENVIO DE CORREO CON PHPMAILER ####################

	if(!$mail->send()) {

	   //Mensaje no pudo ser enviado
	   echo "3";
		exit;

	} else {

		if (decrypt($_POST['tipo_usuario']) == 1) {

			################# ACTUALIZO CLAVE DE USUARIO #################
			$sql = " UPDATE usuarios set "
			  ." password = ? "
			  ." WHERE "
			  ." codigo = ?;
			   ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $password);
		   $stmt->bindParam(2, $codigo);
			
		   $codigo = $id;
		   $password = password_hash($pass, PASSWORD_DEFAULT);
		   $stmt->execute();
		   ################# ACTUALIZO CLAVE DE USUARIO #################

		} else if (decrypt($_POST['tipo_usuario']) == 2) {

			################# ACTUALIZO CLAVE DE DOCENTE #################
			$sql = "UPDATE docentes set "
			." clavedoc = ? "
			." WHERE "
			." coddoc = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $password);
			$stmt->bindParam(2, $codigo);

			$codigo = $id;
			$password = password_hash($pass, PASSWORD_DEFAULT);
			$stmt->execute();
			################# ACTUALIZO CLAVE DE DOCENTE #################
		}

	   echo "<span class='fa fa-check-square-o'></span> SU NUEVA CLAVE DE ACCESO LE FUE ENVIADA A SU CORREO ELECTRONICO EXITOSAMENTE";
	   exit;
	}
}	
################################## FUNCION PARA RECUPERAR CLAVE ###################################

############################# FUNCION PARA ACTUALIZAR PASSWORD  ##################################
public function ActualizarPassword()
{
	self::SetNames();
	if(empty($_POST["codigo"]) or empty($_POST["cedula"]) or empty($_POST["password"]))
	{
		echo "1";
		exit;
	} 
	elseif (password_verify($_POST["password"], $_SESSION['password']))
	{
	   echo "2";
	   exit;
   } 
   elseif(limpiar($_POST["password"]) != limpiar($_POST["password2"]))
   {
	   echo "3";
	   exit;
   }

   if ($_SESSION['acceso'] == "administrador" || $_SESSION["acceso"]=="secretaria") {

		#################### ACTUALIZO CLAVE ####################
		$sql = " UPDATE usuarios set "
			  ." usuario = ?, "
			  ." password = ? "
			  ." WHERE "
			  ." codigo = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $usuario);
		$stmt->bindParam(2, $password);
		$stmt->bindParam(3, $codigo);	
			
		$usuario = limpiar($_POST["usuario"]);
		$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
		$codigo = limpiar(decrypt($_POST["codigo"]));
		$stmt->execute();
		#################### ACTUALIZO CLAVE ####################

	} elseif ($_SESSION['acceso'] == "docente") {

		#################### ACTUALIZO CLAVE ####################
		$sql = "UPDATE docentes set "
		." clavedoc = ? "
		." WHERE "
		." coddoc = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $password);
		$stmt->bindParam(2, $codigo);	

		$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
		$codigo = limpiar(decrypt($_POST["codigo"]));
		$stmt->execute();
		#################### ACTUALIZO CLAVE ####################

	} elseif ($_SESSION['acceso'] == "estudiante") {

		#################### ACTUALIZO CLAVE ####################
		$sql = "UPDATE estudiantes set "
		." claveest = ? "
		." WHERE "
		." codest = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $password);
		$stmt->bindParam(2, $codigo);	

		$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
		$codigo = limpiar(decrypt($_POST["codigo"]));
		$stmt->execute();
		#################### ACTUALIZO CLAVE ####################
	}

	echo "<span class='fa fa-check-square-o'></span> SU CLAVE DE ACCESO FUE ACTUALIZADA EXITOSAMENTE, SER&Aacute; EXPULSADO DE SU SESI&Oacute;N Y DEBER&Aacute; DE ACCEDER NUEVAMENTE";
	?>
	<script>
   function redireccionar(){location.href="logout.php";}
   setTimeout ("redireccionar()", 3000);
   </script>
	<?php
	exit;
}
############################# FUNCION PARA ACTUALIZAR PASSWORD  ##################################

############################## FUNCION RECUPERAR Y ACTUALIZAR PASSWORD ##############################





















############################# FUNCION CONFIGURACION GENERAL DEL SISTEMA ##################################

########################### FUNCION ID CONFIGURACION DEL SISTEMA #########################
public function ConfiguracionPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM configuracion WHERE id = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array('1'));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION ID CONFIGURACION DEL SISTEMA #########################

########################### FUNCION  ACTUALIZAR CONFIGURACION ##############################
public function ActualizarConfiguracion()
{
	
	if(empty($_POST["ceddirector"]) or empty($_POST["director"]) or empty($_POST["codinstituto"]))
	{
		echo "1";
		exit;
	}
	######################## ACTUALIZO CONFIGURACION ########################
	$sql = " UPDATE configuracion set "
		  ." ceddirector = ?, "
		  ." director = ?, "
		  ." tlfdirec = ?, "
		  ." correodirec = ?, "
		  ." codinstituto = ?, "
		  ." nominstituto = ?, "
		  ." direcinstituto = ?, "
		  ." tlfinstituto = ?, "
		  ." correoinstituto = ?, "
		  ." inicioinscripcion = ?, "
		  ." fininscripcion = ?, "
		  ." trimestreactivo = ?, "
		  ." inicionotas = ?, "
		  ." finnotas = ?, "
		  ." diascrealapso = ?, "
		  ." cobrar_cuotas = ? "
		  ." WHERE "
		  ." id = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $ceddirector);
	$stmt->bindParam(2, $director);
	$stmt->bindParam(3, $tlfdirec);
	$stmt->bindParam(4, $correodirec);
	$stmt->bindParam(5, $codinstituto);
	$stmt->bindParam(6, $nominstituto);
	$stmt->bindParam(7, $direcinstituto);
	$stmt->bindParam(8, $tlfinstituto);
	$stmt->bindParam(9, $correoinstituto);
	$stmt->bindParam(10, $inicioinscripcion);
	$stmt->bindParam(11, $fininscripcion);
	$stmt->bindParam(12, $trimestreactivo);
	$stmt->bindParam(13, $inicionotas);
	$stmt->bindParam(14, $finnotas);
	$stmt->bindParam(15, $diascrealapso);
	$stmt->bindParam(16, $cobrar_cuotas);
	$stmt->bindParam(17, $id);
		
	$ceddirector = limpiar($_POST["ceddirector"]);
	$director = limpiar($_POST["director"]);
	$tlfdirec = limpiar($_POST["tlfdirec"]);
	$correodirec = limpiar($_POST["correodirec"]);
	$codinstituto = limpiar($_POST["codinstituto"]);
	$nominstituto = limpiar($_POST["nominstituto"]);
	$direcinstituto = limpiar($_POST["direcinstituto"]);
	$tlfinstituto = limpiar($_POST["tlfinstituto"]);
	$correoinstituto = limpiar($_POST["correoinstituto"]);
	$inicioinscripcion = limpiar(date("Y-m-d",strtotime($_POST['inicioinscripcion'])));
	$fininscripcion = limpiar(date("Y-m-d",strtotime($_POST['fininscripcion'])));
	$trimestreactivo = limpiar($_POST["trimestreactivo"]);
	$inicionotas = limpiar(date("Y-m-d",strtotime($_POST['desde'])));
	$finnotas = limpiar(date("Y-m-d",strtotime($_POST['hasta'])));
	$diascrealapso = limpiar($_POST["diascrealapso"]);
	$cobrar_cuotas = limpiar($_POST["cobrar_cuotas"]);
	$id = limpiar($_POST["id"]);
	$stmt->execute();
	######################## ACTUALIZO CONFIGURACION ########################

	######################## SUBIR LOGO ########################
   //datos del arhivo 
   $nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
	$tipo_archivo = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
	$tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");
   //compruebo si las características del archivo son las que deseo  
	if ((strpos($tipo_archivo,'image/png')!==false)&&$tamano_archivo<2097152)// 2MB 
	{  
		if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/logo_principal.png"))
		{ 
		## se puede dar un aviso
		} 
		## se puede dar otro aviso 
	}
	######################## SUBIR LOGO ########################

	######################## SUBIR FIRMA ########################
   //datos del arhivo 
   $nombre_archivo2 = limpiar(isset($_FILES['imagen2']['name']) ? $_FILES['imagen2']['name'] : "");
	$tipo_archivo2 = limpiar(isset($_FILES['imagen2']['type']) ? $_FILES['imagen2']['type'] : "");
	$tamano_archivo2 = limpiar(isset($_FILES['imagen2']['size']) ? $_FILES['imagen2']['size'] : "");
   //compruebo si las características del archivo son las que deseo  
	if ((strpos($tipo_archivo2,'image/png')!==false)&&$tamano_archivo2<2097152)// 2MB 
	{  
		if (move_uploaded_file($_FILES['imagen2']['tmp_name'], "fotos/".$nombre_archivo2) && rename("fotos/".$nombre_archivo2,"fotos/firma.png"))
		{ 
		## se puede dar un aviso
		} 
		## se puede dar otro aviso 
	}
	######################## SUBIR FIRMA ########################
		
	echo "<span class='fa fa-check-square-o'></span> LOS DATOS DE CONFIGURACI&Oacute;N DEL SISTEMA FUERON ACTUALIZADOS EXITOSAMENTE";
   exit;
}
########################### FUNCION  ACTUALIZAR CONFIGURACION ##############################
	
############################ FIN DE FUNCION CONFIGURACION GENERAL DEL SISTEMA ########################





























####################################### CLASE USUARIOS #############################################

################################## FUNCION REGISTRAR USUARIOS ###############################
public function RegistrarUsuarios()
{
	self::SetNames();
	if(empty($_POST["cedula"]) or empty($_POST["nombres"]) or empty($_POST["usuario"]) or empty($_POST["password"]) or empty($_POST["nivel"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT cedula FROM usuarios WHERE cedula = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["cedula"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
	   echo "2";
	   exit;
	}
	else
	{
	$sql = "SELECT email FROM usuarios WHERE email = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["email"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
	   echo "3";
	   exit;
	}
	$sql = "SELECT usuario FROM usuarios WHERE usuario = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["usuario"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO usuarios values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cedula);
		$stmt->bindParam(2, $nombres);
		$stmt->bindParam(3, $telefono);
		$stmt->bindParam(4, $sexo);
		$stmt->bindParam(5, $cargo);
		$stmt->bindParam(6, $email);
		$stmt->bindParam(7, $usuario);
		$stmt->bindParam(8, $password);
		$stmt->bindParam(9, $nivel);
		$stmt->bindParam(10, $status);
		
		$cedula = limpiar($_POST["cedula"]);
		$nombres = limpiar($_POST["nombres"]);
		$telefono = limpiar($_POST["telefono"]);
		$sexo = limpiar($_POST["sexo"]);
		$cargo = limpiar($_POST["cargo"]);
		$email = limpiar($_POST["email"]);
		$usuario = limpiar($_POST["usuario"]);
		$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
		$nivel = limpiar($_POST["nivel"]);
		$status = limpiar($_POST["status"]);
		$stmt->execute();
		
		######################### SUBIR FOTO DE USUARIOS #########################
      //datos del arhivo  
      $nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
      $tipo_archivo = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
      $tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : ""); 
      //compruebo si las características del archivo son las que deseo  
		if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<2097152)// 2MB 
		{  
		   if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/".$_POST["cedula"].".jpg"))
		   { 
		   ## se puede dar un aviso
		   } 
		   ## se puede dar otro aviso 
		}
		######################### SUBIR FOTO DE USUARIOS #########################

	      echo "<span class='fa fa-check-square-o'></span> EL USUARIO HA SIDO REGISTRADO EXITOSAMENTE";
	      exit;
		}
		else
		{
			echo "4";
			exit;

		}
	}
}
################################## FUNCION REGISTRAR USUARIOS ###############################

################################## FUNCION LISTAR USUARIOS ################################
public function ListarUsuarios()
{
	self::SetNames();
	$sql = "SELECT * FROM usuarios ";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
################################## FUNCION LISTAR USUARIOS ################################

############################ FUNCION LISTAR LOGS DE USUARIOS #############################
public function ListarLogs()
{
	self::SetNames();
	if($_SESSION['acceso'] == "administrador") {

		$sql = "SELECT * FROM log ORDER BY tiempo DESC ";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
		
	} else {
	         
		$sql = "SELECT * FROM log WHERE usuario = '".$_SESSION["usuario"]."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION LISTAR LOGS DE USUARIOS #############################

############################ FUNCION ID USUARIOS #################################
public function UsuariosPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM usuarios WHERE codigo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codigo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID USUARIOS #################################
	
############################ FUNCION ACTUALIZAR USUARIOS ############################
public function ActualizarUsuarios()
{
	if(empty($_POST["cedula"]) or empty($_POST["nombres"]) or empty($_POST["usuario"]) or empty($_POST["password"]))
	{
		echo "1";
		exit;
	}
	self::SetNames();
	$sql = "SELECT * FROM usuarios WHERE codigo != ? and cedula = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codigo"]), $_POST["cedula"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
	   echo "2";
	   exit;
	}
	else
	{
	$sql = "SELECT email FROM usuarios WHERE codigo != ? and email = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codigo"]), $_POST["email"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
	   echo "3";
	   exit;
	}
	$sql = "SELECT usuario FROM usuarios WHERE codigo != ? and usuario = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codigo"]), $_POST["usuario"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE usuarios set "
			  ." cedula = ?, "
			  ." nombres = ?, "
			  ." telefono = ?, "
			  ." sexo = ?, "
			  ." cargo = ?, "
			  ." email = ?, "
			  ." usuario = ?, "
			  ." password = ?, "
			  ." nivel = ?, "
			  ." status = ? "
			  ." WHERE "
			  ." codigo = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $cedula);
		$stmt->bindParam(2, $nombres);
		$stmt->bindParam(3, $telefono);
		$stmt->bindParam(4, $sexo);
		$stmt->bindParam(5, $cargo);
		$stmt->bindParam(6, $email);
		$stmt->bindParam(7, $usuario);
		$stmt->bindParam(8, $password);
		$stmt->bindParam(9, $nivel);
		$stmt->bindParam(10, $status);
		$stmt->bindParam(11, $codigo);
			
		$cedula = limpiar($_POST["cedula"]);
		$nombres = limpiar($_POST["nombres"]);
		$telefono = limpiar($_POST["telefono"]);
		$sexo = limpiar($_POST["sexo"]);
		$cargo = limpiar($_POST["cargo"]);
		$email = limpiar($_POST["email"]);
		$usuario = limpiar($_POST["usuario"]);
		$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
		$nivel = limpiar($_POST["nivel"]);
		$status = limpiar($_POST["status"]);
		$codigo = limpiar(decrypt($_POST["codigo"]));
		$stmt->execute();
		
		######################### SUBIR FOTO DE USUARIOS #########################
	   //datos del arhivo  
	   $nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
	   $tipo_archivo = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
	   $tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : ""); 
	   //compruebo si las características del archivo son las que deseo  
		if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<2097152)// 2MB  
		{  
		   if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/".$_POST["cedula"].".jpg"))
		   { 
		   ## se puede dar un aviso
		   } 
		   ## se puede dar otro aviso 
		}
		######################### SUBIR FOTO DE USUARIOS #########################
		
      echo "<span class='fa fa-check-square-o'></span> EL USUARIO HA SIDO ACTUALIZADO EXITOSAMENTE";
	   exit;
	   }
		else
		{
			echo "4";
			exit;
		}
	}
}
############################ FUNCION ACTUALIZAR USUARIOS ############################

################################ FUNCION ELIMINAR USUARIOS #################################
public function EliminarUsuarios()
{
	$sql = "SELECT codigo FROM detallespagos  WHERE codigo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codigo"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

	$sql = "DELETE FROM usuarios WHERE codigo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codigo);
	$codigo = decrypt($_GET["codigo"]);
	$stmt->execute();
		
		echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
}
################################ FUNCION ELIMINAR USUARIOS #################################

################################## FIN DE CLASE USUARIOS #########################################




























##################################### CLASE PERIODO ESCOLAR ####################################

######################### FUNCION REGISTRAR PERIODO ESCOLAR #############################
public function RegistrarPeriodoEscolar() 
{
	self::SetNames();
	if(empty($_POST["periodo"]) or empty($_POST["descripcion"]) or empty($_POST["password"]))
	{
	   echo "1";
	   exit;
	}
	if (!password_verify($_POST["password"], $_SESSION['password'])) 
	{
	   echo "2";
		exit; 
	}
	############# OBTENGO DATOS DE CONFIGURACION #############
	$conf = "SELECT * FROM configuracion";
	foreach ($this->dbh->query($conf) as $rowcon)
	{
		$this->pcon[] = $rowcon;
	}
	$cobrar_cuotas = (empty($rowcon['cobrar_cuotas']) ? 0 : $rowcon['cobrar_cuotas']);
	############# OBTENGO DATOS DE CONFIGURACION #############	

	if ($cobrar_cuotas == 1 && $_POST["mesesactivos"] == "") 
	{
	   echo "3";
		exit; 
	}
			
	$sql = "SELECT * FROM periodoescolar";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
      ############## REGISTRO NUEVO PERIODO ##############
      $query = "INSERT INTO periodoescolar values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $periodo);
		$stmt->bindParam(2, $descripcion);
		$stmt->bindParam(3, $fechacreado);
		$stmt->bindParam(4, $mesesactivos);
		$stmt->bindParam(5, $montoinscripcion);
		$stmt->bindParam(6, $interesmora);
		$stmt->bindParam(7, $cuotaunica);
		$stmt->bindParam(8, $diasvence);
		$stmt->bindParam(9, $statusperiodo);
		
		$periodo = limpiar($_POST["periodo"]);
		$descripcion = limpiar($_POST["descripcion"]);
		$fechacreado = limpiar(date("Y-m-d"));
	   $mesesactivos = ($cobrar_cuotas == 1 ? implode(", ",$_POST["mesesactivos"]) : "0");
		$montoinscripcion = limpiar($_POST["montoinscripcion"]);
		$interesmora = limpiar($_POST["interesmora"]);
		$cuotaunica = limpiar($_POST["cuotaunica"]);
		$diasvence = limpiar($_POST["diasvence"]);
		$statusperiodo = limpiar("1");
		$stmt->execute();
		############## REGISTRO NUEVO PERIODO ##############
			
      echo "<span class='fa fa-check-square-o'></span> EL PERIODO ESCOLAR HA SIDO CREADO EXITOSAMENTE ";
		exit;
			
	} else {
		
		### CONSULTO LA BASE DE DATOS PARA SABER LA FECHA DEL ULTIMO LAPSO CREADO
		$sql = "SELECT * FROM periodoescolar ORDER BY codperiodo DESC";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$fechacr = $row['fechacreado'];
				
		### BUSCO LA DIFERENCIA ENTRE LAS 2 FECHAS
		$fecha1 = date_create($fechacr);
		$fecha2 = date_create(date('Y-m-d'));
		$result = date_diff($fecha1, $fecha2);
		$dif = $result->format('%a');
		
		### CONSULTA LA BASE DE DATOS PARA SABER A CUANTOS DIAS ESTA CONFIGURADO PODER CREAR OTRO LAPSO
      $sql2 = "SELECT diascrealapso FROM configuracion";
		foreach ($this->dbh->query($sql2) as $row2)
		{
			$this->p2[] = $row2;
		}
		$diascrealapso = $row2['diascrealapso'];		
		
	   if($dif < $diascrealapso) {
		
		   echo "4";
			exit; 
		
		} else {
		
			$sql = "SELECT periodo FROM periodoescolar WHERE periodo = ? ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($_POST["periodo"]));
			$num = $stmt->rowCount();
			if($num == 0)
			{    
			
		   ############## ACTUALIZO STATUS DE PERIODO ANTERIOR ##############
		   $sql = " UPDATE periodoescolar set "
		      ." statusperiodo = ?;
			   ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1,$statusperiodo);		
		   $statusperiodo = limpiar("0");
		   $stmt->execute();
		   ############## ACTUALIZO STATUS DE PERIODO ANTERIOR ##############
		
		   ############## REGISTRO NUEVO PERIODO ##############
		   $query = "INSERT INTO periodoescolar values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $periodo);
			$stmt->bindParam(2, $descripcion);
			$stmt->bindParam(3, $fechacreado);
			$stmt->bindParam(4, $mesesactivos);
			$stmt->bindParam(5, $montoinscripcion);
			$stmt->bindParam(6, $interesmora);
			$stmt->bindParam(7, $cuotaunica);
			$stmt->bindParam(8, $diasvence);
			$stmt->bindParam(9, $statusperiodo);
			
			$periodo = limpiar($_POST["periodo"]);
			$descripcion = limpiar($_POST["descripcion"]);
			$fechacreado = limpiar(date("Y-m-d"));
		   $mesesactivos = ($cobrar_cuotas == 1 ? implode(", ",$_POST["mesesactivos"]) : "0");
			$montoinscripcion = limpiar($_POST["montoinscripcion"]);
			$interesmora = limpiar($_POST["interesmora"]);
			$cuotaunica = limpiar($_POST["cuotaunica"]);
			$diasvence = limpiar($_POST["diasvence"]);
			$statusperiodo = limpiar("1");
			$stmt->execute();
			############## REGISTRO NUEVO PERIODO ##############
			
			############## ACTUALIZO STATUS DE ESTUDIANTES ##############
			$sql = " UPDATE estudiantes set "
		     ." statusest = ?"
			  ." WHERE "
			  ." statusest = 1;
			  ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1,$statusest);		
		   $statusest = limpiar("0");
		   $stmt->execute();
		   ############## ACTUALIZO STATUS DE ESTUDIANTES ##############
			
			############## ACTUALIZO STATUS DE PADRES ##############
		   $sql = " UPDATE padres set "
		     ." statuspad = ?"
			  ." WHERE "
			  ." statuspad = 1;
			  ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1,$statuspad);		
		   $statuspad = limpiar("0");
		   $stmt->execute();
		   ############## ACTUALIZO STATUS DE PADRES ##############
		 
	       echo "<span class='fa fa-check-square-o'></span> EL PERIDO ESCOLAR HA SIDO CREADO EXITOSAMENTE ";
	       exit;
		}
		else
		{
			echo "5";
			exit;
		}
		
		}
	}  
}
######################### FUNCION REGISTRAR PERIODO ESCOLAR #############################

######################## FUNCION LISTAR PERIODO ESCOLAR ##########################
public function ListarPeriodoEscolar()
{
	self::SetNames();
	$sql = "SELECT * FROM periodoescolar ORDER BY codperiodo DESC ";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}	
######################## FUNCION LISTAR PERIODO ESCOLAR ##########################

#################### FUNCION VER PERIODO ESCOLAR ########################
public function VerPeriodoEscolar()
{
	self::SetNames();
	$sql = "SELECT * FROM periodoescolar WHERE codperiodo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codperiodo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
#################### FUNCION VER PERIODO ESCOLAR ########################

######################### FUNCION ID PERIODO ESCOLAR #########################
public function PeriodoEscolarPorId()
{
	self::SetNames();
	$sql = "SELECT codperiodo FROM detallespagos  WHERE codperiodo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codperiodo"])));
	$num = $stmt->rowCount();
	if($num > 0)
	{
	?>
	<script type='text/javascript' language='javascript'>
    alert('ESTE PERIODO ESCOLAR NO PUEDE SER MODIFICADO, TIENE detallespagos  ASIGNADOS ACTUALMENTE')  
	document.location.href='periodoescolar'	 
    </script> 
	<?php
	exit;
		
	} else {
		
		$sql = "SELECT * FROM periodoescolar WHERE codperiodo = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["codperiodo"])));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "";
		}
		else
		{
			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[] = $row;
			}
			return $this->p;
			$this->dbh=null;
		}
	}
}
######################### FUNCION ID PERIODO ESCOLAR #########################

####################### FUNCION ID PERIODO ACTIVO ############################
public function PeriodoEscolarActivo()
{
	self::SetNames();
	$sql = "SELECT * FROM periodoescolar WHERE statusperiodo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array('1'));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
####################### FUNCION ID PERIODO ACTIVO ############################

##################### FUNCION ACTUALIZAR PERIODO ESCOLAR #####################
public function ActualizarPeriodoEscolar()
{
	self::SetNames();
	if(empty($_POST["periodo"]) or empty($_POST["descripcion"]))
	{
		echo "1";
		exit;
	}
	############# OBTENGO DATOS DE CONFIGURACION #############
	$conf = "SELECT * FROM configuracion";
	foreach ($this->dbh->query($conf) as $rowcon)
	{
		$this->pcon[] = $rowcon;
	}
	$cobrar_cuotas = (empty($rowcon['cobrar_cuotas']) ? 0 : $rowcon['cobrar_cuotas']);
	############# OBTENGO DATOS DE CONFIGURACION #############

	if ($cobrar_cuotas == 1 && $_POST["mesesactivos"] == "") 
	{
	   echo "2";
		exit; 
	}

	$sql = "SELECT periodo FROM periodoescolar WHERE codperiodo != ? and periodo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codperiodo"], $_POST["periodo"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		############## REGISTRO PERIODO ESCOLAR ##############
		$sql = " UPDATE periodoescolar set "
			  ." periodo = ?, "
			  ." descripcion = ?, "
			  ." mesesactivos = ?, "
			  ." montoinscripcion = ?, "
			  ." interesmora = ?, "
			  ." cuotaunica = ?, "
			  ." diasvence = ? "
			  ." WHERE "
			  ." codperiodo = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $periodo);
		$stmt->bindParam(2, $descripcion);
		$stmt->bindParam(3, $mesesactivos);
		$stmt->bindParam(4, $montoinscripcion);
		$stmt->bindParam(5, $interesmora);
		$stmt->bindParam(6, $cuotaunica);
		$stmt->bindParam(7, $diasvence);
		$stmt->bindParam(8, $codperiodo);
			
		$periodo = limpiar($_POST["periodo"]);
		$descripcion = limpiar($_POST["descripcion"]);
		$mesesactivos = ($cobrar_cuotas == 1 ? implode(", ",$_POST["mesesactivos"]) : "0");
		$montoinscripcion = limpiar($_POST["montoinscripcion"]);
		$interesmora = limpiar($_POST["interesmora"]);
		$cuotaunica = limpiar($_POST["cuotaunica"]);
		$diasvence = limpiar($_POST["diasvence"]);
		$codperiodo = limpiar($_POST["codperiodo"]);
		$stmt->execute();
		############## REGISTRO PERIODO ESCOLAR ##############
		
      echo "<span class='fa fa-check-square-o'></span> EL PERIODO ESCOLAR HA SIDO ACTUALIZADO EXITOSAMENTE";
      exit;
	}
	else
	{
		echo "3";
		exit;
	}
}
##################### FUNCION ACTUALIZAR PERIODO ESCOLAR #####################

###################### FUNCION ELIMINAR PERIODO ESCOLAR ##########################
public function EliminarPeriodoEscolar()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT codperiodo FROM estudiantes  WHERE codperiodo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codperiodo"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

	$sql = "DELETE FROM periodoescolar WHERE codperiodo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codperiodo);
	$codperiodo = decrypt($_GET["codperiodo"]);
	$stmt->execute();
	
	    echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
###################### FUNCION ELIMINAR PERIODO ESCOLAR ##########################

############################## FIN DE CLASE PERIODO ESCOLAR ##############################





















################################# CLASE MEDIOS DE detallespagos  ################################

########################### FUNCION REGISTRAR MEDIOS DE detallespagos  ###########################
public function RegistrarMediosPagos()
{
	self::SetNames();
	if(empty($_POST["mediopago"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT mediopago FROM mediospagos WHERE mediopago = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["mediopago"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO mediospagos values (null, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $mediopago);

		$mediopago = limpiar($_POST["mediopago"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL MEDIO DE PAGO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

		} else {

		echo "2";
		exit;
    }
}
############################ FUNCION REGISTRAR MEDIOS DE detallespagos  ##########################

########################## FUNCION LISTAR MEDIOS DE detallespagos  ##########################
public function ListarMediosPagos()
{
	self::SetNames();
	$sql = "SELECT * FROM mediospagos";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################### FUNCION LISTAR MEDIOS DE detallespagos  ##########################

############################ FUNCION ID MEDIOS DE detallespagos  #################################
public function MediosPagosPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM mediospagos WHERE codmediopago = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmediopago"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID MEDIOS DE detallespagos  #################################

##################### FUNCION ACTUALIZAR MEDIOS DE detallespagos  ############################
public function ActualizarMediosPagos()
{
	self::SetNames();
	if(empty($_POST["codmediopago"]) or empty($_POST["mediopago"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT mediopago FROM mediospagos WHERE codmediopago != ? AND mediopago = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codmediopago"],$_POST["mediopago"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE mediospagos set "
		." mediopago = ? "
		." where "
		." codmediopago = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $mediopago);
		$stmt->bindParam(2, $codmediopago);

		$mediopago = limpiar($_POST["mediopago"]);
		$codmediopago = limpiar($_POST["codmediopago"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL MEDIO DE PAGO HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

		} else {

		echo "2";
		exit;
	}
}
##################### FUNCION ACTUALIZAR MEDIOS DE detallespagos  ############################

########################## FUNCION ELIMINAR MEDIOS DE detallespagos  #########################
public function EliminarMediosPagos()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administrador") {

	$sql = "SELECT codmediopago FROM mediospagos WHERE codmediopago = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmediopago"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM mediospagos WHERE codmediopago = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmediopago);
		$codmediopago = decrypt($_GET["codmediopago"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR MEDIOS DE detallespagos  ###########################

############################ FIN DE CLASE MEDIOS DE detallespagos  ##############################


















###################################### CLASE TURNOS #####################################

################################### FUNCION REGISTRAR TURNOS ##################################
public function RegistrarTurno()
{
	self::SetNames();
	if(empty($_POST["turno"]))
	{
		echo "1";
		exit;
	}
				
   ################## CREO CODIGO DE TURNO ##################
   $sql = "SELECT codturno FROM turnos ORDER BY codturno DESC limit 1 ";
	foreach ($this->dbh->query($sql) as $row){

      $codturno["codturno"]=$row["codturno"];
   }
   if(empty($codturno["codturno"])){
		$codturno = 'T001';

   } else{
      $num     = substr($codturno["codturno"] , 1);
      $dig     = $num + 1;
      $cod = str_pad($dig, 3, "0", STR_PAD_LEFT);
		$codturno = 'T'.$cod;
   }
   ################## CREO CODIGO DE TURNO ##################

   $sql = "SELECT * FROM turnos WHERE turno = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["turno"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO turnos values (?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codturno);
	   $stmt->bindParam(2, $turno);
			
		$turno = limpiar($_POST["turno"]);
		$stmt->execute();

	   echo "<span class='fa fa-check-square-o'></span> EL TURNO HA SIDO REGISTRADO EXITOSAMENTE";
      exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
################################### FUNCION REGISTRAR TURNOS ##################################

################################ FUNCION LISTAR TURNOS #######################################
public function ListarTurno()
{
	self::SetNames();
	$sql = "SELECT * FROM turnos";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
################################ FUNCION LISTAR TURNOS #######################################

#################################### FUNCION ID TURNOS #####################################
public function TurnoPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM turnos WHERE codturno = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codturno"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
#################################### FUNCION ID TURNOS #####################################
	
################################## FUNCION ACTUALIZAR TURNOS #################################
public function ActualizarTurno()
{
	self::SetNames();
	if(empty($_POST["codturno"]) or empty($_POST["turno"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT * FROM turnos WHERE codturno != ? and turno = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codturno"]), $_POST["turno"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE turnos set "
			  ." turno = ? "
			  ." WHERE "
			  ." codturno = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $turno);
		$stmt->bindParam(2, $codturno);
			
		$turno = limpiar($_POST["turno"]);
		$codturno = limpiar(decrypt($_POST["codturno"]));
		$stmt->execute();
	
      echo "<span class='fa fa-check-square-o'></span> EL TURNO HA SIDO ACTUALIZADO EXITOSAMENTE",
      exit;
   }
	else
	{
		echo "2";
		exit;
	}
}
################################## FUNCION ACTUALIZAR TURNOS #################################

################################# FUNCION ELIMINAR TURNOS ##################################
public function EliminarTurno()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT codturno FROM estudiantes WHERE codturno = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codturno"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

		$sql = "DELETE FROM turnos WHERE codturno = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codturno);
		$codturno = decrypt($_GET["codturno"]);
		$stmt->execute();
		
		echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
################################# FUNCION ELIMINAR TURNOS ##################################

##################################### FIN DE CLASE TURNOS ########################################



















########################################## CLASE NIVELES #########################################

################################### FUNCION REGISTRAR NIVELES ##################################
public function RegistrarNivel()
{
	self::SetNames();
	if(empty($_POST["nivel"]) or empty($_POST["pagonivel"]))
	{
		echo "1";
		exit;
	}

   ################## CREO CODIGO DE NIVEL ##################
   $sql = "SELECT codnivel FROM niveles ORDER BY codnivel DESC limit 1 ";
   foreach ($this->dbh->query($sql) as $row){

   $codnivel["codnivel"]=$row["codnivel"];
   }
   if(empty($codnivel["codnivel"]))
   {
		$codnivel = 'N001';
   } else {
      $num     = substr($codnivel["codnivel"] , 1);
      $dig     = $num + 1;
      $cod = str_pad($dig, 3, "0", STR_PAD_LEFT);
		$codnivel = 'N'.$cod;
   }
   ################## CREO CODIGO DE NIVEL ##################

	$sql = "SELECT * FROM niveles WHERE nivel = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nivel"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO niveles values (?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codnivel);
		$stmt->bindParam(2, $nivel);
		$stmt->bindParam(3, $pagonivel);
		
		$nivel = limpiar($_POST["nivel"]);
		$pagonivel = limpiar($_POST["pagonivel"]);
		$stmt->execute();

	   echo "<span class='fa fa-check-square-o'></span> EL NIVEL HA SIDO REGISTRADO EXITOSAMENTE";
	   exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
################################### FUNCION REGISTRAR NIVELES ##################################

################################## FUNCION LISTAR NIVELES ####################################
public function ListarNivel()
{
	self::SetNames();
	$sql = "SELECT * FROM niveles";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
################################## FUNCION LISTAR NIVELES ####################################

################################## FUNCION ID NIVEL ################################
public function NivelPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM niveles WHERE codnivel = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codnivel"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
################################## FUNCION ID NIVEL ################################

################################## FUNCION ID NIVEL ################################
public function NivelPorId2()
{
	self::SetNames();
	$sql = "SELECT * FROM niveles WHERE codnivel = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_GET["codnivel"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
################################## FUNCION ID NIVEL ################################

################################ FUNCION ACTUALIZAR NIVELES #############################
public function ActualizarNivel()
{
	self::SetNames();
	if(empty($_POST["codnivel"]) or empty($_POST["nivel"]) or empty($_POST["pagonivel"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT * FROM niveles WHERE codnivel != ? and nivel = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codnivel"]), $_POST["nivel"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE niveles set "
			  ." nivel = ?, "
			  ." pagonivel = ? "
			  ." WHERE "
			  ." codnivel = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nivel);
		$stmt->bindParam(2, $pagonivel);
		$stmt->bindParam(3, $codnivel);
			
		$nivel = limpiar($_POST["nivel"]);
		$pagonivel = limpiar($_POST["pagonivel"]);
		$codnivel = limpiar(decrypt($_POST["codnivel"]));
		$stmt->execute();
		
      echo "<span class='fa fa-check-square-o'></span> EL NIVEL HA SIDO ACTUALIZADO EXITOSAMENTE";
	   exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
################################ FUNCION ACTUALIZAR NIVELES #############################

################################ FUNCION ELIMINAR NIVELES ################################
public function EliminarNivel()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT codnivel FROM grados WHERE codnivel = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codnivel"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

	$sql = "DELETE FROM niveles WHERE codnivel = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codnivel);
	$codnivel = decrypt($_GET["codnivel"]);
	$stmt->execute();
		
		echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
################################ FUNCION ELIMINAR NIVELES ################################

################################ FIN DE CLASE NIVELES ###################################






















###################################### CLASE GRADOS ########################################

################################### FUNCION REGISTRAR GRADOS ###################################
public function RegistrarGrados()
{
	self::SetNames();
	if(empty($_POST["codnivel"]) or empty($_POST["grado"]))
	{
		echo "1";
		exit;
	}
   ################## CREO CODIGO DE GRADO ##################
   $sql = "SELECT codgrado FROM grados ORDER BY codgrado DESC limit 1 ";
   foreach ($this->dbh->query($sql) as $row){

      $codgrado["codgrado"]=$row["codgrado"];
   }
   if(empty($codgrado["codgrado"])){
		$codgrado = 'G001';
   } else {
      $num     = substr($codgrado["codgrado"] , 1);
      $dig     = $num + 1;
      $cod = str_pad($dig, 3, "0", STR_PAD_LEFT);
		$codgrado = 'G'.$cod;
   }
   ################## CREO CODIGO DE GRADO ##################

	$sql = "SELECT * FROM grados WHERE codnivel = ? AND grado = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codnivel"], $_POST["grado"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO grados values (?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codgrado);
		$stmt->bindParam(2, $codnivel);
		$stmt->bindParam(3, $grado);
		
		$codnivel = limpiar($_POST["codnivel"]);
		$grado = limpiar($_POST["grado"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL GRADO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
################################### FUNCION REGISTRAR GRADOS ###################################

################################ FUNCION LISTAR GRADOS ####################################
public function ListarGrados()
{
	self::SetNames();
	$sql = "SELECT * FROM grados INNER JOIN niveles ON grados.codnivel = niveles.codnivel";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
################################ FUNCION LISTAR GRADOS ####################################

############################ FUNCION LISTAR GRADOS POR NIVEL #############################
public function ListarGradosNiveles()
{
	self::SetNames();
	$sql = "SELECT * FROM grados WHERE codnivel = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codnivel"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION LISTAR GRADOS POR NIVEL #############################

################# FUNCION PARA SELECCIONAR GRADO POR NIVEL #################
public function SeleccionaGrado()
{
	self::SetNames();
	$sql = "SELECT * FROM grados WHERE codnivel = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codnivel"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
		while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
################# FUNCION PARA SELECCIONAR GRADO POR NIVEL ################

################################## FUNCION ID GRADOS ##############################
public function GradosPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM grados WHERE codgrado = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codgrado"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
################################## FUNCION ID GRADOS ##############################
	
################################ FUNCION ACTUALIZAR GRADOS #############################
public function ActualizarGrados()
{
	self::SetNames();
	if(empty($_POST["codgrado"]) or empty($_POST["codnivel"]) or empty($_POST["grado"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT * FROM grados WHERE codgrado != ? AND codnivel = ? AND grado = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codgrado"]), $_POST["codnivel"], $_POST["grado"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	$sql = " UPDATE grados set "
		  ." codnivel = ?, "
		  ." grado = ? "
		  ." WHERE "
		  ." codgrado = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $codnivel);
	$stmt->bindParam(2, $grado);
	$stmt->bindParam(3, $codgrado);
		
	$codnivel = limpiar($_POST["codnivel"]);
	$grado = limpiar($_POST["grado"]);
	$codgrado = limpiar(decrypt($_POST["codgrado"]));
	$stmt->execute();
		
      echo "<span class='fa fa-check-square-o'></span> EL GRADO HA SIDO ACTUALIZADO EXITOSAMENTE";
	   exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
################################ FUNCION ACTUALIZAR GRADOS #############################

############################### FUNCION ELIMINAR GRADOS #################################
public function EliminarGrados()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT codgrado FROM secciones WHERE codgrado = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codgrado"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM grados WHERE codgrado = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codgrado);
		$codgrado = decrypt($_GET["codgrado"]);
		$stmt->execute();
	
	    echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################### FUNCION ELIMINAR GRADOS #################################
	
#################################### FIN DE CLASE GRADOS ###################################





























####################################### CLASE SECCIONES #####################################

############################## FUNCION REGISTRAR SECCIONES ################################
public function RegistrarSecciones()
{
	self::SetNames();
	if(empty($_POST["codnivel"]) or empty($_POST["codgrado"]) or empty($_POST["seccion"]))
	{
		echo "1";
		exit;
	}

   ################## CREO CODIGO DE SECCION ##################
   $sql = "SELECT codseccion FROM secciones ORDER BY codseccion DESC limit 1 ";
   foreach ($this->dbh->query($sql) as $row){

      $codseccion["codseccion"]=$row["codseccion"];
   }
   if(empty($codseccion["codseccion"])){
		$codseccion = 'S001';
   } else {
      $num     = substr($codseccion["codseccion"] , 1);
      $dig     = $num + 1;
      $cod = str_pad($dig, 3, "0", STR_PAD_LEFT);
		$codseccion = 'S'.$cod;
   }
   ################## CREO CODIGO DE SECCION ##################

	$sql = "SELECT * FROM secciones WHERE codnivel = ? and codgrado = ? and seccion = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codnivel"]), decrypt($_POST["codgrado"]), $_POST["seccion"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO secciones values (?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codseccion);
		$stmt->bindParam(2, $codnivel);
		$stmt->bindParam(3, $codgrado);
		$stmt->bindParam(4, $seccion);
		
	   $codnivel = limpiar(decrypt($_POST["codnivel"]));
		$codgrado = limpiar(decrypt($_POST["codgrado"]));
		$seccion = limpiar($_POST["seccion"]);
		$stmt->execute();

	   echo "<span class='fa fa-check-square-o'></span> LA SECCI&Oacute;N HA SIDO REGISTRADA EXITOSAMENTE";
	   exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
############################## FUNCION REGISTRAR SECCIONES ################################

################################# FUNCION LISTAR SECCIONES #################################
public function ListarSecciones()
{
	self::SetNames();
	$sql = "SELECT * FROM secciones 
	INNER JOIN grados ON secciones.codgrado = grados.codgrado 
	INNER JOIN niveles ON grados.codnivel = niveles.codnivel";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
################################# FUNCION LISTAR SECCIONES #################################

############################## FUNCION LISTAR SECCIONES POR GRADOS ############################
public function ListarSeccionesGrados()
{
	self::SetNames();
	$sql = "SELECT * FROM secciones WHERE codgrado = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codgrado"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################## FUNCION LISTAR SECCIONES POR GRADOS ############################

############################ FUNCION ID GRADOS #####################################
public function SeccionesPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM secciones WHERE codseccion = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codseccion"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID GRADOS #####################################

############################## FUNCION ACTUALIZAR SECCIONES ###########################
public function ActualizarSecciones()
{
	self::SetNames();
	if(empty($_POST["codseccion"]) or empty($_POST["codnivel"]) or empty($_POST["codgrado"]) or empty($_POST["seccion"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT * FROM secciones WHERE codseccion != ? and codnivel = ? and codgrado = ? and seccion = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codseccion"]), decrypt($_POST["codnivel"]), decrypt($_POST["codgrado"]), $_POST["seccion"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE secciones set "
			  ." codnivel = ?, "
			  ." codgrado = ?, "
			  ." seccion = ? "
			  ." WHERE "
			  ." codseccion = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codnivel);
		$stmt->bindParam(2, $codgrado);
		$stmt->bindParam(3, $seccion);
		$stmt->bindParam(4, $codseccion);
			
		$codseccion = limpiar($_POST["codseccion"]);
		$codnivel = limpiar(decrypt($_POST["codnivel"]));
		$codgrado = limpiar(decrypt($_POST["codgrado"]));
		$seccion = limpiar(decrypt($_POST["codseccion"]));
		$stmt->execute();
	
	   echo "<span class='fa fa-check-square-o'></span> LA SECCI&Oacute;N HA SIDO ACTUALIZADA EXITOSAMENTE";
	   exit;
   }
	else
	{
		echo "2";
		exit;
	}
}
############################## FUNCION ACTUALIZAR SECCIONES ###########################

########################### FUNCION ELIMINAR SECCIONES ###############################
public function EliminarSecciones()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT codseccion FROM estudiantes WHERE codseccion = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codseccion"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM secciones WHERE codseccion = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codseccion);
		$codseccion = decrypt($_GET["codseccion"]);
		$stmt->execute();
	
	   echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR SECCIONES ###############################
	
#################################### FIN DE CLASE SECCIONES ###################################
















###################################### CLASE AREAS #####################################

################################### FUNCION REGISTRAR AREAS ##################################
public function RegistrarArea()
{
	self::SetNames();
	if(empty($_POST["nomarea"]))
	{
		echo "1";
		exit;
	}

	################## CREO CODIGO DE AREA ##################
	$sql = "SELECT codarea FROM areas ORDER BY codarea DESC limit 1 ";
   foreach ($this->dbh->query($sql) as $row){

      $codarea["codarea"]=$row["codarea"];
   }
   if(empty($codarea["codarea"])){
		$codarea = 'AR001';
   } else {
      $num = substr($codarea["codarea"] , 2);
      $dig = $num + 1;
      $cod = str_pad($dig, 3, "0", STR_PAD_LEFT);
		$codarea = 'AR'.$cod;
   }
   ################## CREO CODIGO DE AREA ##################

   $sql = "SELECT * FROM areas WHERE nomarea = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomarea"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO areas values (?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codarea);
		$stmt->bindParam(2, $nomarea);
		
	   $nomarea = limpiar($_POST["nomarea"]);
		$stmt->execute();

	   echo "<span class='fa fa-check-square-o'></span> EL AREA DE MATERIA HA SIDO REGISTRADO EXITOSAMENTE";
       exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
################################### FUNCION REGISTRAR AREAS ##################################

################################ FUNCION LISTAR AREAS #######################################
public function ListarArea()
{
	self::SetNames();
	$sql = "SELECT * FROM areas";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
################################ FUNCION LISTAR AREAS #######################################

#################################### FUNCION ID AREAS #####################################
public function AreaPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM areas WHERE codarea = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codarea"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
#################################### FUNCION ID AREAS #####################################
	
################################## FUNCION ACTUALIZAR AREAS #################################
public function ActualizarArea()
{
	self::SetNames();
	if(empty($_POST["codarea"]) or empty($_POST["nomarea"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT * FROM areas WHERE codarea != ? and nomarea = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codarea"]), $_POST["nomarea"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE areas set "
			  ." nomarea = ? "
			  ." WHERE "
			  ." codarea = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomarea);
		$stmt->bindParam(2, $codarea);
			
		$nomarea = limpiar($_POST["nomarea"]);
		$codarea = limpiar(decrypt($_POST["codarea"]));
		$stmt->execute();
		
      echo "<span class='fa fa-check-square-o'></span> EL AREA DE MATERIA HA SIDO ACTUALIZADO EXITOSAMENTE";
      exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
################################## FUNCION ACTUALIZAR AREAS #################################

################################# FUNCION ELIMINAR AREAS ##################################
public function EliminarAreas()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT codarea FROM materias WHERE codarea = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codarea"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM areas WHERE codarea = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codarea);
		$codarea = decrypt($_GET["codarea"]);
		$stmt->execute();
	
	    echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
################################# FUNCION ELIMINAR AREAS ##################################

##################################### FIN DE CLASE AREAS ###############################
















######################################### CLASE MATERIAS ############################################

############################ FUNCION REGISTRAR MATERIAS ##############################
public function RegistrarMaterias()
{
	self::SetNames();
	if(empty($_POST["nommateria"]) or empty($_POST["codnivel"]) or empty($_POST["codgrado"]))
	{
		echo "1";
		exit;
	}

   ################## CREO CODIGO DE MATERIA ##################
   $sql = "SELECT codmateria FROM materias ORDER BY codmateria DESC limit 1 ";
   foreach ($this->dbh->query($sql) as $row){

      $codmateria["codmateria"]=$row["codmateria"];
   }
   if(empty($codmateria["codmateria"])){
		$codmateria = 'M0001';
   } else {
      $num = substr($codmateria["codmateria"] , 1);
      $dig = $num + 1;
      $cod = str_pad($dig, 4, "0", STR_PAD_LEFT);
	   $codmateria = 'M'.$cod;
   }
   ################## CREO CODIGO DE MATERIA ##################

	$sql = "SELECT nommateria, codgrado FROM materias WHERE nommateria = ? and codgrado = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nommateria"], decrypt($_POST["codgrado"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO materias values (?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codmateria);
		$stmt->bindParam(2, $codarea);
		$stmt->bindParam(3, $nommateria);
		$stmt->bindParam(4, $codnivel);
		$stmt->bindParam(5, $codgrado);
		
		$codarea = limpiar(decrypt($_POST["codarea"]));
		$nommateria = limpiar($_POST["nommateria"]);
		$codnivel = limpiar(decrypt($_POST["codnivel"]));
		$codgrado = limpiar(decrypt($_POST["codgrado"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA MATERIA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
############################ FUNCION REGISTRAR MATERIAS ##############################

############################### FUNCION LISTAR MATERIAS ################################
public function ListarMaterias()
{
	self::SetNames();
	$sql = "SELECT * FROM materias 
	INNER JOIN grados ON materias.codgrado = grados.codgrado 
	LEFT JOIN areas ON materias.codarea = areas.codarea 
	LEFT JOIN niveles ON grados.codnivel = niveles.codnivel";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
############################### FUNCION LISTAR MATERIAS ################################

############################### FUNCION ID MATERIAS ################################
public function MateriasPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM materias 
	INNER JOIN grados ON materias.codgrado = grados.codgrado 
	LEFT JOIN areas ON materias.codarea = areas.codarea 
	LEFT JOIN niveles ON grados.codnivel = niveles.codnivel 
	WHERE materias.codmateria = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmateria"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################### FUNCION ID MATERIAS ################################
	
################################# FUNCION ACTUALIZAR MATERIAS ################################
public function ActualizarMaterias()
{
	self::SetNames();
	if(empty($_POST["codmateria"]) or empty($_POST["codarea"]) or empty($_POST["nommateria"]) or empty($_POST["codnivel"]) or empty($_POST["codgrado"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT codmateria, nommateria, codgrado FROM materias WHERE codmateria != ? and nommateria = ? and codgrado = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codmateria"]), $_POST["nommateria"], decrypt($_POST["codgrado"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE materias set "
			  ." codarea = ?, "
			  ." nommateria = ?, "
			  ." codnivel = ?, "
			  ." codgrado = ? "
			  ." WHERE "
			  ." codmateria = ?;
			   ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codarea);
		$stmt->bindParam(2, $nommateria);
		$stmt->bindParam(3, $codnivel);
		$stmt->bindParam(4, $codgrado);
		$stmt->bindParam(5, $codmateria);
			
		$codarea = limpiar(decrypt($_POST["codarea"]));
		$nommateria = limpiar($_POST["nommateria"]);
		$codnivel = limpiar(decrypt($_POST["codnivel"]));
		$codgrado = limpiar(decrypt($_POST["codgrado"]));
		$codmateria = limpiar(decrypt($_POST["codmateria"]));
		$stmt->execute();
	
	   echo "<span class='fa fa-check-square-o'></span> LA MATERIA HA SIDO ACTUALIZADA EXITOSAMENTE";
	   exit;
   }
	else
	{
		echo "2";
		exit;
	}
}
################################# FUNCION ACTUALIZAR MATERIAS ################################

################################ FUNCION ELIMINAR MATERIAS #################################
public function EliminarMaterias()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT codmateria FROM notas WHERE codmateria = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmateria"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM materias WHERE codmateria = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmateria);
		$codmateria = decrypt($_GET["codmateria"]);
		$stmt->execute();
		
		echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
################################ FUNCION ELIMINAR MATERIAS #################################

###################### FUNCION BUSQUEDA MATERIAS REPORTES ###########################
public function BuscarMateriasReportes() 
{
	self::SetNames();
	$sql = "SELECT * FROM materias INNER JOIN grados ON materias.codgrado = grados.codgrado 
	LEFT JOIN areas ON materias.codarea = areas.codarea 
	LEFT JOIN niveles ON grados.codnivel = niveles.codnivel 
	WHERE materias.codnivel = ? and materias.codgrado = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codnivel'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codgrado'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	   echo "<div class='alert alert-danger'>";
	   echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
      echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
      echo "</div>";		
	   exit;
	}
	else
	{
	   while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA MATERIAS REPORTES ###########################

############################## FUNCION LISTAR MATERIAS POR GRADOS ############################
public function ListarMateriasGrados()
{
	self::SetNames();
	############# OBTENGO PERIODO ESCOLAR ACTIVO #############
	$period = "SELECT * FROM periodoescolar WHERE statusperiodo = 1";
	foreach ($this->dbh->query($period) as $rowper)
	{
		$this->pper[] = $rowper;
	}
	$codperiodo = (empty($rowper['codperiodo']) ? "0" : $rowper['codperiodo']);
	$periodo = (empty($rowper['periodo']) ? "" : $rowper['periodo']);
	$statusperiodo = (empty($rowper['statusperiodo']) ? "" : $rowper['statusperiodo']);
	############# OBTENGO PERIODO ESCOLAR ACTIVO #############

	if($_SESSION['acceso'] == "docente") {

		$sql = "SELECT
		materias.codmateria,
		materias.nommateria,
		asignaciones.coddoc,
		asignaciones.codturno,
		asignaciones.codnivel,
		asignaciones.codgrado
		FROM asignaciones INNER JOIN materias ON asignaciones.codmateria = materias.codmateria
		WHERE asignaciones.coddoc = ?
		AND asignaciones.codturno = ? 
		AND asignaciones.codnivel = ? 
		AND asignaciones.codgrado = ? 
		AND asignaciones.codseccion = ? 
		AND asignaciones.codperiodo = ? 
		ORDER BY asignaciones.codmateria ASC";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($_SESSION["coddoc"]),decrypt($_GET["codturno"]),decrypt($_GET["codnivel"]),decrypt($_GET["codgrado"]),decrypt($_GET["codseccion"]),limpiar($codperiodo)));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "<option value=''> -- SIN RESULTADOS -- </option>";
			exit;
		}
		else
		{
		while($row = $stmt->fetch())
			{
				$this->p[]=$row;
			}
			return $this->p;
			$this->dbh=null;
		}

	} else {

		$sql = "SELECT * FROM materias WHERE codgrado = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["codgrado"])));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "<option value=''> -- SIN RESULTADOS -- </option>";
			exit;
		}
		else
		{
		while($row = $stmt->fetch())
			{
				$this->p[]=$row;
			}
			return $this->p;
			$this->dbh=null;
		}
	}
}
############################## FUNCION LISTAR MATERIAS POR GRADOS ############################

################################## FIN DE CLASE MATERIAS #####################################













####################################### CLASE CAJAS DE VENTAS ######################################

###################################### FUNCION REGISTRAR CAJAS ##################################
public function RegistrarCajas()
	{
	self::SetNames();
	if(empty($_POST["nrocaja"]) or empty($_POST["nombrecaja"]) or empty($_POST["codigo"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT nrocaja FROM cajas WHERE nrocaja = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nrocaja"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
	    echo "2";
	    exit;
	}
	$sql = "SELECT nombrecaja FROM cajas WHERE nombrecaja = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nombrecaja"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
	    echo "3";
	    exit;
	}
	$sql = "SELECT codigo FROM cajas WHERE codigo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codigo"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO cajas values (null, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nrocaja);
		$stmt->bindParam(2, $nombrecaja);
		$stmt->bindParam(3, $codigo);
		
		$nrocaja = limpiar($_POST["nrocaja"]);
		$nombrecaja = limpiar($_POST["nombrecaja"]);
		$codigo = limpiar($_POST["codigo"]);
		$stmt->execute();
		
		echo "<span class='fa fa-check-square-o'></span> LA CAJA PARA COBROS HA SIDO REGISTRADA EXITOSAMENTE </div>";
	    exit;
	}
	else
	{
		echo "4";
		exit;
	}
}
###################################### FUNCION REGISTRAR CAJAS ##################################

###################################### FUNCION LISTAR CAJAS ##################################
public function ListarCajas()
{
	self::SetNames();

	if($_SESSION['acceso'] == "administrador") {

	$sql = "SELECT * FROM cajas LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo ";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

     }  else {

	$sql = "SELECT * FROM cajas LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE cajas.codigo = '".limpiar($_SESSION["codigo"])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;

    }
}
###################################### FUNCION LISTAR CAJAS ##################################

###################################### FUNCION ID CAJAS ##################################
public function CajaPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM cajas INNER JOIN usuarios ON cajas.codigo = usuarios.codigo WHERE cajas.codcaja = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcaja"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################################### FUNCION ID CAJAS ##################################

###################################### FUNCION ID CAJAS #2 #################################
public function CajerosPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM cajas INNER JOIN usuarios ON cajas.codigo = usuarios.codigo WHERE cajas.codcaja = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codcaja"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################################### FUNCION ID CAJAS #2 #################################

###################################### FUNCION ACTUALIZAR CAJAS ##################################
public function ActualizarCaja()
	{
	self::SetNames();
	if(empty($_POST["codcaja"]))
	{
		echo "1";
	    exit;
	}
	$sql = "SELECT nrocaja FROM cajas WHERE codcaja != ? AND nrocaja = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codcaja"], $_POST["nrocaja"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
	   echo "2";
	   exit;
	}

	$sql = "SELECT nombrecaja FROM cajas WHERE codcaja != ? AND nombrecaja = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codcaja"], $_POST["nombrecaja"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
	   echo "3";
	   exit;
	}
	
	$sql = "SELECT codigo FROM cajas WHERE codcaja != ? and codigo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codcaja"], $_POST["codigo"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	$sql = " UPDATE cajas set "
	      ." nrocaja = ?, "
		  ." nombrecaja = ?, "
		  ." codigo = ? "
		  ." WHERE "
		  ." codcaja = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $nrocaja);
	$stmt->bindParam(2, $nombrecaja);
	$stmt->bindParam(3, $codigo);
	$stmt->bindParam(4, $codcaja);
		
	$nrocaja = limpiar($_POST["nrocaja"]);
	$nombrecaja = limpiar($_POST["nombrecaja"]);
	$codigo = limpiar($_POST["codigo"]);
	$codcaja = limpiar($_POST["codcaja"]);
	$stmt->execute();
	
	echo "<span class='fa fa-check-square-o'></span> LA CAJA PARA COBRO HA SIDO ACTUALIZADA EXITOSAMENTE </div>";
	exit;
    }
	else
	{
		echo "3";
		exit;
    }
}
###################################### FUNCION ACTUALIZAR CAJAS ##################################

###################################### FUNCION ELIMINAR CAJAS ##################################
public function EliminarCaja()
{

$sql = "SELECT codcaja FROM arqueocaja WHERE codcaja = ? ";
$stmt = $this->dbh->prepare($sql);
$stmt->execute(array(decrypt($_GET["codcaja"])));
$num = $stmt->rowCount();
if($num == 0)
{

	$sql = "DELETE FROM cajas WHERE codcaja = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codcaja);
	$codcaja = decrypt($_GET["codcaja"]);
	$stmt->execute();

		echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
}
###################################### FUNCION ELIMINAR CAJAS ##################################

################################## FUNCION LISTAR CAJAS ABIERTAS ##################################
public function ListarCajasAbiertas()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "administrador") {

	$sql = "SELECT * FROM arqueocaja INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}

	} else {

	$sql = "SELECT * FROM arqueocaja INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo  
   WHERE cajas.codigo = '".limpiar($_SESSION["codigo"])."' 
   AND arqueocaja.statusarqueo = 1
   GROUP BY arqueocaja.codarqueo";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
   }
}
################################### FUNCION LISTAR CAJAS ABIERTAS ##################################

###################################### FUNCION VERIFICA CAJAS ######################################
public function MuestraCaja()
{
	self::SetNames();
	$sql = "SELECT * FROM cajas WHERE codigo = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_SESSION["codigo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "";		}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################################### FUNCION VERIFICA CAJAS ######################################

#################################### FIN DE CLASE CAJAS ###################################















###################################### CLASE ARQUEO DE CAJA ######################################

################################ FUNCION PARA REGISTRAR ARQUEO DE CAJA ##############################
public function RegistrarArqueoCaja()
{
	self::SetNames();
	if(empty($_POST["codcaja"]) or empty($_POST["montoinicial"]) or empty($_POST["fecharegistro"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT codcaja FROM arqueocaja WHERE codcaja = ? and statusarqueo = '1'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codcaja"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO arqueocaja values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcaja);
		$stmt->bindParam(2, $montoinicial);
		$stmt->bindParam(3, $ingresos);
		$stmt->bindParam(4, $ingresos2);
		$stmt->bindParam(5, $egresos);
		$stmt->bindParam(6, $efectivocaja);
		$stmt->bindParam(7, $dineroefectivo);
		$stmt->bindParam(8, $diferencia);
		$stmt->bindParam(9, $comentarios);
		$stmt->bindParam(10, $fechaapertura);
		$stmt->bindParam(11, $fechacierre);
		$stmt->bindParam(12, $statusarqueo);

		$codcaja = limpiar(decrypt($_POST["codcaja"]));
		$montoinicial = limpiar($_POST["montoinicial"]);
		$ingresos = limpiar("0.00");
		$ingresos2 = limpiar("0.00");
		$egresos = limpiar("0.00");
		$efectivocaja = limpiar("0.00");
		$dineroefectivo = limpiar("0.00");
		$diferencia = limpiar("0.00");
		$comentarios = limpiar('NINGUNO');
		$fechaapertura = limpiar(date("Y-m-d h:i:s",strtotime($_POST['fecharegistro'])));
		$fechacierre = limpiar(date("0000-00-00 00:00:00"));
		$statusarqueo = limpiar("1");
		$stmt->execute();

	   echo "<span class='fa fa-check-square-o'></span> EL ARQUEO DE CAJA HA SIDO REALIZADO EXITOSAMENTE";
	   exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
############################### FUNCION PARA REGISTRAR ARQUEO DE CAJA #############################

################################# FUNCION PARA LISTAR ARQUEO DE CAJA ################################
public function ListarArqueoCaja()
	{
	self::SetNames();
			
	if($_SESSION['acceso'] == "administrador") {

		$sql = "SELECT * FROM arqueocaja 
		INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
		LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} else {

		$sql = "SELECT * FROM arqueocaja 
		INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
		LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo 
		WHERE cajas.codigo = '".limpiar($_SESSION["codigo"])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################### FUNCION PARA LISTAR ARQUEO DE CAJA ##################################

################################ FUNCION ID ARQUEO DE CAJA #####################################
public function ArqueoCajaPorId()
{
	self::SetNames();
	$sql = "SELECT 
	arqueocaja.codarqueo,
	arqueocaja.codcaja,
	arqueocaja.montoinicial,
	arqueocaja.ingresos,
	arqueocaja.ingresos2,
	arqueocaja.egresos,
	arqueocaja.efectivocaja,
	arqueocaja.dineroefectivo,
	arqueocaja.diferencia,
	arqueocaja.comentarios,
	arqueocaja.fechaapertura,
	arqueocaja.fechacierre,
	arqueocaja.statusarqueo,
	cajas.nrocaja,
	cajas.nombrecaja,
	cajas.codigo,
	usuarios.cedula,
	usuarios.nombres,
	pag.montopagado,
	pag.operaciones,
	pag2.mediopago
	FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo
	
	LEFT JOIN
	   (SELECT
	   mediospagoxpagos.idpago,
	   mediospagoxpagos.codarqueo,
	   mediospagoxpagos.codmediopago, 
	   (SUM(mediospagoxpagos.montopagado) - SUM(mediospagoxpagos.montodevuelto)) AS montopagado,
	   COUNT(mediospagoxpagos.codmediopago) AS operaciones
	   FROM mediospagoxpagos
	   WHERE mediospagoxpagos.codarqueo = '".decrypt($_GET["codarqueo"])."'
	   GROUP BY mediospagoxpagos.codmediopago DESC) pag ON arqueocaja.codarqueo = pag.codarqueo

   LEFT JOIN
	   (SELECT
	   mediospagos.codmediopago,
	   mediospagos.mediopago
	   FROM mediospagos) pag2 ON pag.codmediopago = pag2.codmediopago

	WHERE arqueocaja.codarqueo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codarqueo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################################### FUNCION ID ARQUEO DE CAJA #################################

############################### FUNCION PARA CERRAR ARQUEO DE CAJA ##################################
public function CerrarArqueoCaja()
{
	self::SetNames();
	if(empty($_POST["codarqueo"]) or empty($_POST["dineroefectivo"]))
	{
		echo "1";
		exit;
	}
	if($_POST["dineroefectivo"] != 0.00 || $_POST["dineroefectivo"] != 0){

		$sql = "UPDATE arqueocaja SET "
		." efectivocaja = ?, "
		." dineroefectivo = ?, "
		." diferencia = ?, "
		." comentarios = ?, "
		." fechacierre = ?, "
		." statusarqueo = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $efectivocaja);
		$stmt->bindParam(2, $dineroefectivo);
		$stmt->bindParam(3, $diferencia);
		$stmt->bindParam(4, $comentarios);
		$stmt->bindParam(5, $fechacierre);
		$stmt->bindParam(6, $statusarqueo);
		$stmt->bindParam(7, $codarqueo);

		$efectivocaja = limpiar($_POST["efectivocaja"]);
		$dineroefectivo = limpiar($_POST["dineroefectivo"]);
		$diferencia = limpiar($_POST["diferencia"]);
		$comentarios = limpiar($_POST['comentarios']);
		$fechacierre = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fecharegistro'])));
		$statusarqueo = limpiar("0");
		$codarqueo = limpiar(decrypt($_POST["codarqueo"]));
		$stmt->execute();

	   echo "<span class='fa fa-check-square-o'></span> EL CIERRE DE CAJA FUE REALIZADO EXITOSAMENTE <a href='reportepdf?codarqueo=".encrypt($codarqueo)."&tipo=".encrypt("TICKETCIERRE")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR TICKET</strong></font color></a></div>";

	   echo "<script>window.open('reportepdf?codarqueo=".encrypt($codarqueo)."&tipo=".encrypt("TICKETCIERRE")."', '_blank');</script>";
	   exit;

	} else {

		echo "2";
		exit;
   }
}
################################# FUNCION PARA CERRAR ARQUEO DE CAJA ################################

######################### FUNCION PARA ACTUALIZAR ARQUEO DE CAJA #########################
public function ActualizarArqueoCaja()
{
	self::SetNames();
	if(empty($_POST["codarqueo"]) or empty($_POST["dineroefectivo"]))
	{
		echo "1";
		exit;
	}

	if($_POST["dineroefectivo"] != 0.00 || $_POST["dineroefectivo"] != 0){

		$sql = "UPDATE arqueocaja SET "
		." efectivocaja = ?, "
		." dineroefectivo = ?, "
		." diferencia = ?, "
		." comentarios = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $efectivocaja);
		$stmt->bindParam(2, $dineroefectivo);
		$stmt->bindParam(3, $diferencia);
		$stmt->bindParam(4, $comentarios);
		$stmt->bindParam(5, $codarqueo);

		$efectivocaja = limpiar($_POST["efectivocaja"]);
		$dineroefectivo = limpiar($_POST["dineroefectivo"]);
		$diferencia = limpiar($_POST["diferencia"]);
		$comentarios = limpiar($_POST['comentarios']);
		$codarqueo = limpiar(decrypt($_POST["codarqueo"]));
		$stmt->execute();

	    echo "<span class='fa fa-check-square-o'></span> EL ARQUEO DE CAJA FUE ACTUALIZADO EXITOSAMENTE <a href='reportepdf?codarqueo=".encrypt($codarqueo)."&tipo=".encrypt("TICKETCIERRE")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR TICKET</strong></font color></a></div>";

	    echo "<script>window.open('reportepdf?codarqueo=".encrypt($codarqueo)."&tipo=".encrypt("TICKETCIERRE")."', '_blank');</script>";
	    exit;

	} else {

		echo "2";
		exit;
    }
}
######################### FUNCION PARA ACTUALIZAR ARQUEO DE CAJA ######################

############################# FUNCION BUSCAR ARQUEOS POR FECHAS ###############################
public function BuscarArqueosxFechas() 
{
	self::SetNames();	
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE arqueocaja.codcaja = ? 
	AND DATE_FORMAT(arqueocaja.fechaapertura,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codcaja'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<center><div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<span class='fa fa-info-circle'></span> NO EXISTEN ARQUEOS PARA LAS FECHAS INGRESADA</div></center>";
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################# FUNCION BUSCAR ARQUEOS POR FECHAS ###############################

#################################### FIN DE CLASE ARQUEO DE CAJA #####################################












##################################### CLASE MOVIMIENTOS DE CAJAS ####################################

########################### FUNCION PARA REGISTRAR MOVIMIENTOS DE CAJAS ########################
public function RegistrarMovimientoCajas()
{
	self::SetNames();
	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	WHERE codcaja = ? AND statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codcaja"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "1";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$codarqueoBD = $row['codarqueo'];
		$codcajaBD = $row['codcaja'];
		$inicialBD = $row['montoinicial'];
		$ingresoBD = $row['ingresos'];
		$ingreso2BD = $row['ingresos2'];
		$egresoBD = $row['egresos'];
		$total = $inicialBD+$ingresoBD+$ingreso2BD-$egresoBD;
	}
   ####################### VERIFICO ARQUEO DE CAJA #######################

	if(empty($_POST["codcaja"]) or empty($_POST["tipomovimiento"]) or empty($_POST["montomovimiento"]) or empty($_POST["descripcionmovimiento"]))
	{
		echo "2";
		exit;
	}
	elseif($_POST["montomovimiento"] == "" || $_POST["montomovimiento"] == 0 || $_POST["montomovimiento"] == 0.00)
	{
		echo "3";
		exit;
	}
	elseif($_POST["tipomovimiento"] == "EGRESO" && $_POST["montomovimiento"] > $total)
	{
		echo "5";
		exit;
	}
	
   ################ CREO Nº DE MOVIMIENTO ####################
	$sql = "SELECT numero FROM movimientoscajas
	ORDER BY codmovimiento DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$documento=$row["numero"];
	}
	if(empty($documento))
	{
		$numero = "01";

	} else {

		$num = substr($documento, 0);
		$digitos = $num + 1;
		$numfinal = str_pad($digitos, 2, "0", STR_PAD_LEFT);
		$numero = $numfinal;
	}
   ################ CREO Nº DE MOVIMIENTO ###############

   ################ REGISTRO MOVIMIENTO ###############
   $query = "INSERT INTO movimientoscajas values (null, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $numero);
	$stmt->bindParam(2, $codarqueo);
	$stmt->bindParam(3, $codcaja);
	$stmt->bindParam(4, $tipomovimiento);
	$stmt->bindParam(5, $nrorecibo);
	$stmt->bindParam(6, $montomovimiento);
	$stmt->bindParam(7, $descripcionmovimiento);
	$stmt->bindParam(8, $fechamovimiento);

	$codarqueo = limpiar($codarqueoBD);
	$codcaja = limpiar($codcajaBD);
	$tipomovimiento = limpiar($_POST["tipomovimiento"]);
	$nrorecibo = limpiar($_POST["nrorecibo"]);
	$montomovimiento = limpiar($_POST["montomovimiento"]);
	$descripcionmovimiento = limpiar($_POST["descripcionmovimiento"]);
	$fechamovimiento = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fecharegistro'])));
	$stmt->execute();
	################ REGISTRO MOVIMIENTO ###############

	################ ACTUALIZO ARQUEO DE CAJA ###############
	$sql = " UPDATE arqueocaja set "
	." ingresos2 = ?, "
	." egresos = ? "
	." WHERE "
	." codarqueo = ? AND statusarqueo = 1;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtIngreso);
	$stmt->bindParam(2, $txtEgreso);
	$stmt->bindParam(3, $codarqueo);

	$txtIngreso = limpiar($_POST["tipomovimiento"] == "INGRESO" ? number_format($ingreso2BD+$_POST["montomovimiento"], 2, '.', '') : $ingreso2BD);
	$txtEgreso = limpiar($_POST["tipomovimiento"] == "EGRESO" ? number_format($egresoBD+$_POST["montomovimiento"], 2, '.', '') : $egresoBD);
	$codarqueo = limpiar($codarqueoBD);
	$stmt->execute();
	################ ACTUALIZO ARQUEO DE CAJA ###############

	echo "<span class='fa fa-check-square-o'></span> EL MOVIMIENTO EN CAJA HA SIDO REGISTRADO EXITOSAMENTE <a href='reportepdf?numero=".encrypt($numero)."&tipo=".encrypt("TICKETMOVIMIENTO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR TICKET</strong></font color></a></div>";

   echo "<script>window.open('reportepdf?numero=".encrypt($numero)."&tipo=".encrypt("TICKETMOVIMIENTO")."', '_blank');</script>";
	exit;	
}
########################### FUNCION PARA REGISTRAR MOVIMIENTOS DE CAJAS ########################

######################### FUNCION PARA LISTAR MOVIMIENTOS DE CAJAS ############################ 
public function ListarMovimientoCajas()
{
   self::SetNames();
     
   if($_SESSION['acceso'] == "administrador") {

      $sql = "SELECT * FROM movimientoscajas 
      INNER JOIN cajas ON movimientoscajas.codcaja = cajas.codcaja
      LEFT JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo 
      LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo
      ORDER BY movimientoscajas.fechamovimiento DESC";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

    } else {

      $sql = "SELECT * FROM movimientoscajas 
      INNER JOIN cajas ON movimientoscajas.codcaja = cajas.codcaja 
      LEFT JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo
      LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo
      WHERE usuarios.codigo = '".limpiar($_SESSION["codigo"])."'
      ORDER BY movimientoscajas.fechamovimiento DESC";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
   } 
}
######################### FUNCION PARA LISTAR MOVIMIENTOS DE CAJAS ########################### 

######################## FUNCION PARA SELECCIONAR MOVIMIENTOS DE CAJAS ###########################
public function MovimientoCajasPorId()
{
   self::SetNames();
   $sql = "SELECT 
	movimientoscajas.*,
   cajas.nrocaja,
   cajas.nombrecaja,
   usuarios.cedula, 
   usuarios.nombres
	FROM movimientoscajas 
   LEFT JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo
   LEFT JOIN cajas ON movimientoscajas.codcaja = cajas.codcaja
   LEFT JOIN usuarios ON cajas.codigo = usuarios.codigo
	WHERE movimientoscajas.numero = ?";
   $stmt = $this->dbh->prepare($sql);
   $stmt->execute(array(decrypt($_GET["numero"])));
   $num = $stmt->rowCount();
   if($num==0)
   {
	   echo "";
   }
   else
   {
	   if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################### FUNCION PARA SELECCIONAR MOVIMIENTOS DE CAJAS ############################

####################### FUNCION PARA ACTUALIZAR MOVIMIENTOS DE CAJAS ########################
public function ActualizarMovimientoCajas()
{
	self::SetNames();
	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	WHERE codcaja = ? AND statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codcaja"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "1";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$codarqueoBD = $row['codarqueo'];
		$codcajaBD = $row['codcaja'];
		$inicialBD = $row['montoinicial'];
		$ingresoBD = $row['ingresos'];
		$ingreso2BD = $row['ingresos2'];
		$egresoBD = $row['egresos'];
		$statusBD = $row['statusarqueo'];
		$total = $inicialBD+$ingresoBD+$ingreso2BD-$egresoBD;
	}
   ####################### VERIFICO ARQUEO DE CAJA #######################

   //REALIZAMOS CALCULO DE CAMPOS
	$numero = limpiar(decrypt($_POST["numero"]));
	$montomovimiento = limpiar($_POST["montomovimiento"]);
	$montomovimientobd = limpiar($_POST["montomovimientobd"]);
	$ingresobd = number_format($ingreso2BD-$montomovimientobd, 2, '.', '');
	$totalmovimiento = number_format($montomovimiento-$montomovimientobd, 2, '.', '');

	if(empty($_POST["codmovimiento"]) or empty($_POST["codcaja"]) or empty($_POST["tipomovimiento"]) or empty($_POST["montomovimiento"]) or empty($_POST["descripcionmovimiento"]))
	{
		echo "2";
		exit;
	}
	elseif($_POST["montomovimiento"] == "" || $_POST["montomovimiento"] == 0 || $_POST["montomovimiento"] == 0.00)
	{
		echo "3";
		exit;
	}
	elseif($_POST["tipomovimiento"] != $_POST["tipomovimientobd"])
	{
		echo "4";
		exit;
	}
	elseif($_POST["tipomovimiento"] == "EGRESO" && $totalmovimiento > $total)
	{
		echo "5";
		exit;
	}
	elseif($statusBD == 1) {

		################ ACTUALIZO MOVIMIENTO ###############
		$sql = " UPDATE movimientoscajas set "
		." codarqueo = ?, "
		." codcaja = ?, "
		." tipomovimiento = ?, "
		." nrorecibo = ?, "
		." montomovimiento = ?, "
		." descripcionmovimiento = ? "
		." WHERE "
		." codmovimiento = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codarqueo);
		$stmt->bindParam(2, $codcaja);
		$stmt->bindParam(3, $tipomovimiento);
		$stmt->bindParam(4, $nrorecibo);
		$stmt->bindParam(5, $montomovimiento);
		$stmt->bindParam(6, $descripcionmovimiento);
		$stmt->bindParam(7, $codmovimiento);

		$tipomovimiento = limpiar($_POST["tipomovimiento"]);
		$codarqueo = limpiar($codarqueoBD);
	   $codcaja = limpiar($codcajaBD);
		$nrorecibo = limpiar($_POST["nrorecibo"]);
		$montomovimiento = limpiar($_POST["montomovimiento"]);
		$descripcionmovimiento = limpiar($_POST["descripcionmovimiento"]);
		$codmovimiento = limpiar(decrypt($_POST["codmovimiento"]));
		$stmt->execute();
		################ ACTUALIZO MOVIMIENTO ###############

		################ ACTUALIZO ARQUEO DE CAJA ###############
		$sql = " UPDATE arqueocaja set "
		." ingresos2 = ?, "
		." egresos = ? "
		." WHERE "
		." codarqueo = ? AND statusarqueo = 1;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtIngreso);
		$stmt->bindParam(2, $txtEgreso);
		$stmt->bindParam(3, $codarqueo);

		$txtIngreso = limpiar($_POST["tipomovimiento"] == "INGRESO" ? number_format($ingreso2BD+$montomovimiento, 2, '.', '') : $ingreso2BD);
		$txtEgreso = limpiar($_POST["tipomovimiento"] == "EGRESO" ? number_format($egresoBD+$totalmovimiento, 2, '.', '') : $egresoBD);
		$codarqueo = limpiar($codarqueoBD);
		$stmt->execute();
		################ ACTUALIZO ARQUEO DE CAJA ###############	
	
	   echo "<span class='fa fa-check-square-o'></span> EL MOVIMIENTO EN CAJA HA SIDO ACTUALIZADO EXITOSAMENTE <a href='reportepdf?numero=".encrypt($numero)."&tipo=".encrypt("TICKETMOVIMIENTO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR TICKET</strong></font color></a></div>";

      echo "<script>window.open('reportepdf?numero=".encrypt($numero)."&tipo=".encrypt("TICKETMOVIMIENTO")."', '_blank');</script>";
      exit;	
	}
	else
	{
		echo "6";
		exit;
	}
}
########################## FUNCION PARA ACTUALIZAR MOVIMIENTOS DE CAJAS ###########################	

######################## FUNCION PARA ELIMINAR MOVIMIENTOS DE CAJAS #########################
public function EliminarMovimientoCajas()
{
	if($_SESSION['acceso'] == "administrador") {

   #################### OBTENEMOS DATOS DE MOVIMIENTO ####################
	$sql = "SELECT * FROM movimientoscajas 
	INNER JOIN arqueocaja ON movimientoscajas.codarqueo = arqueocaja.codarqueo 
	WHERE movimientoscajas.codmovimiento = '".limpiar(decrypt($_GET["codmovimiento"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	//OBTENEMOS CAMPOS DE MOVIMIENTOS
	$codcajaBD = $row['codcaja'];
	$codarqueoBD = $row['codarqueo'];
	$tipomovimientoBD = $row['tipomovimiento'];
	$montomovimientoBD = $row['montomovimiento'];
	//OBTENEMOS CAMPOS DE MOVIMIENTOS

	//OBTENEMOS CAMPOS DE ARQUEO
	$inicialBD = $row['montoinicial'];
	$ingresoBD = $row['ingresos'];
	$ingreso2BD = $row['ingresos2'];
	$egresoBD = $row['egresos'];
	$statusBD = $row['statusarqueo'];
	//OBTENEMOS CAMPOS DE ARQUEO
	#################### OBTENEMOS DATOS DE MOVIMIENTO ####################

	if($statusBD == 1) {

      if($tipomovimientoBD == "INGRESO"){

			################ ACTUALIZO ARQUEO DE CAJA ###############
     	   $sql = " UPDATE arqueocaja set "
			." ingresos2 = ? "
			." WHERE "
			." codarqueo = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $txtIngreso);
			$stmt->bindParam(2, $codarqueo);

			$txtIngreso = number_format($ingreso2BD-$montomovimientoBD, 2, '.', '');
			$codarqueo = limpiar($codarqueoBD);
			$stmt->execute();
			################ ACTUALIZO ARQUEO DE CAJA ###############

      } else {

			################ ACTUALIZO ARQUEO DE CAJA ###############
			$sql = " UPDATE arqueocaja set "
			." egresos = ? "
			." WHERE "
			." codarqueo = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $txtEgreso);
			$stmt->bindParam(2, $codarqueo);

			$txtEgreso = number_format($egresoBD-$montomovimientoBD, 2, '.', '');
			$codarqueo = limpiar($codarqueoBD);
			$stmt->execute();
			################ ACTUALIZO ARQUEO DE CAJA ###############
      }

		################ ELIMINO MOVIMIENTO ###############
		$sql = "DELETE FROM movimientoscajas WHERE codmovimiento = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmovimiento);
		$codmovimiento = decrypt($_GET["codmovimiento"]);
		$stmt->execute();
		################ ELIMINO MOVIMIENTO ###############

		echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################# FUNCION PARA ELIMINAR MOVIMIENTOS DE CAJAS  ##########################

############################# FUNCION BUSCAR MOVIMIENTOS POR FECHAS #############################
public function BuscarMovimientosxFechas() 
{
	self::SetNames();
	$sql = "SELECT * FROM movimientoscajas 
	INNER JOIN cajas ON movimientoscajas.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo
	WHERE movimientoscajas.codcaja = ? 
	AND DATE_FORMAT(movimientoscajas.fechamovimiento,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codcaja'])));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN MOVIMIENTOS DE ESTA CAJA PARA LAS FECHAS INGRESADA</center>";
		echo "</div>";
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################# FUNCION BUSCAR MOVIMIENTOS POR FECHAS #############################

################################# FIN DE CLASE MOVIMIENTOS DE CAJAS ################################

















########################################## CLASE DOCENTES ##########################################

################################## FUNCION REGISTRAR DOCENTES #################################
public function RegistrarDocentes()
{
	self::SetNames();
	if(empty($_POST["ceddoc"]) or empty($_POST["nomdoc"]) or empty($_POST["tlfdoc"]) or empty($_POST["direcdoc"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT ceddoc FROM docentes WHERE ceddoc = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["ceddoc"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO docentes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $ceddoc);
		$stmt->bindParam(2, $nomdoc);
		$stmt->bindParam(3, $tlfdoc);
		$stmt->bindParam(4, $direcdoc);
		$stmt->bindParam(5, $especdoc);
		$stmt->bindParam(6, $fecnacdoc);
		$stmt->bindParam(7, $edocivildoc);
		$stmt->bindParam(8, $lugarnacdoc);
		$stmt->bindParam(9, $correodoc);
		$stmt->bindParam(10, $expedido);
		$stmt->bindParam(11, $horasdoc);
		$stmt->bindParam(12, $codcargodoc);
		$stmt->bindParam(13, $clavedoc);
		$stmt->bindParam(14, $ingresodoc);
		
		$ceddoc = limpiar($_POST["ceddoc"]);
		$nomdoc = limpiar($_POST["nomdoc"]);
		$tlfdoc = limpiar($_POST["tlfdoc"]);
		$direcdoc = limpiar($_POST["direcdoc"]);
		$especdoc = limpiar($_POST["especdoc"]);
		$fecnacdoc = limpiar(date("Y-m-d",strtotime($_POST['fecnacdoc'])));
		$edocivildoc = limpiar($_POST["edocivildoc"]);
		$lugarnacdoc = limpiar($_POST["lugarnacdoc"]);
		$correodoc = limpiar($_POST["correodoc"]);
		$expedido = limpiar($_POST["expedido"]);
		$horasdoc = limpiar($_POST["horasdoc"]);
		$codcargodoc = limpiar($_POST["codcargodoc"]);
		$clavedoc = password_hash($_POST["ceddoc"], PASSWORD_DEFAULT);
		$ingresodoc = limpiar(date("Y-m-d"));
		$stmt->execute();

      echo "<span class='fa fa-check-square-o'></span> EL DOCENTE HA SIDO REGISTRADO EXITOSAMENTE";
      exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
################################## FUNCION REGISTRAR DOCENTES #################################

################################# FUNCION LISTAR DOCENTES ############################
public function ListarDocentes()
{
	self::SetNames();
	$sql = "SELECT * FROM docentes ORDER BY ceddoc ASC ";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
################################# FUNCION LISTAR DOCENTES ############################

############################## FUNCION ID DOCENTES ##############################
public function DocentesPorId()
{
	self::SetNames();
	if ($_SESSION['acceso'] == "docente") {

		$sql = "SELECT * FROM docentes WHERE coddoc = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($_SESSION["coddoc"]));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "";
		}
		else
		{
			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[] = $row;
			}
			return $this->p;
			$this->dbh=null;
		}

	} else {

		$sql = "SELECT * FROM docentes WHERE coddoc = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["coddoc"])));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "";
		}
		else
		{
			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[] = $row;
			}
			return $this->p;
			$this->dbh=null;
		}
	}
}
############################## FUNCION ID DOCENTES ##############################
	
############################## FUNCION ACTUALIZAR DOCENTES #########################
public function ActualizarDocentes()
{
	self::SetNames();
	if(empty($_POST["ceddoc"]) or empty($_POST["nomdoc"]) or empty($_POST["tlfdoc"]) or empty($_POST["direcdoc"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT ceddoc FROM docentes WHERE coddoc != ? AND ceddoc = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["coddoc"]), $_POST["ceddoc"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	$sql = " UPDATE docentes set "
		  ." ceddoc = ?, "
		  ." nomdoc = ?, "
		  ." tlfdoc = ?, "
		  ." direcdoc = ?, "
		  ." especdoc = ?, "
		  ." fecnacdoc = ?, "
		  ." edocivildoc = ?, "
		  ." lugarnacdoc = ?, "
		  ." correodoc = ?, "
		  ." expedido = ?, "
		  ." horasdoc = ?, "
		  ." codcargodoc = ? "
		  ." WHERE "
		  ." coddoc = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $ceddoc);
	$stmt->bindParam(2, $nomdoc);
	$stmt->bindParam(3, $tlfdoc);
	$stmt->bindParam(4, $direcdoc);
	$stmt->bindParam(5, $especdoc);
	$stmt->bindParam(6, $fecnacdoc);
	$stmt->bindParam(7, $edocivildoc);
	$stmt->bindParam(8, $lugarnacdoc);
	$stmt->bindParam(9, $correodoc);
	$stmt->bindParam(10, $expedido);
	$stmt->bindParam(11, $horasdoc);
	$stmt->bindParam(12, $codcargodoc);
	$stmt->bindParam(13, $coddoc);
		
	$ceddoc = limpiar($_POST["ceddoc"]);
	$nomdoc = limpiar($_POST["nomdoc"]);
	$tlfdoc = limpiar($_POST["tlfdoc"]);
	$direcdoc = limpiar($_POST["direcdoc"]);
	$especdoc = limpiar($_POST["especdoc"]);
	$fecnacdoc = limpiar(date("Y-m-d",strtotime($_POST['fecnacdoc'])));
	$edocivildoc = limpiar($_POST["edocivildoc"]);
	$lugarnacdoc = limpiar($_POST["lugarnacdoc"]);
	$correodoc = limpiar($_POST["correodoc"]);
	$expedido = limpiar($_POST["expedido"]);
	$horasdoc = limpiar($_POST["horasdoc"]);
	$codcargodoc = limpiar($_POST["codcargodoc"]);
	$coddoc = limpiar(decrypt($_POST["coddoc"]));
	$stmt->execute();

	if ($_SESSION['acceso'] == "docente") {

		echo "<span class='fa fa-check-square-o'></span> SUS DATOS HAN SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "<span class='fa fa-check-square-o'></span> EL DOCENTE HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;
	}
	}
	else
	{
		echo "2";
		exit;
	}
}
############################## FUNCION ACTUALIZAR DOCENTES #########################

################################## FUNCION REINICIAR CLAVE DOCENTES ###################################
public function ReiniciarDocente()
{
	self::SetNames();
	$sql = " UPDATE docentes set "
		  ." clavedoc = ? "
		  ." WHERE "
		  ." coddoc = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	
	$stmt->bindParam(1, $clavedoc);
	$stmt->bindParam(2,$coddoc);
	
	$ceddoc= limpiar(decrypt($_GET['ceddoc']));
	$clavedoc = password_hash($ceddoc, PASSWORD_DEFAULT);
	$coddoc= limpiar(decrypt($_GET['coddoc']));
	$stmt->execute();

	echo "1";
	exit;
}
################################## FUNCION REINICIAR CLAVE DOCENTES ###################################

############################## FUNCION ELIMINAR DOCENTES ############################
public function EliminarDocentes()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT coddoc FROM notas WHERE coddoc = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["coddoc"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{

	$sql = "DELETE FROM docentes WHERE coddoc = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$coddoc);
	$coddoc = decrypt($_GET["coddoc"]);
	$stmt->execute();
		
		echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################## FUNCION ELIMINAR DOCENTES ############################

####################################### FIN DE CLASE DOCENTES ######################################















############################# CLASE ASIGNACIONES DE MATERIAS A DOCENTES #############################

############################## FUNCION LISTAR MATERIAS POR GRADOS ############################
public function BusquedaMateriasAsignadasxGrados()
{
	self::SetNames();
	############# OBTENGO PERIODO ESCOLAR ACTIVO #############
	$period = "SELECT 
	codperiodo, 
	statusperiodo FROM periodoescolar WHERE statusperiodo = 1";
	foreach ($this->dbh->query($period) as $rowper)
	{
		$this->pper[] = $rowper;
	}
	$codperiodo = (empty($rowper['codperiodo']) ? "" : $rowper['codperiodo']);
	$statusperiodo = (empty($rowper['statusperiodo']) ? "" : $rowper['statusperiodo']);

	if (empty($statusperiodo)) {

		echo "<hr><h5><div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN PERIODO ESCOLAR ACTIVO, POR FAVOR DEBER&Aacute; DE CREARLO PARA CONTINUAR CON LAS ASIGNACIONES DE MATERIAS A DOCENTES</center>";
	   echo "</div></h5>";		
		exit;
	}
	############# OBTENGO PERIODO ESCOLAR ACTIVO #############

	$sql = "SELECT
	materias.codmateria,
	materias.nommateria,
   pag.codasignacion,
   pag.coddoc,
   pag.materias
	FROM materias

	LEFT JOIN
      (SELECT
      codasignacion, coddoc, codturno, codnivel, codgrado, codseccion, codmateria, GROUP_CONCAT(DISTINCT codmateria SEPARATOR ', ') AS materias 
      FROM asignaciones
      WHERE codturno = '".decrypt($_GET["codturno"])."'
      AND codnivel = '".decrypt($_GET["codnivel"])."'
      AND codgrado = '".decrypt($_GET["codgrado"])."'
      AND codseccion = '".decrypt($_GET["codseccion"])."'
      AND codperiodo = '".limpiar($codperiodo)."' 
      GROUP BY codmateria) pag ON pag.codmateria = materias.codmateria 

	WHERE materias.codgrado = ? 
	GROUP BY materias.codmateria
	ORDER BY materias.codmateria ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codgrado"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON MATERIAS ACTUALMENTE </center>";
		echo "</div>";
		exit;
	}
	else
	{
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################## FUNCION LISTAR MATERIAS POR GRADOS ############################

######################### FUNCION PARA REGISTRAR ASIGNACION DE MATERIAS ##########################
public function RegistrarAsignacion()
{
	self::SetNames();
	if(empty($_POST["coddoc"]) or empty($_POST["codturno"]) or empty($_POST["codnivel"]) or empty($_POST["codgrado"]) or empty($_POST["codseccion"]))
	{
		echo "1";
		exit;
	}
	############# OBTENGO PERIODO ESCOLAR ACTIVO #############
	$period = "SELECT codperiodo FROM periodoescolar WHERE statusperiodo = 1";
	foreach ($this->dbh->query($period) as $rowper)
	{
		$this->pper[] = $rowper;
	}
	$codperiodo = (empty($rowper['codperiodo']) ? "" : $rowper['codperiodo']);
	############# OBTENGO PERIODO ESCOLAR ACTIVO #############

	$this->dbh->beginTransaction();
	if(empty($_POST['checkbox']))
	{
	   echo "2";
		exit();
   }

    foreach($_POST['checkbox'] as $selected){
    	if(!empty($_POST['checkbox'])){ 

		   $query = "INSERT INTO asignaciones values (null, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $coddoc);
			$stmt->bindParam(2, $codturno);
			$stmt->bindParam(3, $codnivel);
			$stmt->bindParam(4, $codgrado);
			$stmt->bindParam(5, $codseccion);
			$stmt->bindParam(6, $codmateria);
			$stmt->bindParam(7, $codperiodo);
			$stmt->bindParam(8, $fechaasignacion);

			$coddoc = limpiar($_POST["coddoc"]);
			$codturno = limpiar(decrypt($_POST['codturno']));
			$codnivel = limpiar(decrypt($_POST['codnivel']));
			$codgrado = limpiar(decrypt($_POST['codgrado']));
			$codseccion = limpiar(decrypt($_POST['codseccion']));
			$codmateria = limpiar($selected);
			$fechaasignacion = limpiar(date("Y-m-d"));
			$stmt->execute();

      }//if
   } //for  
   $this->dbh->commit();

	echo "<span class='fa fa-check-square-o'></span> LA ASIGNACION DE MATERIA FUE ASIGNADA AL DOCENTE EXITOSAMENTE";
	exit;
}
############################ FUNCION PARA REGISTRAR ASIGNACION DE MATERIAS ############################

############################## FUNCION LISTAR ASIGNACIONES DE MATERIAS ################################
public function ListarAsignacion()
{
	self::SetNames();
		
	if ($_SESSION['acceso'] == "administrador" || $_SESSION["acceso"]=="secretaria") {

		$sql ="SELECT * FROM asignaciones INNER JOIN materias ON materias.codmateria = asignaciones.codmateria
		LEFT JOIN docentes ON docentes.coddoc = asignaciones.coddoc
		LEFT JOIN turnos ON turnos.codturno = asignaciones.codturno
		LEFT JOIN secciones ON secciones.codseccion = asignaciones.codseccion
		LEFT JOIN grados ON grados.codgrado = materias.codgrado 
		LEFT JOIN niveles ON grados.codnivel = niveles.codnivel 
		INNER JOIN periodoescolar ON asignaciones.codperiodo = periodoescolar.codperiodo 
		WHERE periodoescolar.statusperiodo = 1";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} elseif ($_SESSION['acceso'] == "docente") {

		$sql = "SELECT * FROM asignaciones INNER JOIN materias ON materias.codmateria = asignaciones.codmateria
		LEFT JOIN docentes ON docentes.coddoc = asignaciones.coddoc
		LEFT JOIN turnos ON turnos.codturno = asignaciones.codturno
		LEFT JOIN secciones ON secciones.codseccion = asignaciones.codseccion
		LEFT JOIN grados ON grados.codgrado = materias.codgrado 
		LEFT JOIN niveles ON grados.codnivel = niveles.codnivel
		INNER JOIN periodoescolar ON asignaciones.codperiodo = periodoescolar.codperiodo 
		WHERE asignaciones.coddoc = '".limpiar($_SESSION["coddoc"])."' 
		AND periodoescolar.statusperiodo = 1 
		ORDER BY materias.nommateria ASC";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} elseif ($_SESSION['acceso'] == "estudiante") {

		$sql = "SELECT 
		materias.codmateria,
		materias.nommateria,
      pag.codasignacion,
      pag.coddoc,
      pag.materias,
      pag2.coddoc,
      pag2.ceddoc,
      pag2.nomdoc

		FROM materias

		LEFT JOIN
	      (SELECT
	      codasignacion, 
	      coddoc, 
	      codturno, 
	      codnivel, 
	      codgrado, 
	      codseccion, 
	      codmateria, 
	      GROUP_CONCAT(DISTINCT codmateria SEPARATOR ', ') AS materias 
	      FROM asignaciones
	      WHERE codturno = '".limpiar($_SESSION["codturno"])."'
	      AND codnivel = '".limpiar($_SESSION["codnivel"])."'
	      AND codgrado = '".limpiar($_SESSION["codgrado"])."'
	      AND codseccion = '".limpiar($_SESSION["codseccion"])."'
	      AND codperiodo = '".limpiar($_SESSION["codperiodo"])."' 
	      GROUP BY codmateria) pag ON pag.codmateria = materias.codmateria

	   LEFT JOIN
	      (SELECT
	      coddoc, 
	      ceddoc, 
	      nomdoc 
	      FROM docentes ) pag2 ON pag2.coddoc = pag.coddoc 

		WHERE materias.codnivel = '".limpiar($_SESSION["codnivel"])."'
		AND materias.codgrado = '".limpiar($_SESSION["codgrado"])."' 
		ORDER BY materias.nommateria ASC";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION LISTAR ASIGNACIONES DE MATERIAS ################################

############################ FUNCION ID ASIGNACIONES DE MATERIAS #################################
public function AsignacionMateriasPorId()
{
	self::SetNames();
	$sql ="SELECT * FROM asignaciones INNER JOIN materias ON materias.codmateria = asignaciones.codmateria
	LEFT JOIN docentes ON docentes.coddoc = asignaciones.coddoc
	LEFT JOIN turnos ON turnos.codturno = asignaciones.codturno
	LEFT JOIN secciones ON secciones.codseccion = asignaciones.codseccion
	LEFT JOIN grados ON grados.codgrado = materias.codgrado 
	LEFT JOIN niveles ON grados.codnivel = niveles.codnivel
	INNER JOIN periodoescolar ON asignaciones.codperiodo = periodoescolar.codperiodo 
	WHERE asignaciones.codasignacion = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codasignacion"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################ FUNCION ID ASIGNACIONES DE MATERIAS #################################
	
########################## FUNCION ELIMINAR ASIGNACIONES DE MATERIAS #########################
public function EliminarAsignacion()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT coddoc, codmateria FROM notas WHERE coddoc = ? AND codmateria = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["coddoc"]),decrypt($_GET["codmateria"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	$sql = "DELETE FROM   asignaciones WHERE codasignacion = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codasignacion);
	$codasignacion = decrypt($_GET["codasignacion"]);
	$stmt->execute();
		
		echo "1";
		exit;
		   
	} else {
		   
		echo "2";
		exit;
	}
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR ASIGNACIONES DE MATERIAS #########################

###################### FUNCION BUSQUEDA ASIGNACIONES DE MATERIAS REPORTES ###########################
public function BuscarMateriasAsignadas() 
{
	self::SetNames();
	$sql ="SELECT * FROM asignaciones INNER JOIN materias ON materias.codmateria = asignaciones.codmateria
	LEFT JOIN docentes ON docentes.coddoc = asignaciones.coddoc
	LEFT JOIN turnos ON turnos.codturno = asignaciones.codturno
	LEFT JOIN secciones ON secciones.codseccion = asignaciones.codseccion
	LEFT JOIN grados ON grados.codgrado = materias.codgrado 
	LEFT JOIN niveles ON grados.codnivel = niveles.codnivel
	INNER JOIN periodoescolar ON asignaciones.codperiodo = periodoescolar.codperiodo 
	WHERE asignaciones.coddoc = ?
	AND asignaciones.codperiodo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_SESSION['acceso'] == 'docente' ? $_SESSION['coddoc'] : $_GET['coddoc']));
	$stmt->bindValue(2, trim(decrypt($_GET["codperiodo"])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON ASIGNACIONES DE MATERIAS PARA EL DOCENTE SELECCIONADO</center>";
			echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA ASIGNACIONES DE MATERIAS REPORTES ###########################

######################### FIN DE CLASE ASIGNACIONES DE MATERIAS A DOCENTES #########################

























################################### CLASE ESTUDIANTES #######################################

########################## FUNCION BUSQUEDA ESTUDIANTES PARA INSCRIPCIONES #####################
public function BuscarEstudiante()
{
	self::SetNames();
	############# OBTENGO DATOS DE CONFIGURACION #############
	$conf = "SELECT * FROM configuracion";
	foreach ($this->dbh->query($conf) as $rowcon)
	{
		$this->pcon[] = $rowcon;
	}
	$fecha = strftime("%Y-%m-%d"); //fecha tipo 2011/06/14
	$inicio_inscripcion = (empty($rowcon['inicioinscripcion']) ? "" : $rowcon['inicioinscripcion']);
   $fin_inscripcion = (empty($rowcon['fininscripcion']) ? "" : $rowcon['fininscripcion']);
	$cobrar_cuotas = (empty($rowcon['cobrar_cuotas']) ? 0 : $rowcon['cobrar_cuotas']);
	############# OBTENGO DATOS DE CONFIGURACION #############

	############# OBTENGO PERIODO ESCOLAR ACTIVO #############
	$period = "SELECT * FROM periodoescolar WHERE statusperiodo = 1";
	foreach ($this->dbh->query($period) as $rowper)
	{
		$this->pper[] = $rowper;
	}
	$periodo = (empty($rowper['periodo']) ? "" : $rowper['periodo']);
	$mesesactivos = (empty($rowper['mesesactivos']) ? "" : $rowper['mesesactivos']);
	$montoinscripcion = (empty($rowper['montoinscripcion']) ? "" : $rowper['montoinscripcion']);
	$cuotaunica = (empty($rowper['cuotaunica']) ? "" : $rowper['cuotaunica']);
	$statusperiodo = (empty($rowper['statusperiodo']) ? "" : $rowper['statusperiodo']);

	if (empty($statusperiodo)) {

		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN PERIODO ESCOLAR ACTIVO, POR FAVOR DEBER&Aacute; DE CREARLO</center>";
	   echo "</div>";		
		exit;
	}
	############# OBTENGO PERIODO ESCOLAR ACTIVO #############

	############# VERIFICO SI HAY TURNOS #############
	$sql ="SELECT * FROM turnos";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN TURNOS REGISTRADOS, POR FAVOR DEBER&Aacute; DE CREARLOS</center>";
	   echo "</div>";		
	   exit;
	}
	############# VERIFICO SI HAY TURNOS #############

	############# VERIFICO SI HAY NIVELES #############
	$sql ="SELECT * FROM niveles";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN NIVELES REGISTRADOS, POR FAVOR DEBER&Aacute; DE CREARLOS</center>";
	   echo "</div>";		
		exit;
	}
	############# VERIFICO SI HAY NIVELES #############

	############# VERIFICO SI HAY GRADOS #############
	$sql ="SELECT * FROM grados";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN GRADOS REGISTRADOS, POR FAVOR DEBER&Aacute; DE CREARLOS</center>";
	   echo "</div>";		
	   exit;
	}
	############# VERIFICO SI HAY GRADOS #############

	############# VERIFICO SI HAY SECCIONES #############
	$sql ="SELECT * FROM secciones";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	   echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN SECCIONES REGISTRADAS, POR FAVOR DEBER&Aacute; DE CREARLAS</center>";
	   echo "</div>";		
		exit;
	}
	############# VERIFICO SI HAY SECCIONES #############

	if($cobrar_cuotas == 1){
		################### VERIFICO QUE TENGA UN CAJA APERTURADA ###################
		$sql = "SELECT * FROM arqueocaja 
		INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
		WHERE cajas.codigo = ".limpiar($_SESSION["codigo"])." 
		AND statusarqueo = 1";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "<div class='alert alert-danger'>";
			echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
			echo "<center><span class='fa fa-info-circle'></span> POR FAVOR, DEBE DE REALIZAR EL ARQUEO DE CAJA PARA PROCESAR INSCRIPCIONES Y COBROS DE CUOTAS,<br> PARA HACER EL ARQUEO DE CAJA HAZ CLIC <a href='arqueos'>AQUI</a></center>";
			echo "</div>";
			exit();
		}
		################### VERIFICO QUE TENGA UN CAJA APERTURADA ###################
   }

	################### VERIFICO INSCRIPCION ###################
	$est = "SELECT * FROM (estudiantes INNER JOIN padres ON estudiantes.codpadre = padres.codpadre) 
	INNER JOIN turnos ON estudiantes.codturno = turnos.codturno
	INNER JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	INNER JOIN grados ON estudiantes.codgrado = grados.codgrado
	INNER JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	INNER JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo 
	WHERE estudiantes.cedest = '".limpiar($_GET["cedula"])."' 
	AND estudiantes.statusest = 1";
	$stmt = $this->dbh->prepare($est);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($row3 = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p3[] = $row3;
	}
	if($num>0)
	{		
	?>
	<div class="row">
   <div class="col-sm-12">
   <div class="panel panel-primary">
   <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-tasks"></i> Datos del Estudiante</h3></div>
   <div class="panel-body">
   <div class="row">
   <div class="col-sm-12 col-xs-12">
   <div class="box-body">

	<div class="row"> 
		<div class="col-md-3"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">N&deg; de Documento : <span class="symbol required"></span></label>
				<br /><abbr title="N&deg; de Documento  del Estudiante"><?php echo $row3['cedest']; ?></abbr>

			</div> 
		</div>

		<div class="col-md-6"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Apellidos y Nombres: <span class="symbol required"></span></label> 
				<br /><abbr title="Apellidos y Nombres del Estudiante"><?php echo $row3['papeest']." ".$row3['sapeest']." ".$row3['pnomest']." ".$row3['snomest']; ?></abbr>
			</div>
		</div>
		<div class="col-md-3"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Nivel: <span class="symbol required"></span></label> 
				<br /><abbr title="Nivel"><?php echo $row3['nivel']; ?></abbr>
			</div> 
		</div>  	
	</div>

	<div class="row">  
		<div class="col-md-3"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Turno: <span class="symbol required"></span></label> 
				<br /><abbr title="Turno"><?php echo $row3['turno']; ?></abbr>
			</div> 
		</div> 

		<div class="col-md-6"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Grado y Secci&oacute;n: <span class="symbol required"></span></label> 
				<br /><abbr title="Grado y Secci&oacute;n"><?php echo $row3['grado']." / SECCI&Oacute;N '".$row3['seccion']."'"; ?></abbr>
			</div> 
		</div>

		<div class="col-md-3"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Becado: <span class="symbol required"></span></label> 
				<br /><abbr title="Becado"><?php echo $row3['becado']; ?></abbr>  
			</div> 
		</div>
	</div>	

	<div class="row"> 
		<div class="col-md-3"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Periodo Escolar: <span class="symbol required"></span></label> 
				<br /><abbr title="Periodo Escolar Inscrito"><?php echo $row3['periodo']; ?></abbr>  
			</div> 
		</div>

		<div class="col-md-6"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Fecha de Inscripci&oacute;n: <span class="symbol required"></span></label> 
				<br /><abbr title="Fecha de Inscripci&oacute;n"><?php echo date("d-m-Y",strtotime($row3['fechainscripcion'])); ?></abbr>
			</div> 
		</div> 

		<div class="col-md-3"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Edad: <span class="symbol required"></span></label> 
				<br />
				<abbr title="Edad"><?php echo edad($row3['fnacest'])." A&Ntilde;OS"; ?></abbr>
			</div> 
		</div> 
	</div>

	<div class="row">
		<div class="col-md-3"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">N&deg; de Doc. de Padre/Tutor: <span class="symbol required"></span></label> 
				<br /><abbr title="N&deg; de Documento  de Padre/Tutor"><?php echo $row3['cedpadre']; ?></abbr>  
			</div> 
		</div>

		<div class="col-md-6"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Nombres y Apellidos Padre/Tutor: <span class="symbol required"></span></label> 
				<br /><abbr title="Nombres y Apellidos Padre/Tutor"><?php echo $row3['nompadre']." ".$row3['apepadre']; ?></abbr> 
			</div> 
		</div>

		<div class="col-md-3"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">N&deg; de Tel&eacute;fono: <span class="symbol required"></span></label> 
				<br /><abbr title="N&deg; de Tel&eacute;fono"><?php echo $row3['tlfpadre']; ?></abbr>  
			</div> 
		</div> 
	</div>
                     </div><!-- /.box-body -->
					   </div>
               </div>
            </div>
         </div>
      </div>
	</div>

	<?php
	exit;
	}

	$sql = "SELECT * FROM estudiantes 
	INNER JOIN padres ON estudiantes.codpadre = padres.codpadre 
	WHERE estudiantes.cedest = ? 
	AND estudiantes.statusest = 0";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["cedula"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
	if($fecha >= $inicio_inscripcion && $fecha <= $fin_inscripcion) {
	?>
	<div class="row">
	<div class="col-sm-12">
	<div class="panel panel-primary">
	<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-edit"></i> Datos del Estudiante</h3></div>
	<div class="panel-body">
	<div class="row">
	<div class="col-sm-12 col-xs-12">
   <div class="box-body">

	<div class="row"> 
		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">N&deg; de Documento : <span class="symbol required"></span></label>
				<input type="hidden" name="proceso" id="proceso" value="save"/> 
				<input type="hidden" name="cobrar_cuotas" id="cobrar_cuotas" value="<?php echo $cobrar_cuotas; ?>"/>
				<input type="hidden" name="cuotaunica" id="cuotaunica" value="<?php echo $cuotaunica; ?>"/>
				<input name="cedest" class="form-control" type="text" id="cedest" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese N&deg; de Documento  de Estudiante" autocomplete="off" value="<?php echo $_GET['cedula']; ?>" required="required"/>
				<i class="fa fa-pencil form-control-feedback"></i>   
			</div> 
		</div>

		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Primer Nombre: <span class="symbol required"></span></label> 
				<input name="pnomest" class="form-control" type="text" id="pnomest" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Primer Nombre de Estudiante" autocomplete="off" required="required"/>
				<i class="fa fa-pencil form-control-feedback"></i>  
			</div> 
		</div>  
		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Segundo Nombre: </label> 
				<input name="snomest" class="form-control" type="text" id="snomest" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Segundo Nombre de Estudiante" autocomplete="off"/>
				<i class="fa fa-pencil form-control-feedback"></i>  
			</div> 
		</div>  
	</div>
          
	<div class="row">
		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Primer Apellido: <span class="symbol required"></span></label> 
				<input name="papeest" class="form-control" type="text" id="papeest" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Primer Apellido de Estudiante" autocomplete="off" required="required"/>
				<i class="fa fa-pencil form-control-feedback"></i>  
			</div> 
		</div>  

		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Segundo Apellido: </label> 
				<input name="sapeest" class="form-control" type="text" id="sapeest" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Segundo Apellido de Estudiante" autocomplete="off"/>
				<i class="fa fa-pencil form-control-feedback"></i>  
			</div> 
		</div> 

		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Sexo: <span class="symbol required"></span></label> 
				<i class="fa fa-bars form-control-feedback"></i>
				<select style="color:#000;font-weight:bold;" name="sexoest" id="sexoest" class='form-control' required="required">
					<option value=""> -- SELECCIONE -- </option>
					<option value="MASCULINO">MASCULINO</option>
					<option value="FEMENINO">FEMENINO</option>
				</select>  
			</div> 
		</div>  
	</div>

	<div class="row"> 
		<div class="col-md-8"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Direcci&oacute;n Domiciliaria: <span class="symbol required"></span></label> 
				<input name="direcest" class="form-control" type="text" id="direcest" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Direcci&oacute;n Domiciliaria" autocomplete="off" required="required"/>
				<i class="fa fa-map-marker form-control-feedback"></i>  
			</div> 
		</div> 

		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Fecha de Nacimiento: <span class="symbol required"></span></label> 
				<input name="fnacest" class="form-control" type="text" id="fnacest" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Fecha de Nacimiento" autocomplete="off" required="required"/>
				<i class="fa fa-calendar form-control-feedback"></i>  
			</div> 
		</div>  
	</div> 
           
	<div class="row"> 
		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Seleccione Turno: <span class="symbol required"></span></label> 
				<i class="fa fa-bars form-control-feedback"></i>
				<select style="color:#000;font-weight:bold;" name="codturno" id="codturno" class="form-control" required="required">
					<option value=""> -- SELECCIONE -- </option>
					<?php
					$turno = new Login();
					$turno = $turno->ListarTurno();
					if($turno==""){ 
						echo "";
					} else {
					for($i=0;$i<sizeof($turno);$i++){
						?>
						<option value="<?php echo encrypt($turno[$i]['codturno']); ?>"><?php echo $turno[$i]['turno'] ?></option>
					<?php } } ?>
				</select>  
			</div> 
		</div> 

		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Seleccione Nivel: <span class="symbol required"></span></label> 
				<i class="fa fa-bars form-control-feedback"></i>
				<select style="color:#000;font-weight:bold;" name="codnivel" id="codnivel" class="form-control" onChange="CargarGrados(this.form.codnivel.value); CargarMesPago(this.form.codnivel.value);" required="required">
					<option value=""> -- SELECCIONE -- </option>
					<?php
					$nivel = new Login();
					$nivel = $nivel->ListarNivel();
					if($nivel==""){ 
						echo "";
					} else {
					for($i=0;$i<sizeof($nivel);$i++){
					?>
					<option value="<?php echo encrypt($nivel[$i]['codnivel']); ?>"><?php echo $nivel[$i]['nivel'] ?></option>       
					<?php } } ?>
				</select>  

				<div id="muestracampomonto"><input type="hidden" name="montopago" id="montopago" value=""/></div>    
			</div> 
		</div>                

		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Seleccione Grado: <span class="symbol required"></span></label>
				<i class="fa fa-bars form-control-feedback"></i> 
				<select style="color:#000;font-weight:bold;" name="codgrado" id="codgrado" class="form-control"  onChange="CargarSecciones(this.form.codgrado.value);" required="required">
					<option value=""> -- SIN RESULTADOS -- </option>
				</select>        
			</div> 
		</div>
	</div>
           
	<div class="row">  
		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Seleccione Secci&oacute;n: <span class="symbol required"></span></label>  <i class="fa fa-bars form-control-feedback"></i>
				<select style="color:#000;font-weight:bold;" name="codseccion" id="codseccion" class="form-control" required="required">
					<option value=""> -- SIN RESULTADOS -- </option>
				</select> 
			</div> 
		</div>  

		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Esta Becado: <span class="symbol required"></span></label>
				<i class="fa fa-bars form-control-feedback"></i> 
				<select style="color:#000;font-weight:bold;" name="becado" id="becado" class="form-control" onChange="ActivaPagos(this.form.montopago.value,this.form.becado.value);" required="required">
					<option value=""> -- SELECCIONE -- </option>
					<option value="NO">NO</option>
					<option value="MEDIA">MEDIA</option>
					<option value="COMPLETA">COMPLETA</option>
				</select>        
			</div> 
		</div>

		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Periodo Escolar: <span class="symbol required"></span></label> 
				<input style="color:#000;font-weight:bold;" name="periodo" class="form-control" type="text" id="periodo" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Periodo Escolar" autocomplete="off" value="<?php echo $periodo; ?>" readonly="readonly"/>
				<i class="fa fa-calendar form-control-feedback"></i>  
			</div> 
		</div>  
   </div>             
                     </div><!-- /.box-body -->
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>


   <div id="muestraforpagos"></div>


	<div class="row">
	<div class="col-sm-12">
	<div class="panel panel-primary">
	<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-edit"></i> Datos del Representante o Tutor</h3></div>
	<div class="panel-body">
	<div class="row">
	<div class="col-sm-12 col-xs-12">
   <div class="box-body">

	<div class="row"> 
		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">N&deg; de Documento  de Padre/Tutor: <span class="symbol required"></span></label> 
				<input type="hidden" name="statuspad" id="statuspad" value="">
				<input name="cedpadre" class="form-control" type="text" id="cedpadre" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese N&deg; de Documento  de Padre/Tutor" autocomplete="off" required="required"/>
				<i class="fa fa-pencil form-control-feedback"></i>   
			</div> 
		</div>

		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">Nombres: <span class="symbol required"></span></label> 
				<input name="nompadre" class="form-control" type="text" id="nompadre" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Nombre de Padre/Tutor" autocomplete="off" required="required"/>
				<i class="fa fa-pencil form-control-feedback"></i>  
			</div> 
		</div>

		<div class="col-md-4">
			<div class="form-group has-feedback"> 
				<label class="control-label">Apellidos: <span class="symbol required"></span></label> 
				<input name="apepadre" class="form-control" type="text" id="apepadre" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Apellidos de Padre/Tutor" autocomplete="off" required="required"/>
				<i class="fa fa-pencil form-control-feedback"></i>  
			</div> 
		</div>  
	</div>

	<div class="row">  
		<div class="col-md-4"> 
			<div class="form-group has-feedback"> 
				<label class="control-label">N&deg; de Tel&eacute;fono: <span class="symbol required"></span></label> 
				<input name="tlfpadre" class="form-control" type="text" id="tlfpadre" onKeyUp="this.value=this.value.toUpperCase();" placeholder="Ingrese Tel&eacute;fono de Padre/Tutor" autocomplete="off" required="required"/>
				<i class="fa fa-phone form-control-feedback"></i>    
			</div> 
		</div>   
	</div> <br>

     <div class="text-right">
<button type="submit" name="btn-submit" id="btn-submit" class="btn btn-primary"><span class="fa fa-save"></span> Inscribir</button>
<button class="btn btn-danger" type="button" onclick="
        document.getElementById('cedest').value = '',
        document.getElementById('pnomest').value = '',
        document.getElementById('snomest').value = '',
		  document.getElementById('papeest').value = '',
        document.getElementById('sapeest').value = '',
		  document.getElementById('sexoest').value = '',
		  document.getElementById('direcest').value = '',
		  document.getElementById('fnacest').value = '',
		  document.getElementById('codturno').value = '',
		  document.getElementById('codnivel').value = '',
		  document.getElementById('codgrado').value = '',
		  document.getElementById('codseccion').value = '',
		  document.getElementById('becado').value = '',
        document.getElementById('cedpadre').value = '',
        document.getElementById('nompadre').value = '',
        document.getElementById('apepadre').value = '',
        document.getElementById('tlfpadre').value = ''
        "><i class="fa fa-trash-o"></i> Limpiar</button>
                  </div>

                        </div><!-- /.box-body -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
            
	<?php
	exit;

	} else {

	   echo "<div class='alert alert-danger'>";
	   echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
      echo "<center><span class='fa fa-info-circle'></span> EN ESTE MOMENTO EL PROCESO DE INSCRIPCI&Oacute;N, SE ENCUENTRA CERRADO O DESACTIVADO, <br> DIRIJASE AL ADMINISTRADOR DEL SISTEMA PARA QUE LO REINICIE O ACTIVE</center>";
      echo "</div>";
      exit; 
   } 

   } else {
            
      if($row = $stmt->fetch(PDO::FETCH_ASSOC))
      {
         $this->p[] = $row;
      }
      return $this->p;
      $this->dbh=null;
	}
}
########################## FUNCION BUSQUEDA ESTUDIANTES PARA INSCRIPCIONES #####################

########################### FUNCION REGISTRAR INSCRIPCIONES ###############################
public function RegistrarEstudiantes() 
{	
	self::SetNames();
	################ OBTENGO DATOS DE CONFIGURACION ################
	$conf = "SELECT * FROM configuracion";
	foreach ($this->dbh->query($conf) as $rowcon)
	{
		$this->pcon[] = $rowcon;
	}
	$cobrar_cuotas = (empty($rowcon['cobrar_cuotas']) ? 0 : $rowcon['cobrar_cuotas']);
	################ OBTENGO DATOS DE CONFIGURACION ################

	if($cobrar_cuotas == 1){

	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql2 = "SELECT
	cajas.codigo,
	arqueocaja.codarqueo,
	arqueocaja.codcaja,
	arqueocaja.ingresos
	FROM arqueocaja 
   INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
   WHERE cajas.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->execute(array(limpiar($_SESSION["codigo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "1";
	   exit;

	} else {
		
		if($row2 = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p2[] = $row2;
		}
		$codarqueoBD = $row2['codarqueo'];
		$codcajaBD = $row2['codcaja'];
		$ingresoBD = ($row2['ingresos']== "" ? "0.00" : $row2['ingresos']);
	}
   ####################### VERIFICO ARQUEO DE CAJA #######################
   }

	if(empty($_POST["cedest"]) or empty($_POST["pnomest"]) or empty($_POST["papeest"]))
	{
		echo "2";
		exit;
	}

	################ OBTENGO PERIODO ESCOLAR ACTIVO ################
	$period = "SELECT * FROM periodoescolar WHERE statusperiodo = 1";
	foreach ($this->dbh->query($period) as $rowper)
	{
		$this->pper[] = $rowper;
	}
	$codperiodo = (empty($rowper['codperiodo']) ? "" : $rowper['codperiodo']);
	//$inscripcion = (empty($rowper['montoinscripcion']) ? "" : $rowper['montoinscripcion']);
	//$cuota = (empty($rowper['cuotaunica']) ? "" : $rowper['cuotaunica']);
   $diasvence = (empty($rowper['diasvence']) ? "" : $rowper['diasvence']);
   $mesesactivos = explode(", ",$rowper['mesesactivos']);
   $inicio = reset($mesesactivos); // Primero
   $fin = end($mesesactivos); // Ultimo
	################ OBTENGO PERIODO ESCOLAR ACTIVO ################
	
	################ OBTENGO LOS NIVELES Y detallespagos  ###################
	$niv = "SELECT codnivel, nivel, pagonivel FROM niveles WHERE codnivel = '".decrypt($_POST["codnivel"])."'";
	foreach ($this->dbh->query($niv) as $row3)
	{
		$this->p3[] = $row3;
	}
	$codigonivel = $row3['codnivel'];
	$nivel = $row3['nivel'];
	$pagonivel = $row3['pagonivel'];
	################ OBTENGO LOS NIVELES Y detallespagos  ###################

   ######################## FUNCION PARA CODIGO DE ESTUDIANTE ###########################
   $sql = "SELECT codest FROM estudiantes ORDER BY idest DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$numest=$row["codest"];
	}
	if(empty($numest))
	{
		$codigoest = "A1";

	} else {
		$resto = substr($numest, 0, 1);
		$coun = strlen($resto);
		$num     = substr($numest, $coun);
		$codigo     = $num + 1;
		$codigoest = "A".$codigo;
	}
   ######################## FUNCION PARA CODIGO DE ESTUDIANTE ###########################

   if($cobrar_cuotas == 1){

   ################### CREO NUMERO DE COMPROBANTE ####################
	$sql = "SELECT id_contador, contador_numero 
	FROM contador_cuotas ORDER BY id_contador DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$id = $row["id_contador"];
		$contador = $row["contador_numero"];
	}
	if(empty($contador))
	{
		$numero_pago = "01";

		################# REGISTRO CONTADOR #################
		$query = "INSERT INTO contador_cuotas VALUES (null, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1,$contador_numero);

		$contador_numero = limpiar($numero_pago);
		$stmt->execute();
		################# REGISTRO CONTADOR #################

	} else {

		$num = substr($contador, 0);
      $dig = $contador + 1;
      $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
      $numero_pago = $codigofinal;

      ################# ACTUALIZO CONTADOR #################
      $sql = " UPDATE contador_cuotas SET "
		." contador_numero = ? "
		." WHERE "
		." id_contador = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $contador_numero);
		$stmt->bindParam(2, $id_contador);

		$contador_numero = limpiar($numero_pago);
		$id_contador = limpiar($id);
		$stmt->execute();
		################# ACTUALIZO CONTADOR #################
	}
   ################### CREO NUMERO DE COMPROBANTE ####################

   }

   $sql = " SELECT codpadre, cedpadre FROM padres WHERE cedpadre = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST["cedpadre"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		################ REGISTRAMOS DATOS DEL TUTOR ###################
		$query = "INSERT INTO padres values (null, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cedpadre);
		$stmt->bindParam(2, $nompadre);
		$stmt->bindParam(3, $apepadre);
		$stmt->bindParam(4, $tlfpadre);
		$stmt->bindParam(5, $statuspad);
		
		$cedpadre = limpiar($_POST["cedpadre"]);
		$nompadre = limpiar($_POST["nompadre"]);
		$apepadre = limpiar($_POST["apepadre"]);
		$tlfpadre = limpiar($_POST["tlfpadre"]);
		$statuspad = limpiar("1");
		$stmt->execute();
		################ REGISTRAMOS DATOS DEL TUTOR ###################

	   ####### OBTENGO EL ULTIMO ID DE LOCALIDAD #######
		$lastIdTutor = $this->dbh->lastInsertId();
		####### OBTENGO EL ULTIMO ID DE LOCALIDAD #######

	} else {

	   ####### OBTENGO EL ULTIMO ID DE LOCALIDAD #######
	   if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[]=$row;
		}
		$lastIdTutor = $p[0]["codpadre"];
		####### OBTENGO EL ULTIMO ID DE LOCALIDAD ####### 
	}

	################ REGISTRAMOS DATOS DEL ESTUDIANTE ###################
   $query = "INSERT INTO estudiantes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpadre);
	$stmt->bindParam(2, $codest);
	$stmt->bindParam(3, $cedest);
	$stmt->bindParam(4, $pnomest);
	$stmt->bindParam(5, $snomest);
	$stmt->bindParam(6, $papeest);
	$stmt->bindParam(7, $sapeest);
	$stmt->bindParam(8, $sexoest);
	$stmt->bindParam(9, $direcest);
	$stmt->bindParam(10, $fnacest);
	$stmt->bindParam(11, $codturno);
	$stmt->bindParam(12, $codnivel);
	$stmt->bindParam(13, $codgrado);
	$stmt->bindParam(14, $codseccion);
	$stmt->bindParam(15, $codperiodo);
	$stmt->bindParam(16, $becado);
	$stmt->bindParam(17, $observacionest);
	$stmt->bindParam(18, $retiroest);
	$stmt->bindParam(19, $claveest);
	$stmt->bindParam(20, $statusest);
	$stmt->bindParam(21, $fechainscripcion);
	
	$codpadre = limpiar($lastIdTutor);
	$codest = limpiar($codigoest);
	$cedest = limpiar($_POST["cedest"]);
	$pnomest = limpiar($_POST["pnomest"]);
	$snomest = limpiar($_POST["snomest"]);
	$papeest = limpiar($_POST["papeest"]);
	$sapeest = limpiar($_POST["sapeest"]);
	$sexoest = limpiar($_POST["sexoest"]);
	$direcest = limpiar($_POST["direcest"]);
	$fnacest = limpiar(date("Y-m-d",strtotime($_POST['fnacest'])));
	$codturno = limpiar(decrypt($_POST["codturno"]));
	$codnivel = limpiar(decrypt($_POST["codnivel"]));
	$codgrado = limpiar(decrypt($_POST["codgrado"]));
	$codseccion = limpiar(decrypt($_POST["codseccion"]));
	$becado = limpiar($_POST["becado"]);
	$observacionest = limpiar("0");
	$retiroest = limpiar("0000-00-00");
	$claveest = password_hash($_POST["cedest"], PASSWORD_DEFAULT);
	$statusest = limpiar("1");
	$fechainscripcion = limpiar(date("Y-m-d"));
	$stmt->execute();
	################ REGISTRAMOS DATOS DEL ESTUDIANTE ###################
	
   if($_POST["becado"]=="COMPLETA"){

	   if($cobrar_cuotas == 1){

	   ################ REGISTRO PAGO ###################
	   $query = "INSERT INTO pagos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codarqueo);
		$stmt->bindParam(2, $codcaja);
		$stmt->bindParam(3, $numcomprobante);
		$stmt->bindParam(4, $codest);
		$stmt->bindParam(5, $codturno);
	   $stmt->bindParam(6, $codnivel);
	   $stmt->bindParam(7, $codgrado);
		$stmt->bindParam(8, $codseccion);
		$stmt->bindParam(9, $codperiodo);
		$stmt->bindParam(10, $becado);
		$stmt->bindParam(11, $subtotal);
		$stmt->bindParam(12, $descuento);
		$stmt->bindParam(13, $totaldescuento);
		$stmt->bindParam(14, $montoinscripcion);
		$stmt->bindParam(15, $cuotaunica);
		$stmt->bindParam(16, $montomesextra);
		$stmt->bindParam(17, $totalvencidas);
		$stmt->bindParam(18, $totalpendiente);
		$stmt->bindParam(19, $totalpagada);
		$stmt->bindParam(20, $totalintereses);
		$stmt->bindParam(21, $totalpago);
		$stmt->bindParam(22, $codmediopago);
		$stmt->bindParam(23, $codigo);
		$stmt->bindParam(24, $fechapago);
		
		$codarqueo = limpiar($codarqueoBD);
		$codcaja = limpiar($codcajaBD);
		$numcomprobante = limpiar($numero_pago);
		$codest = limpiar($codigoest);	
		$codturno = limpiar(decrypt($_POST["codturno"]));
	   $codnivel = limpiar(decrypt($_POST["codnivel"]));
	   $codgrado = limpiar(decrypt($_POST["codgrado"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
	   $subtotal = limpiar($_POST["textSubtotal"]);
	   $descuento = limpiar($_POST["descuento"]);
	   $totaldescuento = limpiar($_POST["txtDescuento"]);
	   $montoinscripcion = limpiar($_POST["montoinscripcion"]);
	   $cuotaunica = limpiar($_POST["cuotaunica"]);
	   $montomesextra = limpiar("0.00");
	   $totalvencidas = limpiar("0");
	   $totalpendiente = limpiar("0");
	   $totalpagada = limpiar("0");
	   $totalintereses = limpiar("0.00");
	   $totalpago = limpiar($_POST["txtTotal"]);
		$codmediopago = limpiar(decrypt($_POST['codmediopago']));
	   $codigo = limpiar($_SESSION['codigo']);
	   $fechapago = limpiar(date("Y-m-d"));
	   $stmt->execute();
	   ################ REGISTRO PAGO ###################

	   ################ REGISTRAMOS CUOTA PRIMER MES ###################
	   $query = "INSERT INTO detallespagos  values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $numcomprobante);
		$stmt->bindParam(2, $codest);
		$stmt->bindParam(3, $codturno);
		$stmt->bindParam(4, $codseccion);
		$stmt->bindParam(5, $codperiodo);
		$stmt->bindParam(6, $becado);
		$stmt->bindParam(7, $mespago);
		$stmt->bindParam(8, $montopago);
		$stmt->bindParam(9, $fechapago);
		$stmt->bindParam(10, $statuspago);
	   $stmt->bindParam(11, $codigo);
		
		$numcomprobante = limpiar($numero_pago);
		$codest = limpiar($codigoest);
		$codturno = limpiar(decrypt($_POST["codturno"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
		$mespago = limpiar($inicio);
      $montopago = limpiar($pagonivel);
	   $fechapago = limpiar(date("Y-m-d"));
		$statuspago = limpiar("1");
	   $codigo = limpiar($_SESSION['codigo']);
	   $stmt->execute();
	   ################ REGISTRAMOS CUOTA PRIMER MES ###################

	   ################ REGISTRAMOS CUOTA ULTIMO MES ###################
	   $query = "INSERT INTO detallespagos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $numcomprobante);
		$stmt->bindParam(2, $codest);
		$stmt->bindParam(3, $codturno);
		$stmt->bindParam(4, $codseccion);
		$stmt->bindParam(5, $codperiodo);
		$stmt->bindParam(6, $becado);
		$stmt->bindParam(7, $mespago);
		$stmt->bindParam(8, $montopago);
		$stmt->bindParam(9, $fechapago);
		$stmt->bindParam(10, $statuspago);
	   $stmt->bindParam(11, $codigo);
		
		$numcomprobante = limpiar($numero_pago);
		$codest = limpiar($codigoest);
		$codturno = limpiar(decrypt($_POST["codturno"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
		$mespago = limpiar($fin);
      $montopago = limpiar($pagonivel);
	   $fechapago = limpiar(date("Y-m-d"));
		$statuspago = limpiar("1");
	   $codigo = limpiar($_SESSION['codigo']);
	   $stmt->execute();
	   ################ REGISTRAMOS CUOTA ULTIMO MES ###################

	   ####################### PROCESO COBRO EN CAJA #######################
		$sql = " UPDATE arqueocaja set "
		." ingresos = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtTotal);
		$stmt->bindParam(2, $codarqueo);

		$txtTotal = number_format($ingresoBD+$_POST["txtTotal"], 2, '.', '');
		$codarqueo = limpiar($codarqueoBD);
		$stmt->execute();

		$query = " INSERT INTO mediospagoxpagos  values (null, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codarqueoBD);
		$stmt->bindParam(2, $codcajaBD);
		$stmt->bindParam(3, $numcomprobante);
		$stmt->bindParam(4, $codmediopago);
		$stmt->bindParam(5, $montopagado);
		$stmt->bindParam(6, $montodevuelto);

		$numcomprobante = limpiar($numero_pago);
		$codmediopago = limpiar(decrypt($_POST['codmediopago']));
		$montopagado = number_format($_POST["txtTotal"], 2, '.', '');
		$montodevuelto = limpiar("0.00");
		$stmt->execute();
	   ####################### PROCESO COBRO EN CAJA #######################

	   echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO INSCRITO EXITOSAMENTE <a href='reportepdf?numcomprobante=".encrypt($numero_pago)."&tipo=".encrypt("COMPROBANTEPAGOS")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Comprobante' target='_black'><strong>IMPRIMIR COMPROBANTE DE PAGO</strong></a>";
	   exit;

    } else {

	   echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO INSCRITO EXITOSAMENTE";
	   exit;
   }
		  
	} else {

	if($cobrar_cuotas == 1){

		################ REGISTRO PAGO ###################
	   $query = "INSERT INTO pagos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codarqueo);
		$stmt->bindParam(2, $codcaja);
		$stmt->bindParam(3, $numcomprobante);
		$stmt->bindParam(4, $codest);
		$stmt->bindParam(5, $codturno);
	   $stmt->bindParam(6, $codnivel);
	   $stmt->bindParam(7, $codgrado);
		$stmt->bindParam(8, $codseccion);
		$stmt->bindParam(9, $codperiodo);
		$stmt->bindParam(10, $becado);
		$stmt->bindParam(11, $subtotal);
		$stmt->bindParam(12, $descuento);
		$stmt->bindParam(13, $totaldescuento);
		$stmt->bindParam(14, $montoinscripcion);
		$stmt->bindParam(15, $cuotaunica);
		$stmt->bindParam(16, $montomesextra);
		$stmt->bindParam(17, $totalvencidas);
		$stmt->bindParam(18, $totalpendiente);
		$stmt->bindParam(19, $totalpagada);
		$stmt->bindParam(20, $totalintereses);
		$stmt->bindParam(21, $totalpago);
		$stmt->bindParam(22, $codmediopago);
		$stmt->bindParam(23, $codigo);
		$stmt->bindParam(24, $fechapago);
		
		$codarqueo = limpiar($codarqueoBD);
		$codcaja = limpiar($codcajaBD);
		$numcomprobante = limpiar($numero_pago);
		$codest = limpiar($codigoest);	
		$codturno = limpiar(decrypt($_POST["codturno"]));
	   $codnivel = limpiar(decrypt($_POST["codnivel"]));
	   $codgrado = limpiar(decrypt($_POST["codgrado"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
	   $subtotal = limpiar($_POST["textSubtotal"]);
	   $descuento = limpiar($_POST["descuento"]);
	   $totaldescuento = limpiar($_POST["txtDescuento"]);
	   $montoinscripcion = limpiar($_POST["montoinscripcion"]);
	   $cuotaunica = limpiar($_POST["cuotaunica"]);
	   $montomesextra = limpiar("0.00");
	   $totalvencidas = limpiar("0");
	   $totalpendiente = limpiar("0");
	   $totalpagada = limpiar("0");
	   $totalintereses = limpiar("0.00");
	   $totalpago = limpiar($_POST["txtTotal"]);
		$codmediopago = limpiar(decrypt($_POST['codmediopago']));
	   $codigo = limpiar($_SESSION['codigo']);
	   $fechapago = limpiar(date("Y-m-d"));
	   $stmt->execute();
	   ################ REGISTRO PAGO ###################

	################ AQUI REGISTRAMOS LOS MESES A CANCELAR ###################3
	foreach($mesesactivos as $value)
	{
		$status      = ($value < date('m') ? 3 : "0");
		//$desc      = "0";
		//$cuota     = "0";
		//$mesextra  = "0";
		$comprobante = "0";
		$user = "0";
		foreach($_POST['mespago'] as $valueSelected)
		{
			if($value == $valueSelected)
			{
				$status      = "1";
			   //$desc      = $_POST["descuento"];
			   //$cuota     = $_POST["cuotaunica"];
			   //$mesextra  = $_POST["montomesextra"];
				$comprobante = $numero_pago;
				$fecha       = date("Y-m-d");
				$user        = $_SESSION['codigo'];
		   }
	   }

	   ################ REGISTRAMOS DATOS DE PAGO ###################
	   $query = "INSERT INTO detallespagos  values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $numcomprobante);
		$stmt->bindParam(2, $codest);
		$stmt->bindParam(3, $codturno);
		$stmt->bindParam(4, $codseccion);
		$stmt->bindParam(5, $codperiodo);
		$stmt->bindParam(6, $becado);
		$stmt->bindParam(7, $mespago);
		$stmt->bindParam(8, $montopago);
		$stmt->bindParam(9, $fechapago);
		$stmt->bindParam(10, $statuspago);
	   $stmt->bindParam(11, $codigo);
		
		$numcomprobante = limpiar($comprobante);
		$codest = limpiar($codigoest);
		$codnivel = limpiar(decrypt($_POST["codnivel"]));
		$codturno = limpiar(decrypt($_POST["codturno"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
		$mespago = limpiar($value);
		if (limpiar($codnivel==$codigonivel && $_POST["becado"]=="NO")) { $montopago = limpiar($pagonivel); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="MEDIA")) { $montopago = limpiar($pagonivel/2); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="NO")) { $montopago = limpiar($pagonivel); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="MEDIA")) { $montopago = limpiar($pagonivel/2); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="NO")) { $montopago = limpiar($pagonivel); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="MEDIA")) { $montopago = limpiar($pagonivel/2); }
	   $fechapago = limpiar($status == 1 ? date("Y-m-d") : "0000-00-00");
		$statuspago = limpiar($status);
	   $codigo = limpiar($user);
	   $stmt->execute();
	   ################ REGISTRAMOS DATOS DE PAGO ###################

	   $sql = "SELECT * FROM detallespagos WHERE codperiodo = $codperiodo 
	   AND mespago < ".date('m')." 
	   AND $diasvence < ".date('d')." 
	   AND statuspago = 0";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num == 0)
		{
		   ################## VERIFICA MESES VENCIDOS ##################
			$sql = " UPDATE detallespagos SET "
			   ." statuspago = ? "
			   ." WHERE "
			   ." codperiodo = $codperiodo AND mespago < ".date('m')." AND statuspago = 0;
			    ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $statuspago);
			$statuspago = limpiar("2");
			$stmt->execute();
			################## VERIFICA MESES VENCIDOS ##################

		} else {

			################## VERIFICA MESES VENCIDOS ##################
			$sql = " UPDATE detallespagos SET "
			   ." statuspago = ? "
			   ." WHERE "
			   ." codperiodo = $codperiodo 
			   AND mespago < ".date('m')." 
			   AND $diasvence <= ".date('d')." 
			   AND statuspago = 0;
			   ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $statuspago);
			$statuspago = limpiar("2");
			$stmt->execute();
			################## VERIFICA MESES VENCIDOS ##################
		}

   }// fin de foreach

      ####################### PROCESO COBRO EN CAJA #######################
		$sql = " UPDATE arqueocaja set "
		." ingresos = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtTotal);
		$stmt->bindParam(2, $codarqueo);

	   $txtTotal = number_format($ingresoBD+$_POST["txtTotal"], 2, '.', '');
		$codarqueo = limpiar($codarqueoBD);
		$stmt->execute();

		$query = " INSERT INTO mediospagoxpagos  values (null, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codarqueoBD);
		$stmt->bindParam(2, $codcajaBD);
		$stmt->bindParam(3, $numcomprobante);
		$stmt->bindParam(4, $codmediopago);
		$stmt->bindParam(5, $montopagado);
		$stmt->bindParam(6, $montodevuelto);

		$numcomprobante = limpiar($numero_pago);
		$codmediopago = limpiar(decrypt($_POST['codmediopago']));
		$montopagado = limpiar($_POST["txtTotal"]);
		$montodevuelto = limpiar("0.00");
		$stmt->execute();
	   ####################### PROCESO COBRO EN CAJA #######################

	      echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO INSCRITO EXITOSAMENTE <a href='reportepdf?numcomprobante=".encrypt($numero_pago)."&tipo=".encrypt("COMPROBANTEPAGOS")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Comprobante' target='_black'><strong>IMPRIMIR COMPROBANTE DE PAGO</strong></a>";
         exit;

      } else {

         echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO INSCRITO EXITOSAMENTE";
         exit;

      }	
	}
}  
########################### FUNCION REGISTRAR INSCRIPCIONES ###############################

########################### FUNCION INSCRIBIR ESTUDIANTES ###############################
public function InscribirEstudiantes() 
{
	self::SetNames();
	############# OBTENGO DATOS DE CONFIGURACION #############
	$conf = "SELECT * FROM configuracion";
	foreach ($this->dbh->query($conf) as $rowcon)
	{
		$this->pcon[] = $rowcon;
	}
	$cobrar_cuotas = (empty($rowcon['cobrar_cuotas']) ? 0 : $rowcon['cobrar_cuotas']);
	############# OBTENGO DATOS DE CONFIGURACION #############

	if($cobrar_cuotas == 1){

	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql2 = "SELECT
	cajas.codigo,
	arqueocaja.codarqueo,
	arqueocaja.codcaja,
	arqueocaja.ingresos
	FROM arqueocaja 
   INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
   WHERE cajas.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->execute(array(limpiar($_SESSION["codigo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "1";
	   exit;

	} else {
		
		if($row2 = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p2[] = $row2;
		}
		$codarqueoBD = $row2['codarqueo'];
		$codcajaBD = $row2['codcaja'];
		$ingresoBD = ($row2['ingresos']== "" ? "0.00" : $row2['ingresos']);
	}
   ####################### VERIFICO ARQUEO DE CAJA #######################
   }

	if(empty($_POST["codest"]) or empty($_POST["cedest"]) or empty($_POST["pnomest"]) or empty($_POST["papeest"]))
	{
		echo "2";
		exit;
	}

	################ OBTENGO PERIODO ESCOLAR ACTIVO ################
	$period = "SELECT * FROM periodoescolar WHERE statusperiodo = 1";
	foreach ($this->dbh->query($period) as $rowper)
	{
		$this->pper[] = $rowper;
	}
	$codperiodo = (empty($rowper['codperiodo']) ? "" : $rowper['codperiodo']);
	//$inscripcion = (empty($rowper['montoinscripcion']) ? "" : $rowper['montoinscripcion']);
	//$cuota = (empty($rowper['cuotaunica']) ? "" : $rowper['cuotaunica']);
   $diasvence = (empty($rowper['diasvence']) ? "" : $rowper['diasvence']);
   $mesesactivos = explode(", ",$rowper['mesesactivos']);
   $inicio = reset($mesesactivos); // Primero
   $fin = end($mesesactivos); // Ultimo
	################ OBTENGO PERIODO ESCOLAR ACTIVO ################
	
	################ OBTENGO LOS NIVELES Y detallespagos  ###################
	$niv = "SELECT codnivel, nivel, pagonivel FROM niveles WHERE codnivel = '".decrypt($_POST["codnivel"])."'";
	foreach ($this->dbh->query($niv) as $row3)
	{
		$this->p3[] = $row3;
	}
	$codigonivel = $row3['codnivel'];
	$nivel = $row3['nivel'];
	$pagonivel = $row3['pagonivel'];
	################ OBTENGO LOS NIVELES Y detallespagos  ###################

   if($cobrar_cuotas == 1){

   ################### CREO NUMERO DE COMPROBANTE ####################
	$sql = "SELECT id_contador, contador_numero 
	FROM contador_cuotas ORDER BY id_contador DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$id = $row["id_contador"];
		$contador = $row["contador_numero"];
	}
	if(empty($contador))
	{
		$numero_pago = "01";

		################# REGISTRO CONTADOR #################
		$query = "INSERT INTO contador_cuotas VALUES (null, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1,$contador_numero);

		$contador_numero = limpiar($numero_pago);
		$stmt->execute();
		################# REGISTRO CONTADOR #################

	} else {

		$num = substr($contador, 0);
      $dig = $contador + 1;
      $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
      $numero_pago = $codigofinal;

      ################# ACTUALIZO CONTADOR #################
      $sql = " UPDATE contador_cuotas SET "
		." contador_numero = ? "
		." WHERE "
		." id_contador = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $contador_numero);
		$stmt->bindParam(2, $id_contador);

		$contador_numero = limpiar($numero_pago);
		$id_contador = limpiar($id);
		$stmt->execute();
		################# ACTUALIZO CONTADOR #################
	}
   ################### CREO NUMERO DE COMPROBANTE ####################

   }
	

	################ ACTUALIZAMOS DATOS DEL ESTUDIANTE ###################
   $sql = " UPDATE estudiantes set "
	  ." cedest = ?, "
	  ." pnomest = ?, "
	  ." snomest = ?, "
	  ." papeest = ?, "
	  ." sapeest = ?, "
	  ." sexoest = ?, "
	  ." direcest = ?, "
	  ." fnacest = ?, "
	  ." codturno = ?, "
	  ." codnivel = ?, "
	  ." codgrado = ?, "
	  ." codseccion = ?, "
	  ." codperiodo = ?, "
	  ." becado = ?, "
	  ." observacionest = ?, "
	  ." retiroest = ?, "
	  ." claveest = ?, "
	  ." statusest = ?, "
	  ." fechainscripcion = ? "
	  ." WHERE "
	  ." codest = ?;
	   ";
   $stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $cedest);
	$stmt->bindParam(2, $pnomest);
	$stmt->bindParam(3, $snomest);
	$stmt->bindParam(4, $papeest);
	$stmt->bindParam(5, $sapeest);
	$stmt->bindParam(6, $sexoest);
	$stmt->bindParam(7, $direcest);
	$stmt->bindParam(8, $fnacest);
	$stmt->bindParam(9, $codturno);
	$stmt->bindParam(10, $codnivel);
	$stmt->bindParam(11, $codgrado);
	$stmt->bindParam(12, $codseccion);
	$stmt->bindParam(13, $codperiodo);
	$stmt->bindParam(14, $becado);
	$stmt->bindParam(15, $observacionest);
	$stmt->bindParam(16, $retiroest);
	$stmt->bindParam(17, $claveest);
	$stmt->bindParam(18, $statusest);
	$stmt->bindParam(19, $fechainscripcion);
   $stmt->bindParam(20, $codest);
	
	$cedest = limpiar($_POST["cedest"]);
	$pnomest = limpiar($_POST["pnomest"]);
	$snomest = limpiar($_POST["snomest"]);
	$papeest = limpiar($_POST["papeest"]);
	$sapeest = limpiar($_POST["sapeest"]);
	$sexoest = limpiar($_POST["sexoest"]);
	$direcest = limpiar($_POST["direcest"]);
	$fnacest = limpiar(date("Y-m-d",strtotime($_POST['fnacest'])));
	$codturno = limpiar(decrypt($_POST["codturno"]));
	$codnivel = limpiar(decrypt($_POST["codnivel"]));
	$codgrado = limpiar(decrypt($_POST["codgrado"]));
	$codseccion = limpiar(decrypt($_POST["codseccion"]));
	$becado = limpiar($_POST["becado"]);
	$observacionest = limpiar("0");
	$retiroest = limpiar("0000-00-00");
	$claveest = password_hash($_POST["cedest"], PASSWORD_DEFAULT);
	$statusest = limpiar("1");	
	$fechainscripcion = limpiar(date("Y-m-d"));
	$codest = limpiar(decrypt($_POST["codest"]));
	$stmt->execute();
	################ ACTUALIZAMOS DATOS DEL ESTUDIANTE ###################

	################ ACTUALIZAMOS DATOS DEL TUTOR ###################
   $sql = " UPDATE padres set "
	  ." cedpadre = ?, "
	  ." nompadre = ?, "
	  ." apepadre = ?, "
	  ." tlfpadre = ?, "
	  ." statuspad = ? "
	  ." WHERE "
	  ." codpadre = ?;
	   ";
   $stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $cedpadre);
	$stmt->bindParam(2, $nompadre);
	$stmt->bindParam(3, $apepadre);
	$stmt->bindParam(4, $tlfpadre);
	$stmt->bindParam(5, $statuspad);
	$stmt->bindParam(6, $codpadre);
	
	$cedpadre = limpiar($_POST["cedpadre"]);
	$nompadre = limpiar($_POST["nompadre"]);
	$apepadre = limpiar($_POST["apepadre"]);
	$tlfpadre = limpiar($_POST["tlfpadre"]);
	$statuspad = limpiar("1");
	$codpadre = limpiar(decrypt($_POST["codpadre"]));
   $stmt->execute();
   ################ ACTUALIZAMOS DATOS DEL TUTOR ###################
				
    if($_POST["becado"]=="COMPLETA"){

    	if($cobrar_cuotas == 1){

    	################ REGISTRO PAGO ###################
	   $query = "INSERT INTO pagos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codarqueo);
		$stmt->bindParam(2, $codcaja);
		$stmt->bindParam(3, $numcomprobante);
		$stmt->bindParam(4, $codest);
		$stmt->bindParam(5, $codturno);
		$stmt->bindParam(6, $codnivel);
		$stmt->bindParam(7, $codgrado);
		$stmt->bindParam(8, $codseccion);
		$stmt->bindParam(9, $codperiodo);
		$stmt->bindParam(10, $becado);
		$stmt->bindParam(11, $subtotal);
		$stmt->bindParam(12, $descuento);
		$stmt->bindParam(13, $totaldescuento);
		$stmt->bindParam(14, $montoinscripcion);
		$stmt->bindParam(15, $cuotaunica);
		$stmt->bindParam(16, $montomesextra);
		$stmt->bindParam(17, $totalvencidas);
		$stmt->bindParam(18, $totalpendiente);
		$stmt->bindParam(19, $totalpagada);
		$stmt->bindParam(20, $totalintereses);
		$stmt->bindParam(21, $totalpago);
		$stmt->bindParam(22, $codmediopago);
		$stmt->bindParam(23, $codigo);
		$stmt->bindParam(24, $fechapago);
		
		$codarqueo = limpiar($codarqueoBD);
		$codcaja = limpiar($codcajaBD);
		$numcomprobante = limpiar($numero_pago);
		$codest = limpiar(decrypt($_POST["codest"]));	
		$codturno = limpiar(decrypt($_POST["codturno"]));
	   $codnivel = limpiar(decrypt($_POST["codnivel"]));
	   $codgrado = limpiar(decrypt($_POST["codgrado"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
	   $subtotal = limpiar($_POST["textSubtotal"]);
	   $descuento = limpiar($_POST["descuento"]);
	   $totaldescuento = limpiar($_POST["txtDescuento"]);
	   $montoinscripcion = limpiar($_POST["montoinscripcion"]);
	   $cuotaunica = limpiar($_POST["cuotaunica"]);
	   $montomesextra = limpiar("0.00");
	   $totalvencidas = limpiar("0");
	   $totalpendiente = limpiar("0");
	   $totalpagada = limpiar("0");
	   $totalintereses = limpiar("0.00");
	   $totalpago = limpiar($_POST["txtTotal"]);
		$codmediopago = limpiar(decrypt($_POST['codmediopago']));
	   $codigo = limpiar($_SESSION['codigo']);
	   $fechapago = limpiar(date("Y-m-d"));
	   $stmt->execute();
	   ################ REGISTRO PAGO ###################

	   ################ REGISTRAMOS CUOTA PRIMER MES ###################
	   $query = "INSERT INTO detallespagos  values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $numcomprobante);
		$stmt->bindParam(2, $codest);
		$stmt->bindParam(3, $codturno);
		$stmt->bindParam(4, $codseccion);
		$stmt->bindParam(5, $codperiodo);
		$stmt->bindParam(6, $becado);
		$stmt->bindParam(7, $mespago);
		$stmt->bindParam(8, $montopago);
		$stmt->bindParam(9, $fechapago);
		$stmt->bindParam(10, $statuspago);
	   $stmt->bindParam(11, $codigo);
		
		$numcomprobante = limpiar($numero_pago);
		$codest = limpiar(decrypt($_POST["codest"]));
		$codturno = limpiar(decrypt($_POST["codturno"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
		$mespago = limpiar($inicio);
      $montopago = limpiar($pagonivel);
	   $fechapago = limpiar(date("Y-m-d"));
		$statuspago = limpiar("1");
	   $codigo = limpiar($_SESSION['codigo']);
	   $stmt->execute();
	   ################ REGISTRAMOS CUOTA PRIMER MES ###################

	   ################ REGISTRAMOS CUOTA ULTIMO MES ###################
	   $query = "INSERT INTO detallespagos  values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $numcomprobante);
		$stmt->bindParam(2, $codest);
		$stmt->bindParam(3, $codturno);
		$stmt->bindParam(4, $codseccion);
		$stmt->bindParam(5, $codperiodo);
		$stmt->bindParam(6, $becado);
		$stmt->bindParam(7, $mespago);
		$stmt->bindParam(8, $montopago);
		$stmt->bindParam(9, $fechapago);
		$stmt->bindParam(10, $statuspago);
	   $stmt->bindParam(11, $codigo);
		
		$numcomprobante = limpiar($numero_pago);
		$codest = limpiar(decrypt($_POST["codest"]));
		$codturno = limpiar(decrypt($_POST["codturno"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
		$mespago = limpiar($fin);
      $montopago = limpiar($pagonivel);
	   $fechapago = limpiar(date("Y-m-d"));
		$statuspago = limpiar("1");
	   $codigo = limpiar($_SESSION['codigo']);
	   $stmt->execute();
	   ################ REGISTRAMOS CUOTA ULTIMO MES ###################

	   ####################### PROCESO COBRO EN CAJA #######################
		$sql = " UPDATE arqueocaja set "
		." ingresos = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtTotal);
		$stmt->bindParam(2, $codarqueo);

		$txtTotal = number_format($ingresoBD+$_POST["txtTotal"], 2, '.', '');
		$codarqueo = limpiar($codarqueoBD);
		$stmt->execute();

		$query = " INSERT INTO mediospagoxpagos  values (null, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codarqueoBD);
		$stmt->bindParam(2, $codcajaBD);
		$stmt->bindParam(3, $numcomprobante);
		$stmt->bindParam(4, $codmediopago);
		$stmt->bindParam(5, $montopagado);
		$stmt->bindParam(6, $montodevuelto);

		$numcomprobante = limpiar($numero_pago);
		$codmediopago = limpiar(decrypt($_POST['codmediopago']));
		$montopagado = number_format($_POST["txtTotal"], 2, '.', '');
		$montodevuelto = limpiar("0.00");
		$stmt->execute();
	   ####################### PROCESO COBRO EN CAJA #######################
			  
		   echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO INSCRITO EXITOSAMENTE <a href='reportepdf?numcomprobante=".encrypt($numero_pago)."&tipo=".encrypt("COMPROBANTEPAGOS")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Comprobante' target='_black'><strong>IMPRIMIR COMPROBANTE DE PAGO</strong></a>";
	      exit;

	   } else {

	      echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO INSCRITO EXITOSAMENTE ";
	      exit;
      }
			
	} else {

   if($cobrar_cuotas == 1){

   	################ REGISTRO PAGO ###################
	   $query = "INSERT INTO pagos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codarqueo);
		$stmt->bindParam(2, $codcaja);
		$stmt->bindParam(3, $numcomprobante);
		$stmt->bindParam(4, $codest);
		$stmt->bindParam(5, $codturno);
		$stmt->bindParam(6, $codnivel);
		$stmt->bindParam(7, $codgrado);
		$stmt->bindParam(8, $codseccion);
		$stmt->bindParam(9, $codperiodo);
		$stmt->bindParam(10, $becado);
		$stmt->bindParam(11, $subtotal);
		$stmt->bindParam(12, $descuento);
		$stmt->bindParam(13, $totaldescuento);
		$stmt->bindParam(14, $montoinscripcion);
		$stmt->bindParam(15, $cuotaunica);
		$stmt->bindParam(16, $montomesextra);
		$stmt->bindParam(17, $totalvencidas);
		$stmt->bindParam(18, $totalpendiente);
		$stmt->bindParam(19, $totalpagada);
		$stmt->bindParam(20, $totalintereses);
		$stmt->bindParam(21, $totalpago);
		$stmt->bindParam(22, $codmediopago);
		$stmt->bindParam(23, $codigo);
		$stmt->bindParam(24, $fechapago);
		
		$codarqueo = limpiar($codarqueoBD);
		$codcaja = limpiar($codcajaBD);
		$numcomprobante = limpiar($numero_pago);
		$codest = limpiar(decrypt($_POST["codest"]));	
		$codturno = limpiar(decrypt($_POST["codturno"]));
	   $codnivel = limpiar(decrypt($_POST["codnivel"]));
	   $codgrado = limpiar(decrypt($_POST["codgrado"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
	   $subtotal = limpiar($_POST["textSubtotal"]);
	   $descuento = limpiar($_POST["descuento"]);
	   $totaldescuento = limpiar($_POST["txtDescuento"]);
	   $montoinscripcion = limpiar($_POST["montoinscripcion"]);
	   $cuotaunica = limpiar($_POST["cuotaunica"]);
	   $montomesextra = limpiar("0.00");
	   $totalvencidas = limpiar("0");
	   $totalpendiente = limpiar("0");
	   $totalpagada = limpiar("0");
	   $totalintereses = limpiar("0.00");
	   $totalpago = limpiar($_POST["txtTotal"]);
		$codmediopago = limpiar(decrypt($_POST['codmediopago']));
	   $codigo = limpiar($_SESSION['codigo']);
	   $fechapago = limpiar(date("Y-m-d"));
	   $stmt->execute();
	   ################ REGISTRO PAGO ###################
			
	################ AQUI REGISTRAMOS LOS MESES A CANCELAR ###################3
	foreach($mesesactivos as $value)
	{
		$status      = ($value < date('m') ? 3 : "0");
		//$desc      = "0";
		//$cuota     = "0";
		//$mesextra  = "0";
		$comprobante = "0";
		$user = "0";
		foreach($_POST['mespago'] as $valueSelected)
		{
			if($value == $valueSelected)
			{
				$status      = "1";
			   //$desc      = $_POST["descuento"];
			   //$cuota     = $_POST["cuotaunica"];
			   //$mesextra  = $_POST["montomesextra"];
				$comprobante = $numero_pago;
				$fecha       = date("Y-m-d");
				$user        = $_SESSION['codigo'];
		   }
	   }

	   ################ REGISTRAMOS DATOS DE PAGO ###################
	   $query = "INSERT INTO detallespagos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	   $stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $numcomprobante);
		$stmt->bindParam(2, $codest);
		$stmt->bindParam(3, $codturno);
		$stmt->bindParam(4, $codseccion);
		$stmt->bindParam(5, $codperiodo);
		$stmt->bindParam(6, $becado);
		$stmt->bindParam(7, $mespago);
		$stmt->bindParam(8, $montopago);
		$stmt->bindParam(9, $fechapago);
		$stmt->bindParam(10, $statuspago);
	   $stmt->bindParam(11, $codigo);
		
		$numcomprobante = limpiar($comprobante);
		$codest = limpiar(decrypt($_POST["codest"]));
		$codnivel = limpiar(decrypt($_POST["codnivel"]));
		$codturno = limpiar(decrypt($_POST["codturno"]));
		$codseccion = limpiar(decrypt($_POST["codseccion"]));
		$becado = limpiar($_POST["becado"]);
		$mespago = limpiar($value);
		if (limpiar($codnivel==$codigonivel && $_POST["becado"]=="NO")) { $montopago = limpiar($pagonivel); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="MEDIA")) { $montopago = limpiar($pagonivel/2); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="NO")) { $montopago = limpiar($pagonivel); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="MEDIA")) { $montopago = limpiar($pagonivel/2); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="NO")) { $montopago = limpiar($pagonivel); } 
		elseif (limpiar($codnivel==$codigonivel && $_POST["becado"]=="MEDIA")) { $montopago = limpiar($pagonivel/2); }
	   $fechapago = limpiar($status == 1 ? date("Y-m-d") : "0000-00-00");
		$statuspago = limpiar($status);
	   $codigo = limpiar($user);
	   $stmt->execute();
	   ################ REGISTRAMOS DATOS DE PAGO ###################

	   ################## VERIFICA MESES VENCIDOS ##################
	   $sql = "SELECT * FROM detallespagos WHERE codperiodo = $codperiodo 
	   AND mespago < ".date('m')." 
	   AND $diasvence < ".date('d')." 
	   AND statuspago = 0";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num == 0)
		{
		   ################## ACTUALIZO MESES VENCIDOS ##################
			$sql = " UPDATE detallespagos SET "
			   ." statuspago = ? "
			   ." WHERE "
			   ." codperiodo = $codperiodo AND mespago < ".date('m')." AND statuspago = 0;
			    ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $statuspago);
			$statuspago = limpiar("2");
			$stmt->execute();
			################## ACTUALIZO MESES VENCIDOS ##################

		} else {

			################## ACTUALIZO MESES CON DIA VENCIDOS ##################
			$sql = " UPDATE detallespagos SET "
			   ." statuspago = ? "
			   ." WHERE "
			   ." codperiodo = $codperiodo 
			   AND mespago < ".date('m')." 
			   AND $diasvence <= ".date('d')." 
			   AND statuspago = 0;
			   ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $statuspago);
			$statuspago = limpiar("2");
			$stmt->execute();
			################## ACTUALIZO MESES CON DIA VENCIDOS ##################
		}
		################## VERIFICA MESES VENCIDOS ##################

   }// fin de foreach

      ####################### PROCESO COBRO EN CAJA #######################
		$sql = " UPDATE arqueocaja set "
		." ingresos = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtTotal);
		$stmt->bindParam(2, $codarqueo);

	   $txtTotal = number_format($ingresoBD+$_POST["txtTotal"], 2, '.', '');
		$codarqueo = limpiar($codarqueoBD);
		$stmt->execute();

		$query = " INSERT INTO mediospagoxpagos  values (null, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codarqueoBD);
		$stmt->bindParam(2, $codcajaBD);
		$stmt->bindParam(3, $numcomprobante);
		$stmt->bindParam(4, $codmediopago);
		$stmt->bindParam(5, $montopagado);
		$stmt->bindParam(6, $montodevuelto);

		$numcomprobante = limpiar($numero_pago);
		$codmediopago = limpiar(decrypt($_POST['codmediopago']));
		$montopagado = limpiar($_POST["txtTotal"]);
		$montodevuelto = limpiar("0.00");
		$stmt->execute();
	   ####################### PROCESO COBRO EN CAJA #######################

	      echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO INSCRITO EXITOSAMENTE <a href='reportepdf?numcomprobante=".encrypt($numero_pago)."&tipo=".encrypt("COMPROBANTEPAGOS")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Comprobante' target='_black'><strong>IMPRIMIR COMPROBANTE DE PAGO</strong></a>";
         exit;

      } else {

      	echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO INSCRITO EXITOSAMENTE";
         exit;
      }	
	}
}  
########################### FUNCION INSCRIBIR ESTUDIANTES ###############################

########################### FUNCION LISTAR ESTUDIANTES ################################
public function ListarEstudiantes()
{
	self::SetNames();
	$sql = "SELECT * FROM estudiantes 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo 
	WHERE estudiantes.codturno = ? 
	AND estudiantes.codseccion = ? 
	AND estudiantes.statusest = 1 
	ORDER BY estudiantes.papeest";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codseccion'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
    echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
    echo "</div>";		
	exit;
	}
	else
	{
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$this->p[]=$row;
	}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION LISTAR ESTUDIANTES ################################

########################### FUNCION LISTAR ESTUDIANTES EN GENERAL ################################
public function ListadoGeneral()
{
	self::SetNames();
	$sql = "SELECT * FROM estudiantes 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
	ORDER BY nivel DESC, grado ASC, papeest ASC, seccion ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
########################### FUNCION LISTAR ESTUDIANTES EN GENERAL ################################

########################### FUNCION ID ESTUDIANTES ################################
public function EstudiantesPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM (estudiantes INNER JOIN padres ON estudiantes.codpadre = padres.codpadre) 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
	WHERE estudiantes.codest = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codest"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################### FUNCION ID ESTUDIANTES ################################

############################## FUNCION ACTUALIZAR ESTUDIANTES ##############################
public function ActualizarEstudiante()
{
	self::SetNames();
	if(empty($_POST["codest"]) or empty($_POST["cedest"]) or empty($_POST["pnomest"]) or empty($_POST["papeest"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT * FROM estudiantes WHERE codest != ? and cedest = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codest"]), $_POST["cedest"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	   ################ AQUI ACTUALIZAMOS LOS DATOS DEL ESTUDIANTE ###################3
      $sql = " UPDATE estudiantes set "
		  ." cedest = ?, "
		  ." pnomest = ?, "
		  ." snomest = ?, "
		  ." papeest = ?, "
		  ." sapeest = ?, "
		  ." sexoest = ?, "
		  ." direcest = ?, "
		  ." fnacest = ? "
		  ." WHERE "
		  ." codest = ?;
		   ";
	   $stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $cedest);
		$stmt->bindParam(2, $pnomest);
		$stmt->bindParam(3, $snomest);
		$stmt->bindParam(4, $papeest);
		$stmt->bindParam(5, $sapeest);
		$stmt->bindParam(6, $sexoest);
		$stmt->bindParam(7, $direcest);
		$stmt->bindParam(8, $fnacest);
	   $stmt->bindParam(9, $codest);
		
		$codest = limpiar(decrypt($_POST["codest"]));
		$cedest = limpiar($_POST["cedest"]);
		$pnomest = limpiar($_POST["pnomest"]);
		$snomest = limpiar($_POST["snomest"]);
		$papeest = limpiar($_POST["papeest"]);
		$sapeest = limpiar($_POST["sapeest"]);
		$sexoest = limpiar($_POST["sexoest"]);
		$direcest = limpiar($_POST["direcest"]);
		$fnacest = limpiar(date("Y-m-d",strtotime($_POST['fnacest'])));
		$stmt->execute();	

		echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
############################## FUNCION ACTUALIZAR ESTUDIANTES ##############################

############################## FUNCION RETIRAR ESTUDIANTES ##############################
public function RetiroEstudiante()
{
	self::SetNames();
	if(empty($_POST["codest"]) or empty($_POST["observacionest"]) or empty($_POST["fecharetiro"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT * FROM estudiantes WHERE codest = ? AND statusest = 0";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codest"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	   ################ RETIRAMOS AL ESTUDIANTE ###################
      $sql = " UPDATE estudiantes set "
		  ." observacionest = ?, "
		  ." retiroest = ?, "
		  ." statusest = ? "
		  ." WHERE "
		  ." codest = ?;
		   ";
	   $stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $observacionest);
		$stmt->bindParam(2, $retiroest);
		$stmt->bindParam(3, $statusest);
	   $stmt->bindParam(4, $codest);
		
		$observacionest = limpiar($_POST["observacionest"]);
		$retiroest = limpiar(date("Y-m-d",strtotime($_POST['fecharetiro'])));
		$statusest = limpiar("0");	
		$codest = limpiar(decrypt($_POST["codest"]));		
		$stmt->execute();
		################ RETIRAMOS AL ESTUDIANTE ###################

		################ DESACTIVAMOS detallespagos  ###################
		$sql = " UPDATE detallespagos  set "
		  ." statuspago = ? "
		  ." WHERE "
		  ." codest = ? AND codperiodo = ? AND statuspago = 0;
		   ";
	   $stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $statuspago);
	   $stmt->bindParam(2, $codest);
		$stmt->bindParam(3, $codperiodo);
	
		$statuspago = limpiar("3");
		$codest = limpiar(decrypt($_POST["codest"]));
		$codperiodo = limpiar(decrypt($_POST["codperiodo"]));
	   $stmt->execute();	
	   ################ DESACTIVAMOS detallespagos  ###################

	   ################ VERIFICO SI TUTOR TIENE MAS REPRESENTADOS ###################
	   $sql = "SELECT * FROM estudiantes WHERE codpadre = ? AND statusest = 1";
	   $stmt = $this->dbh->prepare($sql);
	   $stmt->execute(array(decrypt($_POST["codpadre"])));
	   $num = $stmt->rowCount();
	   if($num == 0)
	   {
	   	################ DESACTIVO AL TUTOR ###################
	      $sql = " UPDATE padres set "
			  ." statuspad = ? "
			  ." WHERE "
			  ." codpadre = ?;
			   ";
		   $stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $statuspad);
		   $stmt->bindParam(2, $codpadre);
			
			$statuspad = limpiar("0");	
			$codpadre = limpiar(decrypt($_POST["codpadre"]));		
			$stmt->execute();
			################ DESACTIVO AL TUTOR ###################
	   }
	   ################ VERIFICO SI TUTOR TIENE MAS REPRESENTADOS ###################

      echo "<span class='fa fa-check-square-o'></span> EL ESTUDIANTE HA SIDO RETIRADO EXITOSAMENTE DE LA INSTITUCION, Y SUS CUOTAS DE detallespagos  PENDIENTES SE HAN DESACTIVADO";
      exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
############################## FUNCION RETIRAR ESTUDIANTES ##############################

################################## FUNCION REINICIAR CLAVE ESTUDIANTES ###################################
public function ReiniciarEstudiante()
{
	self::SetNames();
	$sql = " UPDATE estudiantes set "
		  ." claveest = ? "
		  ." WHERE "
		  ." codest = ?;
		   ";
	$stmt = $this->dbh->prepare($sql);
	
	$stmt->bindParam(1, $claveest);
	$stmt->bindParam(2,$codest);
	
	$cedest = limpiar(decrypt($_GET['cedest']));
	$claveest = password_hash($cedest, PASSWORD_DEFAULT);
	$codest = limpiar(decrypt($_GET['codest']));
	$stmt->execute();

	echo "1";
	exit;
}
################################## FUNCION REINICIAR CLAVE ESTUDIANTES ###################################

########################## FUNCION ELIMINAR ESTUDIANTES #########################
public function EliminarEstudiantes()
{
	if($_SESSION['acceso'] == "administrador") {
	
	$sql = "SELECT * FROM estudiantes WHERE codpadre = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codpadre"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{
		$sql = "DELETE FROM estudiantes WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();
		
		$sql = "DELETE FROM notas WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();
		
		$sql = "DELETE FROM detallespagos  WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();
		
		$sql = "DELETE FROM pagospormora WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();
		
		$sql = "DELETE FROM pagosextras WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();

		echo "1";
		exit;
	   
	}  else {
		
		$sql = "DELETE FROM padres WHERE codpadre = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codpadre);
		$codpadre = decrypt($_GET["codpadre"]);
		$stmt->execute();
	
		$sql = "DELETE FROM estudiantes WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();
		
		$sql = "DELETE FROM notas WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();
		
		$sql = "DELETE FROM detallespagos  WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();
		
		$sql = "DELETE FROM pagospormora WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();
		
		$sql = "DELETE FROM pagosextras WHERE codest = ? ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codest);
		$codest = decrypt($_GET["codest"]);
		$stmt->execute();
	
	   echo "1";
	   exit;
	}
	}
	else
	{
	   echo "2";
	   exit;
	}
} 
########################## FUNCION ELIMINAR ESTUDIANTES #########################

######################### FUNCION BUSQUEDA ESTUDIANTES POR CURSOS #############################
public function BuscarEstudiantesxCursos() 
{
	self::SetNames();

	if ($_SESSION['acceso'] == "docente") {

		$sql = "SELECT * FROM asignaciones 
		INNER JOIN periodoescolar ON asignaciones.codperiodo = periodoescolar.codperiodo
		WHERE asignaciones.coddoc = ? 
		AND asignaciones.codturno = ? 
		AND asignaciones.codseccion = ? 
		AND periodoescolar.statusperiodo = 1";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindValue(1, trim($_SESSION['coddoc']));
		$stmt->bindValue(2, trim(decrypt($_GET['codturno'])));
		$stmt->bindValue(3, trim(decrypt($_GET['codseccion'])));
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "<div class='alert alert-danger'>";
			echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		   echo "<center><span class='fa fa-info-circle'></span> ESTA SECCI&Oacute;N NO SE ENCUENTRA ASIGNADA A ESTE DOCENTE, VERIFIQUE NUEVAMENTE POR FAVOR</center>";
		   echo "</div>";		
			exit;
		} 
	} 

	$sql = "SELECT * FROM estudiantes 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
	WHERE estudiantes.codturno = ? 
	AND estudiantes.codseccion = ? 
	AND estudiantes.statusest = 1 
	ORDER BY estudiantes.papeest";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codseccion'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
	   echo "</div>";		
		exit;
	}
	else
	{
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################### FUNCION BUSQUEDA ESTUDIANTES POR CURSOS #############################

######################################## FIN DE CLASE ESTUDIANTES ####################################















######################################## CLASE TUTORES #########################################

################################# FUNCION LISTAR TUTORES ################################
public function ListarTutores()
{
	self::SetNames();
	$sql = "SELECT * FROM padres ORDER BY apepadre";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}	
################################# FUNCION LISTAR TUTORES ################################

################################# FUNCION ID TUTORES #1 ###############################
public function TutorPorIdMuestra()
{
	self::SetNames();
	$sql = "SELECT * FROM (estudiantes INNER JOIN padres ON estudiantes.codpadre = padres.codpadre) 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
	WHERE padres.codpadre = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codpadre"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
################################# FUNCION ID TUTORES ################################

############################# FUNCION ID TUTORES #2 #################################
public function TutorPorId()
{
	self::SetNames();
	$sql = "SELECT * FROM estudiantes 
	INNER JOIN padres ON estudiantes.codpadre = padres.codpadre 
	WHERE padres.codpadre = ?";		
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codpadre"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
############################# FUNCION ID TUTORES #2 #################################

############################ FUNCION ACTUALIZAR TUTORES #############################
public function ActualizarTutor()
{
	self::SetNames();
	if(empty($_POST["cedulapadre"]) or empty($_POST["nompadre"]) or empty($_POST["apepadre"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT cedpadre FROM padres WHERE codpadre != ? AND cedpadre = ? ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codpadre"]), $_POST["cedulapadre"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		################## ACTUALIZAMOS DATOS DEL TUTOR ##################
	   $sql = " UPDATE padres set "
		." cedpadre = ?, "
		." nompadre = ?, "
		." apepadre = ?, "
		." tlfpadre = ? "
		." WHERE "
		." codpadre = ?;
		";
	   $stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $cedpadre);
		$stmt->bindParam(2, $nompadre);
		$stmt->bindParam(3, $apepadre);
		$stmt->bindParam(4, $tlfpadre);
		$stmt->bindParam(5, $codpadre);
		
		$cedpadre = limpiar($_POST["cedulapadre"]);
		$nompadre = limpiar($_POST["nompadre"]);
		$apepadre = limpiar($_POST["apepadre"]);
		$tlfpadre = limpiar($_POST["tlfpadre"]);
		$codpadre = limpiar(decrypt($_POST["codpadre"]));
	   $stmt->execute();
	   ################## ACTUALIZAMOS DATOS DEL TUTOR ##################
	
      echo "<span class='fa fa-check-square-o'></span> EL PADRE/TUTOR HA SIDO ACTUALIZADO EXITOSAMENTE";
      exit;
	}
	else
	{
		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR TUTORES #############################

###################### FUNCION BUSQUEDA TUTORES POR CURSOS ###########################
public function BuscarTutoresxCursos() 
{
	self::SetNames();
	if ($_SESSION['acceso'] == "docente") {

		$sql = "SELECT * FROM asignaciones 
		INNER JOIN periodoescolar ON asignaciones.codperiodo = periodoescolar.codperiodo
		WHERE asignaciones.coddoc = ? 
		AND asignaciones.codturno = ? 
		AND asignaciones.codseccion = ? 
		AND periodoescolar.statusperiodo = 1";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindValue(1, trim($_SESSION['coddoc']));
		$stmt->bindValue(2, trim(decrypt($_GET['codturno'])));
		$stmt->bindValue(3, trim(decrypt($_GET['codseccion'])));
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "<div class='alert alert-danger'>";
			echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		   echo "<center><span class='fa fa-info-circle'></span> ESTA SECCI&Oacute;N NO SE ENCUENTRA ASIGNADA A ESTE DOCENTE, VERIFIQUE NUEVAMENTE POR FAVOR</center>";
		   echo "</div>";		
			exit;
		} 
   }

	$sql = "SELECT
	padres.codpadre,
	padres.cedpadre,
	padres.nompadre,
	padres.apepadre,
	padres.tlfpadre,
	padres.statuspad,
	turnos.turno,
	secciones.seccion,
	grados.grado,
	niveles.nivel,
	niveles.pagonivel,
	periodoescolar.periodo,
	periodoescolar.descripcion,
	GROUP_CONCAT('Nº DOC: ', estudiantes.cedest, ' | NOMBRES: ', estudiantes.pnomest, ' ', estudiantes.snomest, ' ', estudiantes.papeest, ' ', estudiantes.sapeest, ' | BECADO: ', estudiantes.becado SEPARATOR '<br>') AS detalles_alumnos
	FROM (estudiantes INNER JOIN padres ON estudiantes.codpadre = padres.codpadre)
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
	WHERE estudiantes.codturno = ? 
	AND estudiantes.codseccion = ?
	AND estudiantes.statusest = 1
	GROUP BY padres.codpadre 
	ORDER BY padres.apepadre";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codseccion'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
	   echo "</div>";		
		exit;
	}
	else
	{
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
###################### FUNCION BUSQUEDA TUTORES POR CURSOS ###########################

###################################### FIN DE CLASE TUTORES ######################################



























################################### CLASE PAGOS DE ESTUDIANTES ######################################

############################## FUNCION MOSTRAR PAGOS DE ESTUDIANTES ###########################
public function BuscarPagosEstudiantes()
{
	self::SetNames();
	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT
	cajas.codigo,
	arqueocaja.codarqueo,
	arqueocaja.codcaja,
	arqueocaja.ingresos
	FROM arqueocaja 
   INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
   WHERE cajas.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_SESSION["codigo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
	   echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> POR FAVOR, DEBE DE REALIZAR EL ARQUEO DE CAJA PARA PROCESAR INSCRIPCIONES Y COBROS DE CUOTAS</center>";
	   echo "</div>";
	   exit;
	}
   ####################### VERIFICO ARQUEO DE CAJA #######################

	//(Select sum(detallespagos  extra) FROM pagosextra WHERE nrorecibo =?) as sumPagosExtra
	$sql ="SELECT
   est.codpadre,
   est.codest id,
   est.cedest cedula,
   est.pnomest pNombre,
   est.snomest sNombre,
   est.papeest pApellido,
   est.sapeest sApellido,
   est.fnacest,
   est.fechainscripcion,
   padres.cedpadre,
   padres.nompadre,
   padres.apepadre,
   padres.tlfpadre,
   pagos.codturno,
   pagos.codnivel,
   pagos.codgrado, 
   pagos.codseccion,
   pagos.becado,  
   pagos.codperiodo,
   pagos.subtotal,
   pagos.descuento,
   pagos.totaldescuento,
   pagos.cuotaunica,
   pagos.montomesextra,
   pagos.totalvencidas, 
   pagos.totalpendiente,
   pagos.totalpagada,
   pagos.totalintereses,
   pagos.totalpago,
   pagos.fechapago, 
   detallespagos.montopago,
   periodoescolar.periodo, 
   periodoescolar.mesesactivos,
   periodoescolar.interesmora,
   periodoescolar.diasvence,
   turnos.turno,
   niveles.nivel, 
   grados.grado, 
   secciones.seccion, 
   pag.mesespag,
   pag.totalpagad,
   pag2.mesespag2,
   pag2.totalpagad2,
   venc.mesesvenc,
   venc.totalvenc,
   inact.mesesinact,
   inact.totalinact
   FROM
   estudiantes est

   LEFT JOIN
      (SELECT
      codest, COUNT(mespago) AS totalpagad, 
      CASE WHEN statuspago = 1 THEN GROUP_CONCAT(DISTINCT mespago SEPARATOR ', ') END mesespag
      FROM detallespagos  
      WHERE statuspago = 1 AND codperiodo = ".limpiar(decrypt($_GET['codperiodo']))."
      GROUP BY codest ) pag ON pag.codest = est.codest  

   LEFT JOIN
      (SELECT
      codest, COUNT(mespago) AS totalpagad2,
      CASE WHEN statuspago = 3 THEN GROUP_CONCAT(DISTINCT mespago SEPARATOR ', ') END mesespag2
      FROM detallespagos
      WHERE statuspago = 3 AND codperiodo = ".limpiar(decrypt($_GET['codperiodo']))."
      GROUP BY codest ) pag2 ON pag2.codest = est.codest

   LEFT JOIN
      (SELECT
      codest, COUNT(mespago) AS totalvenc,
      CASE WHEN statuspago = 2 THEN GROUP_CONCAT(DISTINCT mespago SEPARATOR ', ') END mesesvenc
      FROM detallespagos
      WHERE statuspago = 2 AND codperiodo = ".limpiar(decrypt($_GET['codperiodo']))."
      GROUP BY codest ) venc ON venc.codest = est.codest

   LEFT JOIN
      (SELECT
      codest, COUNT(mespago) AS totalinact,
      CASE WHEN statuspago = 3 THEN GROUP_CONCAT(DISTINCT mespago SEPARATOR ', ') END mesesinact
      FROM detallespagos
      WHERE statuspago = 3 AND codperiodo = ".limpiar(decrypt($_GET['codperiodo']))."
      GROUP BY codest ) inact ON inact.codest = est.codest
     
	LEFT JOIN padres ON padres.codpadre = est.codpadre 
	LEFT JOIN pagos  ON est.codest = pagos.codest
	LEFT JOIN detallespagos  ON est.codest = detallespagos.codest
	LEFT JOIN turnos ON turnos.codturno = pagos.codturno
   LEFT JOIN secciones ON secciones.codseccion = pagos.codseccion 
   LEFT JOIN grados ON grados.codgrado = secciones.codgrado 
   LEFT JOIN niveles ON secciones.codnivel = niveles.codnivel		  
   LEFT JOIN periodoescolar ON periodoescolar.codperiodo = pagos.codperiodo 
	WHERE est.codest = ? 
	AND pagos.codperiodo = ? 
	GROUP BY id";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_GET['codest']));
	$stmt->bindValue(2, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
	   echo "</div>";		
		exit;
   } 
   else 
   {
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
	   return $this->p;
	   $this->dbh=null;
   }
}
############################## FUNCION MOSTRAR PAGOS DE ESTUDIANTES ###########################

######################## FUNCION REGISTRAR PAGOS DE ESTUDIANTES #######################
public function RegistrarPagos() 
{
	self::SetNames();
	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql2 = "SELECT
	cajas.codigo,
	arqueocaja.codarqueo,
	arqueocaja.codcaja,
	arqueocaja.ingresos
	FROM arqueocaja 
   INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
   WHERE cajas.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->execute(array(limpiar($_SESSION["codigo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "1";
	   exit;

	} else {
		
		if($row2 = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p2[] = $row2;
		}
		$codarqueoBD = $row2['codarqueo'];
		$codcajaBD = $row2['codcaja'];
		$ingresoBD = ($row2['ingresos']== "" ? "0.00" : $row2['ingresos']);
	}
   ####################### VERIFICO ARQUEO DE CAJA #######################

	if(empty($_POST["codest"]) or empty($_POST["codperiodo"]))
	{
		echo "2";
		exit;
	}
	################### CREO NUMERO DE COMPROBANTE ####################
	$sql = "SELECT id_contador, contador_numero 
	FROM contador_cuotas
	ORDER BY id_contador DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$id = $row["id_contador"];
		$contador = $row["contador_numero"];
	}
	if(empty($contador))
	{
		$numero_pago = "01";

		################# REGISTRO CONTADOR #################
		$query = "INSERT INTO contador_cuotas VALUES (null, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1,$contador_numero);

		$contador_numero = limpiar($numero_pago);
		$stmt->execute();
		################# REGISTRO CONTADOR #################

	} else {

		$num = substr($contador, 0);
      $dig = $contador + 1;
      $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
      $numero_pago = $codigofinal;

      ################# ACTUALIZO CONTADOR #################
      $sql = " UPDATE contador_cuotas SET "
		." contador_numero = ? "
		." WHERE "
		." id_contador = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $contador_numero);
		$stmt->bindParam(2, $id_contador);

		$contador_numero = limpiar($numero_pago);
		$id_contador = limpiar($id);
		$stmt->execute();
		################# ACTUALIZO CONTADOR #################
	}
   ################### CREO NUMERO DE COMPROBANTE ####################

   ################ AQUI ACTUALIZAMOS LOS MESES A CANCELAR ###################3
   for($i=0;$i<count($_POST['mespago']);$i++){  //recorro el array
	   if (!empty($_POST['mespago'][$i])) {
	
		################ ACTUALIZO DATOS DE PAGO ###################
		$sql = " UPDATE detallespagos  set "
		  ." numcomprobante = ?, "
		  ." statuspago = ?, "
		  ." fechapago = ?, "
		  ." codigo = ? "
		  ." WHERE "
		  ." codest = ? AND mespago = ? AND codperiodo = ?;
		   ";
	   $stmt = $this->dbh->prepare($sql);
	   $stmt->bindParam(1, $numcomprobante);
		$stmt->bindParam(2, $statuspago);
		$stmt->bindParam(3, $fechapago);
		$stmt->bindParam(4, $codigo);
	   $stmt->bindParam(5, $codest);
		$stmt->bindParam(6, $mespago);
		$stmt->bindParam(7, $codperiodo);

		$numcomprobante = limpiar($numero_pago);
		$statuspago = limpiar("1");
	   $fechapago = limpiar(date("Y-m-d"));
	   $codigo = limpiar($_SESSION['codigo']);
		$codest = limpiar($_POST["codest"]);
		$mespago = limpiar($_POST["mespago"][$i]);
		$codperiodo = limpiar(decrypt($_POST['codperiodo']));
		$diasvence = limpiar($_POST['diasvence']);
	   $stmt->execute();
	   ################ ACTUALIZO DATOS DE PAGO ###################

	   ################## VERIFICA MESES VENCIDOS ##################
	   $sql = "SELECT * FROM detallespagos WHERE codperiodo = $codperiodo 
	   AND mespago < ".date('m')." 
	   AND $diasvence < ".date('d')." 
	   AND statuspago = 0";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num == 0)
		{
		   ################## ACTUALIZO MESES VENCIDOS ##################
			$sql = " UPDATE detallespagos SET "
			   ." statuspago = ? "
			   ." WHERE "
			   ." codperiodo = $codperiodo AND mespago < ".date('m')." AND statuspago = 0;
			    ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $statuspago);
			$statuspago = limpiar("2");
			$stmt->execute();
			################## ACTUALIZO MESES VENCIDOS ##################

		} else {

			################## ACTUALIZO MESES CON DIAS VENCIDOS ##################
			$sql = " UPDATE detallespagos SET "
			   ." statuspago = ? "
			   ." WHERE "
			   ." codperiodo = $codperiodo 
			   AND mespago < ".date('m')." 
			   AND $diasvence < ".date('d')." 
			   AND statuspago = 0;
			   ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $statuspago);
			$statuspago = limpiar("2");
			$stmt->execute();
			################## ACTUALIZO MESES CON DIAS VENCIDOS ##################
		}
		################## VERIFICA MESES VENCIDOS ##################

      }
   }

   ################ REGISTRO PAGO ###################
   $query = "INSERT INTO pagos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
   $stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codarqueo);
	$stmt->bindParam(2, $codcaja);
	$stmt->bindParam(3, $numcomprobante);
	$stmt->bindParam(4, $codest);
	$stmt->bindParam(5, $codturno);
	$stmt->bindParam(6, $codnivel);
	$stmt->bindParam(7, $codgrado);
	$stmt->bindParam(8, $codseccion);
	$stmt->bindParam(9, $codperiodo);
	$stmt->bindParam(10, $becado);
	$stmt->bindParam(11, $subtotal);
	$stmt->bindParam(12, $descuento);
	$stmt->bindParam(13, $totaldescuento);
	$stmt->bindParam(14, $montoinscripcion);
	$stmt->bindParam(15, $cuotaunica);
	$stmt->bindParam(16, $montomesextra);
	$stmt->bindParam(17, $totalvencidas);
	$stmt->bindParam(18, $totalpendiente);
	$stmt->bindParam(19, $totalpagada);
	$stmt->bindParam(20, $totalinteres);
	$stmt->bindParam(21, $totalpago);
	$stmt->bindParam(22, $codmediopago);
	$stmt->bindParam(23, $codigo);
	$stmt->bindParam(24, $fechapago);
	
	$codarqueo = limpiar($codarqueoBD);
	$codcaja = limpiar($codcajaBD);
	$numcomprobante = limpiar($numero_pago);
	$codest = limpiar($_POST["codest"]);	
	$codturno = limpiar(decrypt($_POST["codturno"]));
	$codnivel = limpiar(decrypt($_POST["codnivel"]));
	$codgrado = limpiar(decrypt($_POST["codgrado"]));
	$codseccion = limpiar(decrypt($_POST["codseccion"]));
	$codperiodo = limpiar(decrypt($_POST['codperiodo']));
	$becado = limpiar($_POST["becado"]);
   $subtotal = limpiar($_POST["textSubtotal"]);
   $descuento = limpiar($_POST["descuento"]);
   $totaldescuento = limpiar($_POST["txtDescuento"]);
   $montoinscripcion = limpiar($_POST["montoinscripcion"]);
   $cuotaunica = limpiar($_POST["cuotaunica"]);
   $montomesextra = limpiar("0.00");
   $totalvencidas = ($_POST['totalvencidos']);
   if($_POST['totalvencidos'] > $_POST['totalpagados']){
   $totalpendiente = ($_POST['totalvencidos']-$_POST['totalpagados']);
   } elseif($_POST['totalpagados'] >= $_POST['totalvencidos']) {
   $totalpendiente = ("0");
   }
   if($_POST['totalpagados'] >= $_POST['totalvencidos']){
   $totalpagada = ($_POST['totalvencidos']);
   } elseif($_POST['totalpagados'] < $_POST['totalvencidos']){
   $totalpagada = ($_POST['totalpagados']);
   } else {
   $totalpagada = limpiar("0");
   }

	$totalinteres = limpiar($_POST["txtIntereses"]);
   $totalpago = limpiar($_POST["txtTotal"]);
	$codmediopago = limpiar(decrypt($_POST['codmediopago']));
	$codigo = limpiar($_SESSION['codigo']);
   $fechapago = limpiar(date("Y-m-d"));
   $stmt->execute();
   ################ REGISTRO PAGO ###################

   ####################### PROCESO COBRO EN CAJA #######################
	$sql = " UPDATE arqueocaja set "
	." ingresos = ? "
	." WHERE "
	." codarqueo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $txtTotal);
	$stmt->bindParam(2, $codarqueo);

	$txtTotal = number_format($ingresoBD+$_POST["txtTotal"], 2, '.', '');
	$codarqueo = limpiar($codarqueoBD);
	$stmt->execute();

	$query = " INSERT INTO mediospagoxpagos  values (null, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codarqueoBD);
	$stmt->bindParam(2, $codcajaBD);
	$stmt->bindParam(3, $numcomprobante);
	$stmt->bindParam(4, $codmediopago);
	$stmt->bindParam(5, $montopagado);
	$stmt->bindParam(6, $montodevuelto);

	$numcomprobante = limpiar($numero_pago);
	$codmediopago = limpiar(decrypt($_POST['codmediopago']));
	$montopagado = number_format($_POST["txtTotal"], 2, '.', '');
	$montodevuelto = limpiar("0.00");
	$stmt->execute();
   ####################### PROCESO COBRO EN CAJA #######################

	echo "<span class='fa fa-check-square-o'></span> EL PAGO HA SIDO REALIZADO EXITOSAMENTE <a href='reportepdf?numcomprobante=".encrypt($numero_pago)."&tipo=".encrypt("COMPROBANTEPAGOS")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Comprobante' target='_black'><strong>IMPRIMIR COMPROBANTE DE PAGO</strong></a>";
	exit;
}  
######################## FUNCION REGISTRAR PAGOS DE ESTUDIANTES #######################

####################### FUNCION LISTAR PAGOS DE ESTUDIANTES ###########################
public function BuscarPagosxEstudiantes() 
{
	self::SetNames();
	$sql = "SELECT
	pagos.*,
   estudiantes.codpadre,
   estudiantes.codest, 
	estudiantes.cedest,
	estudiantes.pnomest,
	estudiantes.snomest,
	estudiantes.papeest,
	estudiantes.sapeest,
	estudiantes.sexoest,
	estudiantes.direcest,
	estudiantes.fnacest,
	padres.cedpadre,
	padres.nompadre,
	padres.apepadre,
	padres.tlfpadre,
	padres.statuspad,
	turnos.turno,
	secciones.seccion,
	grados.grado,
	niveles.nivel,
	niveles.pagonivel,
	periodoescolar.periodo,
	periodoescolar.descripcion,
	detallespagos.coddetalle,
	detallespagos.montopago,
	detallespagos.fechapago,
	detallespagos.statuspago,
	GROUP_CONCAT(detallespagos.mespago SEPARATOR ', ') AS detalles_meses
	FROM (detallespagos INNER JOIN estudiantes ON detallespagos.codest = estudiantes.codest) 
	LEFT JOIN pagos ON detallespagos.numcomprobante = pagos.numcomprobante
	LEFT JOIN padres ON estudiantes.codpadre = padres.codpadre 
	LEFT JOIN turnos ON pagos.codturno = turnos.codturno 
	LEFT JOIN secciones ON pagos.codseccion = secciones.codseccion 
	LEFT JOIN grados ON secciones.codgrado = grados.codgrado 
	LEFT JOIN niveles ON secciones.codnivel = niveles.codnivel 
	LEFT JOIN periodoescolar ON pagos.codperiodo = periodoescolar.codperiodo
	WHERE detallespagos.codest = ? 
	AND detallespagos.codperiodo = ?
	AND detallespagos.statuspago != 3
	GROUP BY detallespagos.numcomprobante, detallespagos.statuspago 
	ORDER BY detallespagos.mespago ASC ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_GET['codest']));
	$stmt->bindValue(2, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	   echo "<div class='alert alert-danger'>";
	   echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
      echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
      echo "</div>";		
	   exit;
	}
	else
	{
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}	
####################### FUNCION LISTAR PAGOS DE ESTUDIANTES ###########################

######################## FUNCION ID PAGOS DE ESTUDIANTES ###########################
public function PagosPorId()
{
	self::SetNames();
	$sql = "SELECT
	pagos.*,
   estudiantes.codpadre,
   estudiantes.codest, 
	estudiantes.cedest,
	estudiantes.pnomest,
	estudiantes.snomest,
	estudiantes.papeest,
	estudiantes.sapeest,
	estudiantes.sexoest,
	estudiantes.direcest,
	estudiantes.fnacest,
	padres.cedpadre,
	padres.nompadre,
	padres.apepadre,
	padres.tlfpadre,
	padres.statuspad,
	turnos.turno,
	secciones.seccion,
	grados.grado,
	niveles.nivel,
	niveles.pagonivel,
	periodoescolar.periodo,
	periodoescolar.descripcion,
	cajas.nrocaja,
	cajas.nombrecaja,
   usuarios.cedula,
   usuarios.nombres,
	detallespagos.coddetalle,
	detallespagos.montopago,
	detallespagos.fechapago,
	detallespagos.statuspago,
	GROUP_CONCAT(detallespagos.mespago SEPARATOR ', ') AS detalles_meses,
	GROUP_CONCAT(detallespagos.mespago, ' | ',detallespagos.montopago SEPARATOR '<br>') AS detalles_meses2
	FROM (pagos INNER JOIN detallespagos ON pagos.numcomprobante = detallespagos.numcomprobante)
	LEFT JOIN estudiantes ON pagos.codest = estudiantes.codest 
	LEFT JOIN padres ON estudiantes.codpadre = padres.codpadre
	LEFT JOIN turnos ON pagos.codturno = turnos.codturno 
	LEFT JOIN secciones ON pagos.codseccion = secciones.codseccion 
	LEFT JOIN grados ON secciones.codgrado = grados.codgrado 
	LEFT JOIN niveles ON secciones.codnivel = niveles.codnivel 
	LEFT JOIN periodoescolar ON pagos.codperiodo = periodoescolar.codperiodo
	LEFT JOIN cajas ON pagos.codcaja = cajas.codcaja
	LEFT JOIN usuarios ON pagos.codigo = usuarios.codigo 
	WHERE detallespagos.numcomprobante = ? 
	GROUP BY detallespagos.numcomprobante, detallespagos.statuspago 
	ORDER BY detallespagos.mespago ASC ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["numcomprobante"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION ID PAGOS DE ESTUDIANTES ###########################

######################## FUNCION ACTUALIZAR PAGOS DE ESTUDIANTES ###########################
public function ActualizarPagos()
{
	self::SetNames();
	if(empty($_POST["codpago"]) or empty($_POST["codest"]) or empty($_POST["montopago"]))
	{
		echo "1";
		exit;
	}
	################ AQUI ACTUALIZAMOS LOS DATOS DEL PAGO ###################
   $sql = " UPDATE detallespagos  set "
   ." montopago = ? "
   ." WHERE "
   ." codpago = ?;
   ";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $montopago);
	$stmt->bindParam(2, $codpago);
		
	$montopago = limpiar($_POST["montopago"]);
	$codpago = limpiar(decrypt($_POST["codpago"]));
	$stmt->execute();	
	################ AQUI ACTUALIZAMOS LOS DATOS DEL PAGO ###################
		
   echo "<span class='fa fa-check-square-o'></span> EL PAGO DEL ESTUDIANTE HA SIDO ACTUALIZADO EXITOSAMENTE";
	exit;
}
######################## FUNCION ACTUALIZAR PAGOS DE ESTUDIANTES ###########################

######################## FUNCION BUSQUEDA DE COMPROBANTES DE PAGOS ##########################
public function BuscarComprobantesReportes() 
{
	self::SetNames();
	$sql = "SELECT
	pagos.*,
   estudiantes.codpadre,
   estudiantes.codest, 
	estudiantes.cedest,
	estudiantes.pnomest,
	estudiantes.snomest,
	estudiantes.papeest,
	estudiantes.sapeest,
	estudiantes.sexoest,
	estudiantes.direcest,
	estudiantes.fnacest,
	padres.cedpadre,
	padres.nompadre,
	padres.apepadre,
	padres.tlfpadre,
	padres.statuspad,
	turnos.turno,
	secciones.seccion,
	grados.grado,
	niveles.nivel,
	niveles.pagonivel,
	periodoescolar.periodo,
	periodoescolar.descripcion,
	detallespagos.coddetalle,
	detallespagos.montopago,
	detallespagos.fechapago,
	detallespagos.statuspago,
	GROUP_CONCAT(detallespagos.mespago SEPARATOR ', ') AS detalles_meses
	FROM (pagos INNER JOIN detallespagos ON pagos.numcomprobante = detallespagos.numcomprobante)
	LEFT JOIN estudiantes ON pagos.codest = estudiantes.codest 
	LEFT JOIN padres ON estudiantes.codpadre = padres.codpadre 
	LEFT JOIN turnos ON pagos.codturno = turnos.codturno 
	LEFT JOIN secciones ON pagos.codseccion = secciones.codseccion 
	LEFT JOIN grados ON secciones.codgrado = grados.codgrado 
	LEFT JOIN niveles ON secciones.codnivel = niveles.codnivel 
	LEFT JOIN periodoescolar ON pagos.codperiodo = periodoescolar.codperiodo
	WHERE pagos.codest = ? 
	AND pagos.codperiodo = ?
	GROUP BY detallespagos.numcomprobante, detallespagos.statuspago 
	ORDER BY detallespagos.mespago ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_GET['codest']));
	$stmt->bindValue(2, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
	   echo "<div class='alert alert-danger'>";
	   echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
      echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
      echo "</div>";		
	   exit;
	}
	else
	{
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION BUSQUEDA DE COMPROBANTES DE PAGOS ##########################

########################## FUNCION PARA BUSQUEDA DE PAGOS POR FECHAS ###########################
public function BuscarPagosxFechas() 
{
	self::SetNames();
	$sql ="SELECT
	pagos.numcomprobante,
	pagos.codest,
	pagos.codturno,
	pagos.codseccion,
	pagos.codperiodo,
	pagos.becado,
	SUM(pagos.subtotal) as subtotal,
	SUM(pagos.totaldescuento) as totaldescuento,
	SUM(pagos.cuotaunica) as cuotaunica,
	SUM(pagos.montomesextra) as montomesextra,
	SUM(pagos.totalintereses) as totalintereses,
	SUM(pagos.totalpago) as totalpago, 
	estudiantes.codest, 
	estudiantes.cedest, 
	estudiantes.pnomest, 
	estudiantes.snomest, 
	estudiantes.papeest, 
	estudiantes.sapeest, 
	estudiantes.fnacest, 
	estudiantes.fechainscripcion, 
	periodoescolar.periodo,
   periodoescolar.interesmora, 
	turnos.turno,
	secciones.seccion,
	grados.grado,
	niveles.nivel,
	niveles.pagonivel, 
   pag.mesespag,
   pag.montopago,
   pag.totalpagad
   FROM (pagos LEFT JOIN estudiantes ON pagos.codest = estudiantes.codest)
	LEFT JOIN turnos ON pagos.codturno = turnos.codturno 
	LEFT JOIN secciones ON pagos.codseccion = secciones.codseccion 
	LEFT JOIN grados ON secciones.codgrado = grados.codgrado 
	LEFT JOIN niveles ON secciones.codnivel = niveles.codnivel 
	LEFT JOIN periodoescolar ON pagos.codperiodo = periodoescolar.codperiodo

	LEFT JOIN
      (SELECT
      numcomprobante, montopago, COUNT(mespago) AS totalpagad, 
      CASE WHEN statuspago = 1 THEN GROUP_CONCAT(DISTINCT mespago SEPARATOR ', ') END mesespag
      FROM detallespagos  
      WHERE statuspago = 1 AND codperiodo = ".limpiar(decrypt($_GET['codperiodo']))."
      GROUP BY codest ) pag ON pag.numcomprobante = pagos.numcomprobante

	WHERE DATE_FORMAT(pagos.fechapago,'%Y-%m-%d') BETWEEN ? AND ?
	AND pagos.codperiodo = ? 
	GROUP BY pagos.codest";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->bindValue(3, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################## FUNCION PARA BUSQUEDA DE PAGOS POR FECHAS ###########################

########################## FUNCION SUMA GASTOS POR FECHAS Y PERIODO ###########################
public function SumaGastosFechas()
{
	self::SetNames();
	$sql = "SELECT 
	SUM(montomovimiento) as egresos 
	FROM movimientoscajas 
	WHERE tipomovimiento = 'EGRESO'
	AND DATE_FORMAT(fechamovimiento,'%Y-%m-%d') BETWEEN ? AND ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(date("Y-m-d",strtotime($_GET['desde'])),date("Y-m-d",strtotime($_GET['hasta']))));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
########################## FUNCION SUMA GASTOS POR FECHAS Y PERIODO ###########################

######################### FUNCION PARA BUSQUEDA DE PAGOS AL DIA ##########################
public function BuscarPagosAlDia() 
 {
	self::SetNames();
	$sql ="SELECT 
	est.codest AS id, 
	GROUP_CONCAT(DISTINCT est.cedest) AS cedula, 
	GROUP_CONCAT(DISTINCT est.pnomest) AS pNombre, 
	GROUP_CONCAT(DISTINCT est.snomest) AS sNombre, 
	GROUP_CONCAT(DISTINCT est.papeest) AS pApellido, 
	GROUP_CONCAT(DISTINCT est.sapeest) AS sApellido, 
	est.fnacest, 
	est.fechainscripcion, 
	GROUP_CONCAT(DISTINCT detallespagos.mespago SEPARATOR ', ') AS meses, 
	detallespagos.montopago,
	pagos.totalpago,
	pagos.becado,  
	pagos.cuotaunica, 
	pagos.descuento, 
	pagos.montomesextra, 
	pagos.fechapago, 
	pagos.numcomprobante, 
	pagos.totalvencidas, 
   pagos.totalpendiente,
   pagos.totalpagada,
	turnos.turno,
	secciones.seccion,
	grados.grado,
	niveles.nivel,
	niveles.pagonivel,  
	periodoescolar.periodo,
   periodoescolar.interesmora 
	FROM estudiantes est INNER JOIN detallespagos  ON est.codest = detallespagos.codest 
	LEFT JOIN pagos ON detallespagos.numcomprobante = pagos.numcomprobante 
	INNER JOIN turnos ON detallespagos.codturno = turnos.codturno 
	INNER JOIN secciones ON detallespagos.codseccion = secciones.codseccion 
	INNER JOIN grados ON secciones.codgrado = grados.codgrado 
	INNER JOIN niveles ON secciones.codnivel = niveles.codnivel 
	INNER JOIN periodoescolar ON detallespagos.codperiodo = periodoescolar.codperiodo 
	WHERE detallespagos.codseccion = ? 
	AND detallespagos.codturno = ? 
	AND detallespagos.mespago = ?
	AND detallespagos.codperiodo = ? 
	AND detallespagos.statuspago = 1
	GROUP BY id";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codseccion'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(3, trim($_GET['mespago']));
	$stmt->bindValue(4, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################### FUNCION PARA BUSQUEDA DE PAGOS AL DIA ##########################

######################### FUNCION PARA BUSQUEDA DE PAGOS VENCIDOS POR CURSOS ############################
public function BuscarPagosVencidosxCursos() 
{
	self::SetNames();
	$sql ="SELECT 
	est.codest AS id, 
	GROUP_CONCAT(DISTINCT est.cedest) AS cedula, 
	GROUP_CONCAT(DISTINCT est.pnomest) AS pNombre, 
	GROUP_CONCAT(DISTINCT est.snomest) AS sNombre, 
	GROUP_CONCAT(DISTINCT est.papeest) AS pApellido, 
	GROUP_CONCAT(DISTINCT est.sapeest) AS sApellido, 
	est.fnacest, 
	est.fechainscripcion, 
	GROUP_CONCAT(DISTINCT detallespagos.mespago SEPARATOR ', ') AS mesesvencidos, 
	detallespagos.codturno,
	detallespagos.codseccion,
	detallespagos.codperiodo,
	detallespagos.becado, 
	detallespagos.montopago,
	detallespagos.fechapago, 
	detallespagos.numcomprobante,
	niveles.nivel, 
	grados.grado, 
	secciones.seccion, 
	turnos.turno, 
	periodoescolar.periodo,
   periodoescolar.interesmora
	FROM estudiantes est INNER JOIN detallespagos  ON est.codest = detallespagos.codest 
	LEFT JOIN turnos ON detallespagos.codturno = turnos.codturno 
	LEFT JOIN secciones ON detallespagos.codseccion = secciones.codseccion 
	LEFT JOIN grados ON secciones.codgrado = grados.codgrado 
	LEFT JOIN niveles ON secciones.codnivel = niveles.codnivel 
	LEFT JOIN periodoescolar ON detallespagos.codperiodo = periodoescolar.codperiodo 
	WHERE detallespagos.codseccion = ? 
	AND detallespagos.codturno = ? 
	AND detallespagos.codperiodo = ? 
	AND detallespagos.statuspago = 2 
	GROUP BY id";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codseccion'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(3, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	
  } else {
  
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################### FUNCION PARA BUSQUEDA DE PAGOS VENCIDOS POR CURSOS ############################

######################### FUNCION PARA BUSQUEDA DE PAGOS VENCIDOS POR PERIODO ############################
public function BuscarPagosVencidosxPeriodo() 
{
	self::SetNames();
	$sql ="SELECT 
	est.codest AS id, 
	GROUP_CONCAT(DISTINCT est.cedest) AS cedula, 
	GROUP_CONCAT(DISTINCT est.pnomest) AS pNombre, 
	GROUP_CONCAT(DISTINCT est.snomest) AS sNombre, 
	GROUP_CONCAT(DISTINCT est.papeest) AS pApellido, 
	GROUP_CONCAT(DISTINCT est.sapeest) AS sApellido, 
	est.fnacest, 
	est.fechainscripcion, 
	GROUP_CONCAT(DISTINCT detallespagos.mespago SEPARATOR ', ') AS mesesvencidos, 
	detallespagos.codturno,
	detallespagos.codseccion,
	detallespagos.codperiodo,
	detallespagos.becado, 
	detallespagos.montopago,
	detallespagos.fechapago, 
	detallespagos.numcomprobante,
	niveles.nivel, 
	grados.grado, 
	secciones.seccion, 
	turnos.turno, 
	periodoescolar.periodo,
   periodoescolar.interesmora
	FROM estudiantes est INNER JOIN detallespagos  ON est.codest = detallespagos.codest 
	LEFT JOIN turnos ON detallespagos.codturno = turnos.codturno 
	LEFT JOIN secciones ON detallespagos.codseccion = secciones.codseccion 
	LEFT JOIN grados ON secciones.codgrado = grados.codgrado 
	LEFT JOIN niveles ON secciones.codnivel = niveles.codnivel 
	LEFT JOIN periodoescolar ON detallespagos.codperiodo = periodoescolar.codperiodo 
	WHERE detallespagos.codest = ? 
	AND detallespagos.codperiodo = ? 
	AND detallespagos.statuspago = 2 
	GROUP BY detallespagos.codest, detallespagos.codperiodo";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(limpiar($_GET['codest'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	
  } else {
  
	while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################### FUNCION PARA BUSQUEDA DE PAGOS VENCIDOS POR PERIODO ############################

########################################## FIN DE CLASE PAGOS ###########################################











































######################################## CLASE NOTAS DE ESTUDIANTES ####################################

######################### FUNCION BUSQUEDA ESTUDIANTES PARA NOTAS #############################
public function ProcesarNotasEstudiantes() 
{
	self::SetNames();
	############# OBTENGO DATOS DE CONFIGURACION #############
	$conf = "SELECT * FROM configuracion";
	foreach ($this->dbh->query($conf) as $rowcon)
	{
		$this->pcon[] = $rowcon;
	}
	$fecha = strftime("%Y-%m-%d"); //fecha tipo 2011/06/14
	$inicio_nota = (empty($rowcon['inicionotas']) ? "" : $rowcon['inicionotas']);
   $fin_nota = (empty($rowcon['finnotas']) ? "" : $rowcon['finnotas']);
   $trimestre = (empty($rowcon['trimestreactivo']) ? "" : $rowcon['trimestreactivo']);
	############# OBTENGO DATOS DE CONFIGURACION #############

	############# OBTENGO PERIODO ESCOLAR ACTIVO #############
	$period = "SELECT * FROM periodoescolar WHERE statusperiodo = 1";
	foreach ($this->dbh->query($period) as $rowper)
	{
		$this->pper[] = $rowper;
	}
	$codperiodo = (empty($rowper['codperiodo']) ? "" : $rowper['codperiodo']);
	$periodo = (empty($rowper['periodo']) ? "" : $rowper['periodo']);
	$statusperiodo = (empty($rowper['statusperiodo']) ? "" : $rowper['statusperiodo']);

	if (empty($statusperiodo)) {

		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN PERIODO ESCOLAR ACTIVO, POR FAVOR DEBER&Aacute; DE CREARLO</center>";
	   echo "</div>";		
		exit;
	}
	############# OBTENGO PERIODO ESCOLAR ACTIVO #############

	############# OBTENGO DATOS DE MATERIAS #############
	$mat = "SELECT * FROM materias WHERE codmateria = '".decrypt($_GET['codmateria'])."'";
	foreach ($this->dbh->query($mat) as $rowmat)
	{
		$this->pmat[] = $rowmat;
	}
	$materia = $rowmat['nommateria'];
	############# OBTENGO DATOS DE MATERIAS #############

   if ($_SESSION['acceso'] == "docente") {

		$sql = "SELECT * FROM asignaciones INNER JOIN periodoescolar ON asignaciones.codperiodo = periodoescolar.codperiodo
		WHERE asignaciones.coddoc = ? 
		AND asignaciones.codturno = ? 
		AND asignaciones.codseccion = ? 
		AND asignaciones.codmateria = ? 
		AND periodoescolar.statusperiodo = 1";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindValue(1, trim($_SESSION['coddoc']));
		$stmt->bindValue(2, trim(decrypt($_GET['codturno'])));
		$stmt->bindValue(3, trim(decrypt($_GET['codseccion'])));
		$stmt->bindValue(4, trim(decrypt($_GET['codmateria'])));
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "<div class='alert alert-danger'>";
			echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		   echo "<center><span class='fa fa-info-circle'></span> ESTA MATERIA NO SE ENCUENTRA ASIGNADA A ESTE DOCENTE, POR LO TANTO LAS NOTAS NO PUEDEN CARGARSE, <br> VERIFIQUE NUEVAMENTE O CONTACTE CON EL DOCENTE RESPONSABLE DE LA CARGA DE NOTAS</center>";
		   echo "</div>";		
			exit;
      }
   }

	$sql = "SELECT * FROM asignaciones 
	WHERE codturno = ? 
	AND codseccion = ? 
	AND codmateria = ? 
	AND codperiodo = '".$codperiodo."'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codseccion'])));
	$stmt->bindValue(3, trim(decrypt($_GET['codmateria'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> ESTA MATERIA NO SE ENCUENTRA ASIGNADA A UN DOCENTE, POR LO TANTO LAS NOTAS NO PUEDEN CARGARSE, <br> VERIFIQUE NUEVAMENTE O CONTACTE CON EL DOCENTE RESPONSABLE DE LA CARGA DE NOTAS</center>";
	   echo "</div>";		
		exit;

	} else {

	$sql = "SELECT * FROM estudiantes 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo 
	WHERE estudiantes.codturno = ? 
	AND estudiantes.codseccion = ? 
	AND estudiantes.statusest = 1 
	ORDER BY estudiantes.papeest";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codseccion'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
	    echo "</div>";		
		exit;
	
	} else {

   $sql ="SELECT 
   estudiantes.codest, 
   estudiantes.cedest, 
   estudiantes.pnomest, 
   estudiantes.snomest, 
   estudiantes.papeest, 
   estudiantes.sapeest, 
   estudiantes.codseccion, 
   estudiantes.codturno, 
   estudiantes.codperiodo, 
   estudiantes.fechainscripcion, 
   periodoescolar.periodo, 
   niveles.nivel, 
   grados.grado, 
   secciones.seccion, 
   notas.codnota, 
   notas.nota1, 
   notas.faltas1, 
   notas.nota2, 
   notas.faltas2, 
   notas.nota3, 
   notas.faltas3, 
   notas.nota4, 
   notas.faltas4, 
   notas.definitiva, 
   notas.literal, 
   notas.total_faltas 
   FROM (estudiantes INNER JOIN turnos ON estudiantes.codturno = turnos.codturno) 
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo 
   LEFT JOIN notas ON notas.codest = estudiantes.codest 
   WHERE estudiantes.codturno = ? 
   AND estudiantes.codseccion = ? 
   AND notas.codmateria = ? 
   AND estudiantes.statusest = 1 
   AND notas.codperiodo = '".$codperiodo."'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codseccion'])));
	$stmt->bindValue(3, trim(decrypt($_GET['codmateria'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{ 

		$est = "SELECT * FROM estudiantes 
		LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	   LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	   LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	   LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	   LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo 
		WHERE estudiantes.codturno = '".limpiar(decrypt($_GET['codturno']))."'  
		AND estudiantes.codseccion = '".limpiar(decrypt($_GET['codseccion']))."'
		AND estudiantes.statusest = 1 
		ORDER BY estudiantes.papeest";
		$stmt = $this->dbh->prepare($est);
		foreach ($this->dbh->query($est) as $row)
		{
			$this->p[] = $row;
		}

		$nivel = $row['nivel'];
		$grado = $row['grado'];
		$seccion = $row['seccion'];

if ($trimestre == 0) {

	echo "<div class='alert alert-danger'>";
	echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
   echo "<center><span class='fa fa-info-circle'></span> NO EXISTE UN PERIODO ACTIVO PARA REGISTRAR NOTAS, DIRIJASE AL ADMINISTRADOR PARA QUE ACTIVE EL PERIODO A CARGAR</center>";
   echo "</div>";
}

if($nivel=="INICIAL"){ ?>

<input type="hidden" name="codperiodo" id="codperiodo" value="<?php echo encrypt($codperiodo); ?>"/>
<input type="hidden" name="nivel" id="nivel" value="<?php echo $nivel; ?>"/>
<input type="hidden" name="registrar" value="ok"/>

<div class="row">
<div class="col-md-12">
<div class="panel panel-primary">
<div class="panel-heading">
<h3 class="panel-title"><i class="fa fa-edit"></i> Gesti&oacute;n de Notas en <?php echo $nivel; ?> - <?php echo $grado; ?> Secci&oacute;n <?php echo $seccion; ?> del Periodo <?php echo $periodo; ?></h3>
</div>

<div class="panel-body">
<div id="datatable-responsive_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">


<div class="row">
<div class="col-sm-12">

<div id="div1"><div class="table-responsive" data-pattern="priority-columns">
                <table id="tech-companies-1" class="table table-small-font table-bordered table-striped">
                                                 <thead>
                        <tr role="row">
                        <th colspan="12"><center><?php echo "<h4>".$materia."</h4>"; ?></center></th>
                        </tr>
                         <tr role="row">
                          <th>N&deg;</th>
                          <th>Apellidos y Nombres del Estudiante</th>
                          <th colspan="2">1er Periodo</th>
                          <th colspan="2">2do Periodo</th>
                          <th colspan="2">3er Periodo</th>
                          <th colspan="2">4to Periodo</th>
                          <th colspan="2">Definitiva</th>
                         </tr>
                         </thead>
                         <tbody>
<?php 
$a=1;
foreach ($this->dbh->query($est) as $nota){
?>

                                               <tr role="row" class="odd">
<td><input name="codest[]" type="hidden" id="codest" value="<?php echo $nota['codest']; ?>"/>
<?php echo $a++; ?></td>

<td><abbr title="<?php echo "N&deg; de C&oacute;digo: ".$nota['cedest']; ?>"><?php echo $nota['papeest']." ".$nota['sapeest']." ".$nota['pnomest']." ".$nota['snomest']; ?></abbr></td>

<?php if ($trimestre == 0) { ?>

<!-- PROCESO NOTA 1 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 2 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 3 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 4 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- DEFINITIVA -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<?php } else { ?>

<td align="center"><input style="color:#000;font-weight:bold;width:80px;" class="form-control" name="nota1[]" id="nota" onfocus="this.style.background=('#B7F0FF')" onBlur="this.style.background=('#FFF')" type="text" size="3" maxlength="3" autocomplete="off" placeholder="P1"/></td>

<td align="center"><input style="color:#000;font-weight:bold;width:80px;" class="form-control" name="faltas1[]" id="faltas1" onfocus="this.style.background=('#B7F0FF')" onBlur="this.style.background=('#FFF')" type="text" size="3" maxlength="3" autocomplete="off" placeholder="F1"/></td>

<!-- PROCESO NOTA 2 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 3 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 4 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- DEFINITIVA -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
                         </tr>
                         <?php } } ?>
                         </tbody>
</table></div>
    <label>Escala de valoración: SUPERIOR: 5:00 - ALTO: 4.0 a 4.9 - BÁSICO: 3.0 a 3.9 -  BAJO: 1.0 a 2.9</label>
                </div><br />
<?php if ($trimestre != 0) { ?>
        <div class="text-right">
<button type="submit" name="btn-submit" id="btn-submit" class="btn btn-primary"><span class="fa fa-save"></span> Guardar</button>
        </div>
<?php } ?>
                           </div><!-- /.box-body -->
                        </div>
                     </div>
                  </div>
               </div>
           </div>
      </div>

<?php } else { ?>

<input type="hidden" name="codperiodo" id="codperiodo" value="<?php echo encrypt($codperiodo); ?>"/>
<input type="hidden" name="nivel" id="nivel" value="<?php echo $nivel; ?>"/>
<input type="hidden" name="registrar" value="ok"/>

<div class="row">
<div class="col-md-12">
<div class="panel panel-primary">
<div class="panel-heading">
<h3 class="panel-title"><i class="fa fa-edit"></i> Gesti&oacute;n de Notas en <?php echo $nivel; ?> - <?php echo $grado; ?> Secci&oacute;n <?php echo $seccion; ?> del Periodo <?php echo $periodo; ?></h3>
</div>

<div class="panel-body">
<div id="datatable-responsive_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">


<div class="row">
<div class="col-sm-12">

<div id="div1"><div class="table-responsive" data-pattern="priority-columns">
                <table id="tech-companies-1" class="table table-small-font table-bordered table-striped">
                                                 <thead>
                         <tr role="row">
                           <th rowspan="2">N&deg;</th>
                           <th rowspan="2">Apellidos y Nombres del Estudiante</th>
                           <th colspan="4"><center><?php echo "<h4>".$materia."</h4>"; ?></center></th>
                           </tr>
                         <tr role="row">
                          <th colspan="2">1er Periodo</th>
                          <th colspan="2">2do Periodo</th>
                          <th colspan="2">3er Periodo</th>
                          <th colspan="2">4to Periodo</th>
                          <th colspan="2">Definitiva</th>
                         </tr>
                         </thead>
                         <tbody>
<?php 
$a=1;
foreach ($this->dbh->query($est) as $nota){
?>

                                               <tr role="row" class="odd">
<td><input name="codest[]" type="hidden" id="codest" value="<?php echo $nota['codest']; ?>"/>
<?php echo $a++; ?></td>

<td><abbr title="<?php echo "N&deg; de C&oacute;digo: ".$nota['cedest']; ?>"><?php echo $nota['papeest']." ".$nota['sapeest']." ".$nota['pnomest']." ".$nota['snomest']; ?></abbr></td>

<?php if ($trimestre == 0) { ?>

<!-- PROCESO NOTA 1 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 2 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 3 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 4 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- DEFINITIVA -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<?php } else { ?>

<td align="center"><input style="color:#000;font-weight:bold;width:80px;" class="form-control" name="nota1[]" id="nota" onfocus="this.style.background=('#B7F0FF')" onBlur="this.style.background=('#FFF')" type="text" size="3" maxlength="3" autocomplete="off" placeholder="P1"/></td>

<td align="center"><input style="color:#000;font-weight:bold;width:80px;" class="form-control" name="faltas1[]" id="faltas1" onfocus="this.style.background=('#B7F0FF')" onBlur="this.style.background=('#FFF')" type="text" size="3" maxlength="3" autocomplete="off" placeholder="F1"/></td>

<!-- PROCESO NOTA 2 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 3 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- PROCESO NOTA 4 -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>

<!-- DEFINITIVA -->
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
<td align="center"><?php echo "<h5>0</h5>"; ?></td>
                         </tr>
                         <?php } } ?>
                         </tbody>
</table></div>
    <label>Escala de valoración: SUPERIOR: 5:00 - ALTO: 4.0 a 4.9 - BÁSICO: 3.0 a 3.9 -  BAJO: 1.0 a 2.9</label>
                </div><br />
<?php if ($trimestre != 0) { ?>
        <div class="text-right">
<button type="submit" name="btn-submit" id="btn-submit" class="btn btn-primary"><span class="fa fa-save"></span> Guardar</button>
        </div>
<?php } ?>
                           </div><!-- /.box-body -->
                        </div>
                     </div>
                  </div>
               </div>
           </div>
      </div>
      
		<?php

	 }  exit;

	 } else {

		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[]=$row;
			}
			return $this->p;
			$this->dbh=null;
		    }
	    }
	}
}
######################### FUNCION BUSQUEDA ESTUDIANTES PARA NOTAS #############################

############################# FUNCION PARA REGISTRAR NOTAS ###############################
public function RegistrarNotas()
{
	self::SetNames();
	if(empty($_POST["codturno"]) or empty($_POST["codnivel"]) or empty($_POST["codgrado"]) or empty($_POST["codseccion"]) or empty($_POST["codmateria"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT coddoc FROM asignaciones 
	WHERE codturno = '".decrypt($_POST['codturno'])."' 
	AND codseccion = '".decrypt($_POST['codseccion'])."' 
	AND codmateria = '".decrypt($_POST['codmateria'])."' 
	AND codperiodo = '".decrypt($_POST['codperiodo'])."'";
	foreach ($this->dbh->query($sql) as $rowcon)
	{
		$this->pcon[] = $rowcon;
	}
	$coddoc = $rowcon['coddoc'];
	
	###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################
	for($i=0;$i<count($_POST['nota1']);$i++){  //recorro el array
    
	    if (empty($_POST['nota1'][$i]) || trim($_POST['nota1'][$i])==""){
		   echo "2";
		   exit;
        } else if ($_POST['nota1'][$i] > 5){
		    echo "3";
		    exit;
	    }
	}
	###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################
		
	########################### PROCESO PARA REGISTRO DE CARGA ##############################
	for($i=0;$i<count($_POST['codest']);$i++){  //recorro el array
        if (!empty($_POST['codest'][$i])) {
	    
			################## REGISTRO VALORES DE NOTAS ##################
			$query = "INSERT INTO notas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codest);
			$stmt->bindParam(2, $coddoc);
			$stmt->bindParam(3, $codnivel);
			$stmt->bindParam(4, $codgrado);
			$stmt->bindParam(5, $codseccion);
			$stmt->bindParam(6, $codturno);
			$stmt->bindParam(7, $codperiodo);
			$stmt->bindParam(8, $codmateria);
			$stmt->bindParam(9, $nota1);
			$stmt->bindParam(10, $faltas1);
			$stmt->bindParam(11, $nota2);
			$stmt->bindParam(12, $faltas2);
			$stmt->bindParam(13, $nota3);
			$stmt->bindParam(14, $faltas3);
			$stmt->bindParam(15, $nota4);
			$stmt->bindParam(16, $faltas4);
			$stmt->bindParam(17, $definitiva);
			$stmt->bindParam(18, $literal);
			$stmt->bindParam(19, $total_faltas);
			
			$codest = limpiar($_POST["codest"][$i]);
			$codnivel = limpiar(decrypt($_POST['codnivel']));
			$codgrado = limpiar(decrypt($_POST['codgrado']));
			$codseccion = limpiar(decrypt($_POST['codseccion']));
			$codturno = limpiar(decrypt($_POST['codturno']));
			$codperiodo = limpiar(decrypt($_POST['codperiodo']));
			$codmateria = limpiar(decrypt($_POST['codmateria']));
			$nota1 = rount($_POST['nota1'][$i],1);
			$faltas1 = limpiar($_POST['faltas1'][$i]);
			$nota2 = limpiar("0");
			$faltas2 = limpiar("0");
			$nota3 = limpiar("0");
			$faltas3 = limpiar("0");
			$nota4 = limpiar("0");
			$faltas4 = limpiar("0");
			$suma = ($_POST['nota1'][$i]);
		   $definitiva = rount($suma/1,1);
			$literal = limpiar("0");
		   $total_faltas = ($_POST['faltas1'][$i]);
			$stmt->execute();
			################## REGISTRO VALORES DE NOTAS ##################

		   ############# CONSULTO CANTIDAD MATERIAS #############
        	$sql = "SELECT 
        	SUM(definitiva) AS suma_materias,
        	COUNT(codmateria) AS cantidad_materias 
        	FROM notas 
        	WHERE codest = '".limpiar($_POST["codest"][$i])."'
        	AND codperiodo = '".limpiar(decrypt($_POST['codperiodo']))."'";
        	foreach ($this->dbh->query($sql) as $row)
        	{
        		$this->p[] = $row;
        	}
        	$suma_materias = $row['suma_materias'];
        	$cantidad_materias = $row['cantidad_materias'];
        	############# CONSULTO CANTIDAD MATERIAS #############

		   ############# VERIFICO VALORES EN DEFINITIVAS #############
		   $sql = " SELECT * FROM definitivas 
		   WHERE codest = '".limpiar($_POST["codest"][$i])."'
        	AND codperiodo = '".limpiar(decrypt($_POST['codperiodo']))."'";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->execute();
		   $num = $stmt->rowCount();
		   if($num == 0)
		   {
			   ################## REGISTRO VALORES DE DEFINITIVA ##################
				$query = "INSERT INTO definitivas values (null, ?, ?, ?, ?, ?); ";
				$stmt = $this->dbh->prepare($query);
				$stmt->bindParam(1, $codest);
				$stmt->bindParam(2, $codperiodo);
				$stmt->bindParam(3, $nota_definitiva);
				$stmt->bindParam(4, $aprobo);
				$stmt->bindParam(5, $puesto);
				
				$codest = limpiar($_POST["codest"][$i]);
				$codperiodo = limpiar(decrypt($_POST['codperiodo']));
				$nota_definitiva = rount($suma_materias/$cantidad_materias,1);
				$aprobo = limpiar($nota_definitiva <= 2.9 ? 0 : 1);
				$puesto = limpiar("0");
				$stmt->execute();
				################## REGISTRO VALORES DE DEFINITIVA ##################

			} else {

				################## ACTUALIZO VALORES DE DEFINITIVA ##################
		       $sql = " UPDATE definitivas set "
					." nota_definitiva = ?, "
					." aprobo = ? "
				   ." WHERE "
				   ." codest = ? AND codperiodo = ?;
				   ";
			   $stmt = $this->dbh->prepare($sql);
				$stmt->bindParam(1, $nota_definitiva);
				$stmt->bindParam(2, $aprobo);
				$stmt->bindParam(3, $codest);
				$stmt->bindParam(4, $codperiodo);
			
				$nota_definitiva = rount($suma_materias/$cantidad_materias,1);
				$aprobo = limpiar($nota_definitiva <= 2.9 ? 0 : 1);
				$codest = limpiar($_POST["codest"][$i]);
				$codperiodo = limpiar(decrypt($_POST['codperiodo']));
			   $stmt->execute();
			   ################## ACTUALIZO VALORES DE DEFINITIVA ##################
			}
			############# VERIFICO VALORES EN DEFINITIVAS #############
	   }
   }
   ########################### PROCESO PARA REGISTRO DE CARGA ##############################

   echo "<span class='fa fa-check-square-o'></span> LA CARGA DE NOTAS HA SIDO PROCESADA EXITOSAMENTE";
   exit;
}
############################# FUNCION PARA REGISTRAR NOTAS ###############################

############################# FUNCION PARA ACTUALIZAR NOTAS ###############################
public function ActualizarNotas()
{
	self::SetNames();
	if(empty($_POST["codturno"]) or empty($_POST["codnivel"]) or empty($_POST["codgrado"]) or empty($_POST["codseccion"]) or empty($_POST["codmateria"]) or empty($_POST["trimestre"]))
	{
		echo "1";
		exit;
	}
								 
	if ($_POST['trimestre'] == 1) {

		###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################
		for($i=0;$i<count($_POST['nota1']);$i++){  //recorro el array
        
         if (empty($_POST['nota1'][$i]) || trim($_POST['nota1'][$i])==""){
		      echo "2";
		      exit;
	      } else if ($_POST['nota1'][$i] > 5){
		      echo "3";
		      exit;
	      }
		}
		###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################

		########################### PROCESO NOTA Nº1 ##############################
		for($i=0;$i<count($_POST['codnota']);$i++){  //recorro el array
            if (!empty($_POST['codnota'][$i])) {
		    
		      ############# CONSULTO NOTAS #############
				$sql = "SELECT 
				nota1, faltas1, nota2, faltas2, nota3, faltas3, nota4, faltas4 
				FROM notas WHERE codnota = '".$_POST["codnota"][$i]."'";
				foreach ($this->dbh->query($sql) as $row)
				{
				   $this->p[] = $row;
				}
				############# CONSULTO NOTAS #############
		    
			   ################## ACTUALIZO VALORES DE NOTAS ##################
			   $sql = " UPDATE notas set "
				  ." nota1 = ?, "
				  ." faltas1 = ?, "
				  ." definitiva = ?, "
				  ." total_faltas = ? "
				  ." WHERE "
				  ." codnota = ?;
				   ";
			   $stmt = $this->dbh->prepare($sql);
			   $stmt->bindParam(1, $nota1);
			   $stmt->bindParam(2, $faltas1);
			   $stmt->bindParam(3, $definitiva);
			   $stmt->bindParam(4, $total_faltas);
			   $stmt->bindParam(5, $codnota);
			
			   $nota1 = rount($_POST['nota1'][$i],1);
			   $faltas1 = limpiar($_POST['faltas1'][$i]);
			   $suma = ($_POST['nota1'][$i]);
		      $definitiva = rount($suma/1,1);
		      $total_faltas = ($_POST['faltas1'][$i]);
			   $codnota = limpiar($_POST["codnota"][$i]);
			   $stmt->execute();
			   ################## ACTUALIZO VALORES DE NOTAS ##################

			   ############# CONSULTO CANTIDAD MATERIAS #############
	        	$sql = "SELECT 
	        	SUM(definitiva) AS suma_materias,
	        	COUNT(codmateria) AS cantidad_materias 
	        	FROM notas 
	        	WHERE codest = '".limpiar($_POST["codest"][$i])."'
	        	AND codperiodo = '".limpiar(decrypt($_POST['codperiodo']))."'";
	        	foreach ($this->dbh->query($sql) as $row)
	        	{
	        		$this->p[] = $row;
	        	}
	        	$suma_materias = $row['suma_materias'];
	        	$cantidad_materias = $row['cantidad_materias'];
	        	############# CONSULTO CANTIDAD MATERIAS #############

				################## ACTUALIZO VALORES DE DEFINITIVA ##################
		      $sql = " UPDATE definitivas set "
					." nota_definitiva = ?, "
					." aprobo = ? "
				   ." WHERE "
				   ." codest = ? AND codperiodo = ?;
				   ";
			   $stmt = $this->dbh->prepare($sql);
				$stmt->bindParam(1, $nota_definitiva);
				$stmt->bindParam(2, $aprobo);
				$stmt->bindParam(3, $codest);
				$stmt->bindParam(4, $codperiodo);
			
				$nota_definitiva = rount($suma_materias/$cantidad_materias,1);
				$aprobo = limpiar($nota_definitiva <= 2.9 ? 0 : 1);
				$codest = limpiar($_POST["codest"][$i]);
				$codperiodo = limpiar(decrypt($_POST['codperiodo']));
			   $stmt->execute();
			   ################## ACTUALIZO VALORES DE DEFINITIVA ##################

			   /*############# CONSULTO DEFINITIVA DE MAYOR #############
	        	$sql = "SELECT 
	        	coddefinitiva,
	        	nota_definitiva 
	        	FROM definitivas 
	    	   WHERE codest = '".limpiar($_POST["codest"][$i])."'
	    	   AND codperiodo = '".limpiar($_POST["codperiodo"])."'
	    	   GROUP BY coddefinitiva
	        	ORDER BY nota_definitiva DESC";
		      $a = array();
	        	foreach ($this->dbh->query($sql) as $row)
	        	{
	        		$this->p[] = $row;
	        		$a = 1;
	        	   $coddefinitiva = $row['coddefinitiva'];
	        	   $nota_definitiva = $row['nota_definitiva'];

	        	   ################## ACTUALIZO VALORES DE DEFINITIVA ##################
			      $sql = " UPDATE definitivas set "
						." puesto = ? "
					   ." WHERE "
					   ." coddefinitiva = ?;
					   ";
				   $stmt = $this->dbh->prepare($sql);
					$stmt->bindParam(1, $puesto);
					$stmt->bindParam(2, $coddefinitiva);
				
					$puesto = $a++;
				   $stmt->execute();
				   ################## ACTUALIZO VALORES DE DEFINITIVA ##################
	        	}
	        	############# CONSULTO DEFINITIVA DE MAYOR #############*/
		   }
	   }
	   ########################### PROCESO NOTA Nº1 ##############################

	} elseif ($_POST['trimestre'] == 2) {

		###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################
		for($i=0;$i<count($_POST['nota2']);$i++){  //recorro el array
        
         if (empty($_POST['nota2'][$i]) || trim($_POST['nota2'][$i])==""){
		      echo "2";
		      exit;
	      } else if ($_POST['nota2'][$i] > 5){
		      echo "3";
		      exit;
	      }
		}
		###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################

      ########################### PROCESO NOTA Nº2 ##############################
		for($i=0;$i<count($_POST['codnota']);$i++){  //recorro el array
         if (!empty($_POST['codnota'][$i])) {
		    
	      ############# CONSULTO NOTAS #############
			$sql = "SELECT 
			nota1, faltas1, nota2, faltas2, nota3, faltas3, nota4, faltas4 
			FROM notas WHERE codnota = '".$_POST["codnota"][$i]."'";
			foreach ($this->dbh->query($sql) as $row)
			{
			   $this->p[] = $row;
			}
			############# CONSULTO NOTAS #############

		   ################## ACTUALIZO VALORES DE NOTAS ##################
		   $sql = " UPDATE notas set "
			  ." nota2 = ?, "
			  ." faltas2 = ?, "
			  ." definitiva = ?, "
			  ." total_faltas = ? "
			  ." WHERE "
			  ." codnota = ?;
			   ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $nota2);
			$stmt->bindParam(2, $faltas2);
			$stmt->bindParam(3, $definitiva);
			$stmt->bindParam(4, $total_faltas);
			$stmt->bindParam(5, $codnota);
		
		   $nota2 = rount($_POST['nota2'][$i],1);
			$faltas2 = limpiar($_POST['faltas2'][$i]);
	      //$suma = ($row['nota1'] + $_POST['nota2'][$i] + $row['nota3'] + $row['nota4']);
	      $suma = ($row['nota1'] + $_POST['nota2'][$i]);
		   $definitiva = rount($suma/2,1);
		   $total_faltas = ($row['faltas1'] + $_POST['faltas2'][$i] + $row['faltas3'] + $row['faltas4']);
		   $codnota = limpiar($_POST["codnota"][$i]);
		   $stmt->execute();
		   ################## ACTUALIZO VALORES DE NOTAS ##################

		   ############# CONSULTO CANTIDAD MATERIAS #############
        	$sql = "SELECT 
        	SUM(definitiva) AS suma_materias,
        	COUNT(codmateria) AS cantidad_materias 
        	FROM notas 
        	WHERE codest = '".limpiar($_POST["codest"][$i])."'
        	AND codperiodo = '".limpiar(decrypt($_POST['codperiodo']))."'";
        	foreach ($this->dbh->query($sql) as $row)
        	{
        		$this->p[] = $row;
        	}
        	$suma_materias = $row['suma_materias'];
        	$cantidad_materias = $row['cantidad_materias'];
        	############# CONSULTO CANTIDAD MATERIAS #############

			################## ACTUALIZO VALORES DE DEFINITIVA ##################
	      $sql = " UPDATE definitivas set "
				." nota_definitiva = ?, "
				." aprobo = ? "
			   ." WHERE "
			   ." codest = ? AND codperiodo = ?;
			   ";
		   $stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $nota_definitiva);
			$stmt->bindParam(2, $aprobo);
			$stmt->bindParam(3, $codest);
			$stmt->bindParam(4, $codperiodo);
		
			$nota_definitiva = rount($suma_materias/$cantidad_materias,1);
			$aprobo = limpiar($nota_definitiva <= 2.9 ? 0 : 1);
			$codest = limpiar($_POST["codest"][$i]);
			$codperiodo = limpiar(decrypt($_POST['codperiodo']));
		   $stmt->execute();
		   ################## ACTUALIZO VALORES DE DEFINITIVA ##################

		   }
	   }
	   ########################### PROCESO NOTA Nº2 ##############################

	} elseif ($_POST['trimestre'] == 3) {

		###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################
		for($i=0;$i<count($_POST['nota3']);$i++){  //recorro el array
        
         if (empty($_POST['nota3'][$i]) || trim($_POST['nota3'][$i])==""){
		      echo "2";
		      exit;
	      } else if ($_POST['nota3'][$i] > 5){
		      echo "3";
		      exit;
	      }
		}
		###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################

      ########################### PROCESO NOTA Nº3 ##############################
		for($i=0;$i<count($_POST['codnota']);$i++){  //recorro el array
         if (!empty($_POST['codnota'][$i])) {
		    
	      ############# CONSULTO NOTAS #############
			$sql = "SELECT 
			nota1, faltas1, nota2, faltas2, nota3, faltas3, nota4, faltas4 
			FROM notas WHERE codnota = '".$_POST["codnota"][$i]."'";
			foreach ($this->dbh->query($sql) as $row)
			{
			   $this->p[] = $row;
			}
			############# CONSULTO NOTAS #############

		   ################## ACTUALIZO VALORES DE NOTAS ##################
		   $sql = " UPDATE notas set "
			  ." nota3 = ?, "
			  ." faltas3 = ?, "
			  ." definitiva = ?, "
			  ." total_faltas = ? "
			  ." WHERE "
			  ." codnota = ?;
			   ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $nota3);
			$stmt->bindParam(2, $faltas3);
			$stmt->bindParam(3, $definitiva);
			$stmt->bindParam(4, $total_faltas);
			$stmt->bindParam(5, $codnota);
		
		   $nota3 = rount($_POST['nota3'][$i],1);
			$faltas3 = limpiar($_POST['faltas3'][$i]);
	      //$suma = ($row['nota1'] + $row['nota2'] + $_POST['nota3'][$i] + $row['nota4']);
	      $suma = ($row['nota1'] + $row['nota2'] + $_POST['nota3'][$i]);
		   $definitiva = rount($suma/3,1);
		   $total_faltas = ($row['faltas1'] + $row['faltas2'] + $_POST['faltas3'][$i] + $row['faltas4']);
		   $codnota = limpiar($_POST["codnota"][$i]);
		   $stmt->execute();
		   ################## ACTUALIZO VALORES DE NOTAS ##################

		   ############# CONSULTO CANTIDAD MATERIAS #############
        	$sql = "SELECT 
        	SUM(definitiva) AS suma_materias,
        	COUNT(codmateria) AS cantidad_materias 
        	FROM notas 
        	WHERE codest = '".limpiar($_POST["codest"][$i])."'
        	AND codperiodo = '".limpiar(decrypt($_POST['codperiodo']))."'";
        	foreach ($this->dbh->query($sql) as $row)
        	{
        		$this->p[] = $row;
        	}
        	$suma_materias = $row['suma_materias'];
        	$cantidad_materias = $row['cantidad_materias'];
        	############# CONSULTO CANTIDAD MATERIAS #############

		   ################## ACTUALIZO VALORES DE DEFINITIVA ##################
	      $sql = " UPDATE definitivas set "
				." nota_definitiva = ?, "
				." aprobo = ? "
			   ." WHERE "
			   ." codest = ? AND codperiodo = ?;
			   ";
		   $stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $nota_definitiva);
			$stmt->bindParam(2, $aprobo);
			$stmt->bindParam(3, $codest);
			$stmt->bindParam(4, $codperiodo);
		
			$nota_definitiva = rount($suma_materias/$cantidad_materias,1);
			$aprobo = limpiar($nota_definitiva <= 2.9 ? 0 : 1);
			$codest = limpiar($_POST["codest"][$i]);
			$codperiodo = limpiar(decrypt($_POST['codperiodo']));
		   $stmt->execute();
		   ################## ACTUALIZO VALORES DE DEFINITIVA ##################
		   }
	   }
	   ########################### PROCESO NOTA Nº3 ##############################

	} elseif ($_POST['trimestre'] == 4) {

		###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################
		for($i=0;$i<count($_POST['nota4']);$i++){  //recorro el array
        
         if (empty($_POST['nota4'][$i]) || trim($_POST['nota4'][$i])==""){
		      echo "2";
		      exit;
	      } else if ($_POST['nota4'][$i] > 5){
		      echo "3";
		      exit;
	      }
		}
		###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################

		########################### PROCESO NOTA Nº4 ##############################
		for($i=0;$i<count($_POST['codnota']);$i++){  //recorro el array
         if (!empty($_POST['codnota'][$i])) {
		    
	      ############# CONSULTO NOTAS #############
			$sql = "SELECT 
			nota1, faltas1, nota2, faltas2, nota3, faltas3, nota4, faltas4 
			FROM notas WHERE codnota = '".$_POST["codnota"][$i]."'";
			foreach ($this->dbh->query($sql) as $row)
			{
			   $this->p[] = $row;
			}
			############# CONSULTO NOTAS #############

		   ################## ACTUALIZO VALORES DE NOTAS ##################
		   $sql = " UPDATE notas set "
			  ." nota4 = ?, "
			  ." faltas4 = ?, "
			  ." definitiva = ?, "
			  ." total_faltas = ? "
			  ." WHERE "
			  ." codnota = ?;
			   ";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $nota4);
			$stmt->bindParam(2, $faltas4);
		   $stmt->bindParam(3, $definitiva);
			$stmt->bindParam(4, $total_faltas);
		   $stmt->bindParam(5, $codnota);
		
		   $nota4 = rount($_POST['nota4'][$i],1);
			$faltas4 = limpiar($_POST['faltas4'][$i]);
	      $suma = ($row['nota1'] + $row['nota2'] + $row['nota3'] + $_POST['nota4'][$i]);
		   $definitiva = rount($suma/4,1);
		   $total_faltas = ($row['faltas1'] + $row['faltas2'] + $row['faltas3'] + $_POST['faltas4'][$i]);
		   $codnota = limpiar($_POST["codnota"][$i]);
		   $stmt->execute();
		   ################## ACTUALIZO VALORES DE NOTAS ##################

		   ############# CONSULTO CANTIDAD MATERIAS #############
        	$sql = "SELECT 
        	SUM(definitiva) AS suma_materias,
        	COUNT(codmateria) AS cantidad_materias 
        	FROM notas 
        	WHERE codest = '".limpiar($_POST["codest"][$i])."'
        	AND codperiodo = '".limpiar(decrypt($_POST['codperiodo']))."'";
        	foreach ($this->dbh->query($sql) as $row)
        	{
        		$this->p[] = $row;
        	}
        	$suma_materias = $row['suma_materias'];
        	$cantidad_materias = $row['cantidad_materias'];
        	############# CONSULTO CANTIDAD MATERIAS #############
		    
			################## ACTUALIZO VALORES DE DEFINITIVA ##################
	      $sql = " UPDATE definitivas set "
				." nota_definitiva = ?, "
				." aprobo = ? "
			   ." WHERE "
			   ." codest = ? AND codperiodo = ?;
			   ";
		   $stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $nota_definitiva);
			$stmt->bindParam(2, $aprobo);
			$stmt->bindParam(3, $codest);
			$stmt->bindParam(4, $codperiodo);
		
			$nota_definitiva = rount($suma_materias/$cantidad_materias,1);
			$aprobo = limpiar($nota_definitiva <= 2.9 ? 0 : 1);
			$codest = limpiar($_POST["codest"][$i]);
			$codperiodo = limpiar(decrypt($_POST['codperiodo']));
		   $stmt->execute();
		   ################## ACTUALIZO VALORES DE DEFINITIVA ##################

		   }
	   }
	   ########################### PROCESO NOTA Nº4 ##############################

	}//FIN DE IF
	
	echo "<span class='fa fa-check-square-o'></span> LA CARGA DE NOTAS HA SIDO PROCESADA EXITOSAMENTE";
   exit;
}
############################# FUNCION PARA ACTUALIZAR NOTAS ###############################

######################### FUNCION BUSQUEDA NOTAS DE ESTUDIANTES #############################
public function BuscarNotasEstudiantes() 
   {
	self::SetNames();
	$sql = "SELECT * FROM estudiantes 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
	WHERE estudiantes.codest = ? 
	AND estudiantes.statusest = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_GET['codest']));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> EL ESTUDIANTE NO SE ENCUENTRA INSCRITO EN EL PERIODO ACTUAL, VERIFIQUE NUEVAMENTE POR FAVOR</center>";
	   echo "</div>";		
		exit;

   } else {

	$perid = "SELECT codperiodo, periodo 
	FROM periodoescolar 
	WHERE statusperiodo = '1'";
	foreach ($this->dbh->query($perid) as $rowcon)
	{
		$this->pcon[] = $rowcon;
	}
	$codperiodo = (empty($rowcon['codperiodo']) ? "" : $rowcon['codperiodo']);
	$periodo = (empty($rowcon['periodo']) ? "" : $rowcon['periodo']);

   $sql ="SELECT 
	estudiantes.codpadre,
   estudiantes.codest,
   estudiantes.cedest, 
   estudiantes.pnomest, 
   estudiantes.snomest, 
   estudiantes.papeest, 
   estudiantes.sapeest, 
   estudiantes.becado, 
   estudiantes.codseccion, 
   estudiantes.codturno, 
   estudiantes.codperiodo, 
   estudiantes.fnacest, 
   estudiantes.fechainscripcion, 
   padres.cedpadre, 
   padres.nompadre, 
   padres.apepadre, 
   padres.tlfpadre, 
   periodoescolar.periodo, 
   areas.nomarea, 
   materias.nommateria, 
   niveles.nivel, 
   grados.grado, 
   secciones.seccion, 
   turnos.turno, 
   notas.codnota, 
   notas.codmateria, 
   notas.nota1, 
   notas.faltas1, 
   notas.nota2,
   notas.faltas2, 
   notas.nota3, 
   notas.faltas3, 
   notas.nota4, 
   notas.faltas4, 
   notas.definitiva, 
   notas.literal, 
   notas.total_faltas, 
   valores_definitiva.nota_definitiva, 
   valores_definitiva.aprobo, 
   valores_definitiva.puesto 
   FROM (estudiantes 
   INNER JOIN notas ON estudiantes.codest = notas.codest) 
   INNER JOIN padres ON estudiantes.codpadre = padres.codpadre 
   LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
   LEFT JOIN materias ON notas.codmateria = materias.codmateria 
   LEFT JOIN areas ON areas.codarea = materias.codarea

	LEFT JOIN
      (SELECT
      coddefinitiva, codest, codperiodo, nota_definitiva, aprobo, puesto       
      FROM definitivas
      WHERE codest = '".$_GET['codest']."'
      AND codperiodo = '".$codperiodo."') valores_definitiva ON valores_definitiva.codest = estudiantes.codest

   WHERE notas.codest = ? 
   AND notas.codperiodo = '".$codperiodo."' 
   AND estudiantes.statusest = '1' 
   GROUP BY materias.codarea, materias.codmateria";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_GET['codest']));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{

		if(decrypt($_GET['c'])=="v"){ ?>
		<script type='text/javascript' language='javascript'>
	   alert('ESTE ESTUDIANTE NO TIENE NOTAS REGISTRADAS ACTUALMENTE, \nVERIFIQUE NUEVAMENTE POR FAVOR.')
		var ventana = window.self;
      ventana.opener = window.self;
      ventana.close(); 
      </script> 
		<?php 
	   exit;

   } else {

		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	   echo "<center><span class='fa fa-info-circle'></span> ESTE ESTUDIANTE NO TIENE NOTAS REGISTRADAS ACTUALMENTE, VERIFIQUE NUEVAMENTE POR FAVOR</center>";
	   echo "</div>";		
		exit;
	}

	} else {

		   while($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[]=$row;
			}
			return $this->p;
			$this->dbh=null;
	   }
	}
}
######################### FUNCION BUSQUEDA NOTAS DE ESTUDIANTES #############################

######################### FUNCION BUSQUEDA NOTAS POR CURSOS #############################
public function BuscarNotasxCursos() 
{
	self::SetNames();

	if ($_SESSION['acceso'] == "docente") {

		$sql = "SELECT * FROM asignaciones 
		INNER JOIN periodoescolar ON asignaciones.codperiodo = periodoescolar.codperiodo
		WHERE asignaciones.coddoc = ? 
		AND asignaciones.codturno = ? 
		AND asignaciones.codseccion = ? 
		AND periodoescolar.statusperiodo = 1";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindValue(1, trim($_SESSION['coddoc']));
		$stmt->bindValue(2, trim(decrypt($_GET['codturno'])));
		$stmt->bindValue(3, trim(decrypt($_GET['codseccion'])));
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "<div class='alert alert-danger'>";
			echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		   echo "<center><span class='fa fa-info-circle'></span> USTED NO TIENE ASIGNADO ESTE CURSO, VERIFIQUE NUEVAMENTE POR FAVOR</center>";
		   echo "</div>";		
			exit;
	   }
	}

	$sql = "SELECT * FROM estudiantes  
	INNER JOIN padres ON estudiantes.codpadre = padres.codpadre
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo 
	WHERE estudiantes.codseccion = ? 
	AND estudiantes.codturno = ? 
	AND estudiantes.statusest = 1 
	ORDER BY estudiantes.papeest";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codseccion'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codturno'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU B&Uacute;SQUEDA REALIZADA</center>";
	    echo "</div>";		
		exit;
    }
	else
	{
	while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################### FUNCION BUSQUEDA NOTAS POR CURSOS #############################

######################### FUNCION BUSQUEDA NOTAS POR PERIODOS #############################
public function BuscarNotasxCursosDos() 
{
	self::SetNames();
	$sql ="SELECT 
	estudiantes.codpadre,
   estudiantes.codest, 
	estudiantes.cedest, 
	estudiantes.pnomest, 
	estudiantes.snomest, 
	estudiantes.papeest, 
	estudiantes.sapeest, 
	estudiantes.becado,
	estudiantes.codseccion, 
	estudiantes.codturno, 
	estudiantes.codperiodo, 
	estudiantes.fnacest, 
	estudiantes.fechainscripcion, 
	padres.cedpadre, 
	padres.nompadre, 
	padres.apepadre, 
	padres.tlfpadre, 
	periodoescolar.periodo, 
	areas.nomarea, 
	materias.nommateria, 
	niveles.nivel, 
	grados.grado, 
	secciones.seccion, 
	turnos.turno, 
	notas.codnota, 
	notas.codmateria, 
	notas.nota1, 
	notas.faltas1, 
	notas.nota2, 
	notas.faltas2, 
	notas.nota3, 
	notas.faltas3, 
	notas.nota4, 
	notas.faltas4, 
	notas.definitiva, 
	notas.literal, 
	notas.total_faltas 
	FROM (estudiantes INNER JOIN notas ON estudiantes.codest = notas.codest) 
	INNER JOIN padres ON estudiantes.codpadre = padres.codpadre 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo 
	LEFT JOIN materias ON notas.codmateria = materias.codmateria 
	LEFT JOIN areas ON areas.codarea = materias.codarea 
	WHERE notas.codseccion = ? 
	AND notas.codturno = ? 
	ORDER BY estudiantes.papeest";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codseccion'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codturno'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-info-circle'></span> ESTE ESTUDIANTE NO TIENE NOTAS REGISTRADAS ACTUALMENTE</center>";
	    echo "</div>";		
		exit;

	} else {

	    while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
    }
}
######################### FUNCION BUSQUEDA NOTAS POR PERIODOS #############################

######################### FUNCION BUSQUEDA NOTAS POR PERIODOS #############################
public function BuscarNotasxPeriodos() 
{
	self::SetNames();
	$sql ="SELECT 
	estudiantes.codpadre,
   estudiantes.codest, 
	estudiantes.cedest, 
	estudiantes.pnomest, 
	estudiantes.snomest, 
	estudiantes.papeest, 
	estudiantes.sapeest, 
	estudiantes.becado, 
	estudiantes.codseccion, 
	estudiantes.codturno, 
	estudiantes.codperiodo, 
	estudiantes.fnacest, 
	estudiantes.fechainscripcion, 
	padres.cedpadre, 
	padres.nompadre, 
	padres.apepadre, 
	padres.tlfpadre, 
	periodoescolar.periodo, 
	areas.nomarea, 
	materias.nommateria, 
	niveles.nivel, 
	grados.grado, 
	secciones.seccion, 
	turnos.turno, 
	notas.codnota, 
	notas.codmateria, 
	notas.nota1, 
	notas.faltas1, 
	notas.nota2, 
	notas.faltas2, 
	notas.nota3, 
	notas.faltas3, 
	notas.nota4, 
	notas.faltas4, 
	notas.definitiva, 
	notas.literal, 
	notas.total_faltas, 
	valores_definitiva.nota_definitiva, 
	valores_definitiva.aprobo, 
	valores_definitiva.puesto 
	FROM (estudiantes INNER JOIN notas ON estudiantes.codest = notas.codest) 
	INNER JOIN padres ON estudiantes.codpadre = padres.codpadre 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo 
	LEFT JOIN materias ON notas.codmateria = materias.codmateria 
	LEFT JOIN areas ON areas.codarea = materias.codarea

	LEFT JOIN
      (SELECT
      coddefinitiva, codest, codperiodo, nota_definitiva, aprobo, puesto       
      FROM definitivas
      WHERE codest = '".$_GET['codest']."'
      AND codperiodo = '".limpiar(decrypt($_GET['codperiodo']))."') valores_definitiva ON valores_definitiva.codest = notas.codest

   WHERE notas.codest = ? 
   AND notas.codperiodo = ? 
   ORDER BY estudiantes.papeest";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_GET['codest']));
	$stmt->bindValue(2, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-info-circle'></span> ESTE ESTUDIANTE NO TIENE NOTAS REGISTRADAS EN EL PERIODO SELECCIONADO</center>";
	    echo "</div>";		
		exit;

	 } else {

		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################### FUNCION BUSQUEDA NOTAS POR PERIODOS #############################

######################## FUNCION BUSQUEDA DE ESTUIDANTE NUEVA NOTA ##########################
public function BuscarEstudianteNuevaNota() 
   {
	self::SetNames();
	$sql = "SELECT * FROM estudiantes 
	INNER JOIN padres ON padres.codpadre = estudiantes.codpadre 
	LEFT JOIN turnos ON estudiantes.codturno = turnos.codturno
	LEFT JOIN niveles ON estudiantes.codnivel = niveles.codnivel  
	LEFT JOIN grados ON estudiantes.codgrado = grados.codgrado
	LEFT JOIN secciones ON estudiantes.codseccion = secciones.codseccion  
	LEFT JOIN periodoescolar ON estudiantes.codperiodo = periodoescolar.codperiodo
	WHERE estudiantes.codest = ? 
	AND estudiantes.statusest = 1 
	ORDER BY estudiantes.papeest";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_GET['codest']));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-info-circle'></span> ESTE ESTUDIANTE NO SE ENCUENTRA INSCRITO EN EL PERIODO ACTUAL</center>";
	    echo "</div>";		
		exit;
	}
	else
	{
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
######################## FUNCION BUSQUEDA DE ESTUIDANTE NUEVA NOTA ##########################

######################### FUNCION BUSQUEDA NOTAS DE ESTUDIANTES #############################
public function VerificaNotasEstudiantes() 
  {
	self::SetNames();
	$sql ="SELECT * FROM notas 
	INNER JOIN turnos ON notas.codturno = turnos.codturno 
	INNER JOIN secciones ON secciones.codseccion = notas.codseccion 
	INNER JOIN grados ON secciones.codgrado = grados.codgrado 
	INNER JOIN niveles ON secciones.codnivel = niveles.codnivel 
	INNER JOIN periodoescolar ON periodoescolar.codperiodo = notas.codperiodo 
	LEFT JOIN materias ON notas.codmateria = materias.codmateria 
	LEFT JOIN areas ON areas.codarea = materias.codarea 
	WHERE notas.codest = ? 
	AND notas.codseccion = ? 
	AND notas.codturno = ? 
	AND notas.codperiodo = ? 
	GROUP BY materias.codarea, materias.codmateria";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codest'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codseccion'])));
	$stmt->bindValue(3, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(4, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num>0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-info-circle'></span> PARA PROCESAR NOTAS A ESTE ESTUDIANTE, DEBERA DE DIRIJIRSE AL MODULO DE REGISTRO DE NOTAS NORMALMENTE </center>";
	    echo "</div>";		
		exit;
		      
	} else {

	$sql ="SELECT * FROM notas 
	INNER JOIN turnos ON notas.codturno = turnos.codturno 
	INNER JOIN secciones ON notas.codseccion = secciones.codseccion 
	INNER JOIN grados ON secciones.codgrado = grados.codgrado 
	INNER JOIN niveles ON secciones.codnivel = niveles.codnivel 
	INNER JOIN periodoescolar ON periodoescolar.codperiodo = notas.codperiodo 
	LEFT JOIN materias ON notas.codmateria = materias.codmateria
	LEFT JOIN areas ON areas.codarea = materias.codarea
	WHERE notas.codseccion = ? 
	AND notas.codturno = ? 
	AND notas.codperiodo = ? 
	GROUP BY materias.codarea, materias.codmateria";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(decrypt($_GET['codseccion'])));
	$stmt->bindValue(2, trim(decrypt($_GET['codturno'])));
	$stmt->bindValue(3, trim(decrypt($_GET['codperiodo'])));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{

		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN NOTAS REGISTRADAS PARA ESTE CURSO, VERIFIQUE NUEVAMENTE POR FAVOR</center>";
	    echo "</div>";		
		exit;

	} else {

		    while($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[]=$row;
			}
			return $this->p;
			$this->dbh=null;
	    }
	}
}
######################### FUNCION BUSQUEDA NOTAS DE ESTUDIANTES #############################

############################# FUNCION PARA REGISTRAR NOTAS ###############################
public function RegistrarNotasNuevosInscritos()
{
	self::SetNames();
	if(empty($_POST["codturno"]) or empty($_POST["codnivel"]) or empty($_POST["codgrado"]) or empty($_POST["codseccion"]))
	{
		echo "1";
		exit;
	}
	
	###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################
	for($i=0;$i<count($_POST['nota1']);$i++){  //recorro el array
    
        if (empty($_POST['nota1'][$i]) || trim($_POST['nota1'][$i])==""){
	        echo "2";
	        exit;
        } else if ($_POST['nota1'][$i] > 5){
		    echo "3";
		    exit;
	    }
	}
	###################### AQUI VALIDO SI EXISTEN NOTAS EN BLANCO #######################
		
	########################### PROCESO PARA REGISTRO DE CARGA ##############################
	for($i=0;$i<count($_POST['codmateria']);$i++){  //recorro el array
        if (!empty($_POST['codmateria'][$i])) {
	    
			################## REGISTRO VALORES DE NOTAS ##################
			$query = "INSERT INTO notas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codest);
			$stmt->bindParam(2, $coddoc);
			$stmt->bindParam(3, $codnivel);
			$stmt->bindParam(4, $codgrado);
			$stmt->bindParam(5, $codseccion);
			$stmt->bindParam(6, $codturno);
			$stmt->bindParam(7, $codperiodo);
			$stmt->bindParam(8, $codmateria);
			$stmt->bindParam(9, $nota1);
			$stmt->bindParam(10, $faltas1);
			$stmt->bindParam(11, $nota2);
			$stmt->bindParam(12, $faltas2);
			$stmt->bindParam(13, $nota3);
			$stmt->bindParam(14, $faltas3);
			$stmt->bindParam(15, $nota4);
			$stmt->bindParam(16, $faltas4);
			$stmt->bindParam(17, $definitiva);
			$stmt->bindParam(18, $literal);
			$stmt->bindParam(19, $total_faltas);
			
			$codest = limpiar($_POST["codest"]);
			$coddoc = limpiar($_POST['coddoc'][$i]);
			$codnivel = limpiar(decrypt($_POST['codnivel']));
			$codgrado = limpiar(decrypt($_POST['codgrado']));
			$codseccion = limpiar(decrypt($_POST['codseccion']));
			$codturno = limpiar(decrypt($_POST['codturno']));
			$codperiodo = limpiar(decrypt($_POST['codperiodo']));
			$codmateria = limpiar(encrypt($_POST['codmateria'][$i]));
			$nota1 = rount($_POST['nota1'][$i],1);
			$faltas1 = limpiar($_POST['faltas1'][$i]);
			$nota2 = limpiar("0");
			$faltas2 = limpiar("0");
			$nota3 = limpiar("0");
			$faltas3 = limpiar("0");
			$nota4 = limpiar("0");
			$faltas4 = limpiar("0");
			$suma = ($_POST['nota1'][$i]);
		   $definitiva = rount($suma/1,1);
			$literal = limpiar("0");
			$total_faltas = ($_POST['faltas1'][$i]);
			$stmt->execute();
			################## REGISTRO VALORES DE NOTAS ##################

		   ############# CONSULTO CANTIDAD MATERIAS #############
        	$sql = "SELECT 
        	SUM(definitiva) AS suma_materias,
        	COUNT(codmateria) AS cantidad_materias 
        	FROM notas 
        	WHERE codest = '".limpiar($_POST["codest"])."'
        	AND codperiodo = '".limpiar(decrypt($_POST['codperiodo']))."'";
        	foreach ($this->dbh->query($sql) as $row)
        	{
        		$this->p[] = $row;
        	}
        	$suma_materias = $row['suma_materias'];
        	$cantidad_materias = $row['cantidad_materias'];
        	############# CONSULTO CANTIDAD MATERIAS #############

		   ############# VERIFICO VALORES EN DEFINITIVAS #############
		   $sql = " SELECT * FROM definitivas 
		   WHERE codest = '".limpiar($_POST["codest"])."'
        	AND codperiodo = '".limpiar(decrypt($_POST['codperiodo']))."'";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->execute();
		   $num = $stmt->rowCount();
		   if($num == 0)
		   {
			   ################## REGISTRO VALORES DE DEFINITIVA ##################
				$query = "INSERT INTO definitivas values (null, ?, ?, ?, ?, ?); ";
				$stmt = $this->dbh->prepare($query);
				$stmt->bindParam(1, $codest);
				$stmt->bindParam(2, $codperiodo);
				$stmt->bindParam(3, $nota_definitiva);
				$stmt->bindParam(4, $aprobo);
				$stmt->bindParam(5, $puesto);
				
				$codest = limpiar($_POST["codest"]);
				$codperiodo = limpiar(decrypt($_POST['codperiodo']));
				$nota_definitiva = rount($suma_materias/$cantidad_materias,1);
				$aprobo = limpiar($nota_definitiva <= 2.9 ? 0 : 1);
				$puesto = limpiar("0");
				$stmt->execute();
				################## REGISTRO VALORES DE DEFINITIVA ##################

			} else {

				################## ACTUALIZO VALORES DE DEFINITIVA ##################
		      $sql = " UPDATE definitivas set "
					." nota_definitiva = ?, "
					." aprobo = ? "
				   ." WHERE "
				   ." codest = ? AND codperiodo = ?;
				   ";
			   $stmt = $this->dbh->prepare($sql);
				$stmt->bindParam(1, $nota_definitiva);
				$stmt->bindParam(2, $aprobo);
				$stmt->bindParam(3, $codest);
				$stmt->bindParam(4, $codperiodo);
			
				$nota_definitiva = rount($suma_materias/$cantidad_materias,1);
				$aprobo = limpiar($nota_definitiva <= 2.9 ? 0 : 1);
				$codest = limpiar($_POST["codest"]);
				$codperiodo = limpiar(decrypt($_POST['codperiodo']));
			   $stmt->execute();
			   ################## ACTUALIZO VALORES DE DEFINITIVA ##################
			}
			############# VERIFICO VALORES EN DEFINITIVAS #############
	    }
    }
    ########################### PROCESO PARA REGISTRO DE CARGA ##############################

    echo "<span class='fa fa-check-square-o'></span> LA CARGA DE NOTAS HA SIDO PROCESADA EXITOSAMENTE";
    exit;
}
############################# FUNCION PARA REGISTRAR NOTAS ###############################

################################ FIN DE CLASE NOTAS DE ESTUDIANTES ###################################
























#################################### FUNCION VERIFICA MESES VENCIDOS ######################################
public function VerificaMesesVencidos()
{
	self::SetNames();
	$sql ="SELECT periodo FROM periodoescolar WHERE statusperiodo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
        echo "";
        exit;
	}
	else
	{
		$sql2 = "SELECT 
		periodoescolar.codperiodo, 
		periodoescolar.diasvence, 
		detallespagos.coddetalle, 
		detallespagos.mespago 
		FROM detallespagos  LEFT JOIN periodoescolar ON detallespagos.codperiodo = periodoescolar.codperiodo 
		WHERE detallespagos.statuspago = 0 
		AND periodoescolar.statusperiodo = 1";
		$array=array();
		foreach ($this->dbh->query($sql2) as $row)
		{
			$this->p2[] = $row;
		   $codigo = $row['coddetalle'];
		   $codperiodo = $row['codperiodo'];
		   $diasvence = $row['diasvence'];
			$array[]= $row['mespago'];
			
		   $sql = "UPDATE detallespagos  SET "
			 ." statuspago = ? "
			 ." WHERE "
			 ." codperiodo = $codperiodo 
			 AND mespago <= '".date('m')."' 
			 AND $diasvence < '".date('d')."' 
			 AND statuspago = '0';
			";
		   $stmt = $this->dbh->prepare($sql);
		   $stmt->bindParam(1, $statuspago);
			$statuspago = limpiar("2");
			$stmt->execute();
		}				
    }
}
#################################### FUNCION VERIFICA MESES VENCIDOS ######################################

#################################### FUNCION PARA CONTAR REGISTROS ###################################
public function ContarRegistros()
{
	if ($_SESSION['acceso'] == "administrador" || $_SESSION["acceso"]=="secretaria") {

		$sql = "SELECT
		(SELECT COUNT(*) FROM usuarios) AS user,
		(SELECT COUNT(*) FROM estudiantes WHERE statusest = '1') AS est,
		(SELECT COUNT(*) FROM padres WHERE statuspad = '1') AS tutor,
		(SELECT COUNT(*) FROM estudiantes WHERE sexoest = 'MASCULINO' AND statusest = '1') AS masculino,
		(SELECT COUNT(*) FROM estudiantes WHERE sexoest = 'FEMENINO' AND statusest = '1') AS femenino,
		(SELECT COUNT(*) FROM docentes) AS doc,
		(SELECT COUNT(*) FROM detallespagos WHERE statuspago = '1') AS totalpag,
		(SELECT COUNT(*) FROM detallespagos WHERE statuspago = '2') AS totalvenc,
		(SELECT COUNT(*) FROM detallespagos WHERE statuspago = '0') AS totalpend";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} elseif ($_SESSION['acceso'] == "docente") {

		$sql = "SELECT
		(SELECT COUNT(*) FROM estudiantes WHERE statusest = '1') AS est,
		(SELECT COUNT(*) FROM padres WHERE statuspad = '1') AS tutor,
		(SELECT COUNT(*) FROM estudiantes WHERE sexoest = 'MASCULINO' AND statusest = '1') AS masculino,
		(SELECT COUNT(*) FROM estudiantes WHERE sexoest = 'FEMENINO' AND statusest = '1') AS femenino,
		(SELECT COUNT(*) FROM asignaciones WHERE coddoc = '".limpiar($_SESSION["coddoc"])."') AS materias";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;

	} elseif ($_SESSION['acceso'] == "estudiante") {

		$sql = "SELECT
		(SELECT COUNT(*) FROM usuarios) AS user,
		(SELECT COUNT(*) FROM estudiantes WHERE statusest = '1') AS est,
		(SELECT COUNT(*) FROM padres WHERE statuspad = '1') AS tutor,
		(SELECT COUNT(*) FROM estudiantes WHERE sexoest = 'MASCULINO' AND statusest = '1') AS masculino,
		(SELECT COUNT(*) FROM estudiantes WHERE sexoest = 'FEMENINO' AND statusest = '1') AS femenino,
		(SELECT COUNT(*) FROM docentes) AS doc,
		(SELECT COUNT(*) FROM detallespagos WHERE codest = '".limpiar($_SESSION["codest"])."' AND statuspago = '1') AS totalpag,
		(SELECT COUNT(*) FROM detallespagos WHERE codest = '".limpiar($_SESSION["codest"])."' AND statuspago = '2') AS totalvenc,
		(SELECT COUNT(*) FROM detallespagos WHERE codest = '".limpiar($_SESSION["codest"])."' AND statuspago = '0') AS totalpend";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
		$this->dbh=null;
	}
}
	
public function ContarCuotas() 
{
    $sql = "SELECT count(*) FROM detallespagos  WHERE statuspago = '2'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
	$this->dbh=null;
}
#################################### FUNCION PARA CONTAR REGISTROS ###################################


}
#################################### AQUI TERMINA LA CLASE LOGIN ###################################
?>