<?php
require_once 'fpdf/pdf.php';
require_once 'fpdf/barcode.php';
require_once 'class/class.php';

$casos = [
  'USUARIOS'               => [
    'medidas' => ['L', 'mm', 'LEGAL'],
    'func'    => 'TablaListarUsuarios',
    'output'  => ['Listado de Usuarios.pdf', 'I'],
  ],
  'LOGS'                   => [
    'medidas' => ['L', 'mm', 'LEGAL'],
    'func'    => 'TablaListarLogs',
    'output'  => ['Listado Logs de Acceso.pdf', 'I'],
  ],
  'MATERIAS'            => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaListarMaterias',
    'output'  => ['Listado de Materias.pdf', 'I'],
  ],
  'MATERIASXCURSOS'              => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaListarMateriasCursos',
    'output'  => ['Listado de Materiasx Cursos.pdf', 'I'],
  ],
  'CAJAS'                => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaListarCajas',
    'output'  => ['Listado de Cajas.pdf', 'I'],
  ],
  'TICKETCIERRE'           => [
    'medidas'        => ['P', 'mm', 'cierre'],
    'func'           => 'TicketCierre',
    'setPrintFooter' => 'true',
    'output'         => ['Ticket de Cierre.pdf', 'I'],
  ],
  'ARQUEOS'                => [
    'medidas' => ['L', 'mm', 'LEGAL'],
    'func'    => 'TablaListarArqueos',
    'output'  => ['Listado de Arqueos.pdf', 'I'],
  ],
  'ARQUEOSXFECHAS'             => [
    'medidas' => ['L', 'mm', 'LEGAL'],
    'func'    => 'TablaListarArqueosFechas',
    'output'  => ['Listado de Arqueos x Fechas.pdf', 'I'],
  ],
  'TICKETMOVIMIENTO'           => [
    'medidas'        => ['P', 'mm', 'movimiento'],
    'func'           => 'TicketMovimiento',
    'setPrintFooter' => 'true',
    'output'         => ['Ticket de Movimiento.pdf', 'I'],
  ],
  'MOVIMIENTOS'             => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaListarMovimientos',
    'output'  => ['Listado de Movimientos.pdf', 'I'],
  ],
  'MOVIMIENTOSXFECHAS'             => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaListarMovimientosFechas',
    'output'  => ['Listado de Movimientos x Fechas.pdf', 'I'],
  ],
  'DOCENTES'            => [
    'medidas' => ['L', 'mm', 'LETTER'],
    'func'    => 'TablaListarDocentes',
    'output'  => ['Listado de Docentes.pdf', 'I'],
  ],
  'ASIGNACIONES'               => [
    'medidas' => ['L', 'mm', 'LETTER'],
    'func'    => 'TablaListarAsignaciones',
    'output'  => ['Listado de Asignaciones.pdf', 'I'],
  ],
  'ASIGNACIONESXDOCENTES'            => [
    'medidas' => ['L', 'mm', 'LETTER'],
    'func'    => 'TablaListarAsignacionesxDocentes',
    'output'  => ['Listado de Asignaciones x Docente.pdf', 'I'],
  ],
  'ESTUDIANTESXCURSOS'                 => [
    'medidas' => ['L', 'mm', 'LEGAL'],
    'func'    => 'TablaListarEstudiantesxCursos',
    'output'  => ['Listado de Estudiantes x Cursos.pdf', 'I'],
  ],
  'TUTORESXCURSOS'                => [
    'medidas' => ['L', 'mm', 'LEGAL'],
    'func'    => 'TablaListarTutoresxCursos',
    'output'  => ['Listado de Padres/Tutores x Cursos.pdf', 'I'],
  ],
  'COMPROBANTE'         => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaListarPresentaciones',
    'output'  => ['Comprobante de Pago.pdf', 'I'],
  ],
  'COMPROBANTEPAGOS'                => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaComprobantePagos',
    'output'  => ['Comprobante de Pago.pdf', 'I'],
  ],
  'PAGOSXFECHAS'               => [
    'medidas' => ['L', 'mm', 'LEGAL'],
    'func'    => 'TablaListarPagosxFechas',
    'output'  => ['Listado de Pagos x Fechas.pdf', 'I'],
  ],
  'PAGOSALDIA'          => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaListarPagosAlDia',
    'output'  => ['Listado de Pagos al Dia.pdf', 'I'],
  ],
  'PAGOSVENCIDOSXCURSOS'                => [
    'medidas' => ['L', 'mm', 'LEGAL'],
    'func'    => 'TablaListarPagosVencidosxCursos',
    'output'  => ['Listado de Pagos Vencidos por Cursos.pdf', 'I'],
  ],
  'PAGOSVENCIDOSXPERIODO'                => [
    'medidas' => ['L', 'mm', 'LEGAL'],
    'func'    => 'TablaListarPagosVencidosxPeriodo',
    'output'  => ['Listado de Pagos Vencidos por Periodo.pdf', 'I'],
  ],
  'AVISOCOBRANZA'      => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaCobranza',
    'output'  => ['Aviso de Cobranza.pdf', 'I'],
  ],
  'BOLETA'      => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaBoletin',
    'setPrintFooter' => 'true',
    'output'  => ['Boletin Escolar.pdf', 'I'],
  ],
  'BOLETAXCURSOS'              => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaBoletaxCursos',
    'output'  => ['Boleta x Cursos.pdf', 'I'],
  ],
  'BOLETAXPERIODO'            => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'TablaBoletaxPeriodo',
    'setPrintFooter' => 'true',
    'output'  => ['Boletin Escolar.pdf', 'I'],
  ],
  'ESTADISTICAS'             => [
    'medidas' => ['P', 'mm', 'A4'],
    'func'    => 'MuestraGrafica',
    'output'  => ['Grafico.pdf', 'I'],
  ],
];

$tipo = decrypt($_GET['tipo']);
if (!in_array($tipo, ['BOLETA', 'BOLETAXPERIODO'])) {
  //validarAccesos([]) or die;
}

ob_start();
$caso_data = $casos[$tipo];
$pdf       = new PDF(
  $caso_data['medidas'][0],
  $caso_data['medidas'][1],
  $caso_data['medidas'][2]
);
if (in_array($tipo, ['TICKETMOVIMIENTO','BOLETA', 'BOLETAXPERIODO'])) {
  $pdf->AutoPrint();
} 

$pdf->AddPage();
$pdf->{$caso_data['func']}();
$pdf->Output($caso_data['output'][0], $caso_data['output'][1]);
ob_end_flush();
?>